var ReportTemplate = (function () {
    function ReportTemplate(scope, template, notificationService, language, http, clientSettings, reportTemplateProviderService, modal, mailValidationService, mailProvider, userPreferencesService, printProvider) {
        var _this = this;
        this.Id = template.Id;
        this.Name = template.Name;
        this.Version = template.Version;
        this.UniqueGuid = template.UniqueGuid;
        this.HtmlTemplate = template.HtmlTemplate;
        this.Parameters = _.isUndefined(template.Parameters)
            ? []
            : _.map(template.Parameters, function (p) { return new ReportParameter(p); });
        this.Chapter = template.Chapter;
        this.IsHide = template.IsHide;
        this.ReportType = template.ReportType;
        this.HasStep = template.HasStep;
        this.PeriodStep = template.PeriodStep;
        this.Priority = template.Priority;
        this.ContentVersion = template.ContentVersion;
        this.IsAllowAnonymousView = template.IsAllowAnonymousView;
        this.language = language;
        this.http = http;
        this.clientSettings = clientSettings;
        this.Permissions = template.Permissions;
        this.ExportFileNameTemplate = template.ExportFileNameTemplate;
        this.ReportStartDateType = template.ReportStartDateType;
        this.ReportStartDateOffset = template.ReportStartDateOffset;
        this.ReportDuration = template.ReportDuration;
        this.Rules = _.map(template.Rules, function (item) {
            return new ReportRule(scope, _this.language, reportTemplateProviderService, notificationService, modal, _this, item, mailValidationService, userPreferencesService, printProvider);
        });
        this.watchFunctions = [];
        this.reportTemplateProviderService = reportTemplateProviderService;
        this.ReportDateSelectionFormat = template.ReportDateSelectionFormat;
        this.watchFunctions.push(scope.$watch(function () {
            return _this;
        }, function (after, before) {
            if (after == undefined || after === before)
                return;
            if (ReportTemplate.isEqual(after, before))
                return;
            if (after.UniqueGuid === before.UniqueGuid
                && (after.Id !== before.Id || after.Version !== before.Version))
                return;
            if (_this.ignoreChanges) {
                _this.isChanged = false;
                _this.ignoreChanges = false;
            }
            else {
                _this.isChanged = true;
            }
        }, true));
        this.isChanged = false;
    }
    ReportTemplate.prototype.destroy = function () {
        this.watchFunctions.filter(function (func) { return !_.isUndefined(func); }).forEach(function (func) { return func(); });
        this.Rules.forEach(function (rule) { return rule.destroy(); });
    };
    ReportTemplate.isEqual = function (template, other) {
        if (template.Name !== other.Name
            || template.Chapter !== other.Chapter
            || template.IsHide !== other.IsHide
            || template.ReportType !== other.ReportType
            || template.HasStep !== other.HasStep
            || template.PeriodStep !== other.PeriodStep
            || template.Id !== other.Id
            || template.Version !== other.Version
            || template.UniqueGuid !== other.UniqueGuid
            || template.Priority !== other.Priority
            || template.IsAllowAnonymousView !== other.IsAllowAnonymousView
            || template.ExportFileNameTemplate !== other.ExportFileNameTemplate
            || template.ReportDateSelectionFormat !== other.ReportDateSelectionFormat
            || template.ReportStartDateType !== other.ReportStartDateType
            || template.ReportStartDateOffset !== other.ReportStartDateOffset
            || template.ReportDuration !== other.ReportDuration) {
            return false;
        }
        if (_.isUndefined(template.Parameters) || _.isUndefined(other.Parameters)) {
            if (template.Parameters !== other.Parameters) {
                return false;
            }
        }
        else if (template.Parameters.length !== other.Parameters.length) {
            return false;
        }
        if (_.isUndefined(template.Rules) || _.isUndefined(other.Rules)) {
            if (template.Rules !== other.Rules) {
                return false;
            }
        }
        else if (template.Rules.length !== other.Rules.length) {
            return false;
        }
        return (_.every(template.Parameters, function (p, index) {
            return ReportParameter.isEqual(p, other.Parameters[index]);
        })
            && _.every(template.Rules, function (item, index) {
                return ReportRule.isEqual(item, other.Rules[index]);
            }));
    };
    return ReportTemplate;
}());
