var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var ReportViewCtrl = (function () {
    function ReportViewCtrl($scope, dateFilter, $window, $controller, $rootScope, $routeParams, $interval, $timeout, reportProvider, userSessionService, $http, $location, $modal, $q, $compile, $sce, notificationService, clientSettings, authentication, blockUI, reportSigningChecker, reportTemplateService, reportTemplateProvider, actionRepeaterService, language, exportService, mailProvider, userPreferencesService, printService, reportConfigurationProvider) {
        var _this = this;
        this.$scope = $scope;
        this.dateFilter = dateFilter;
        this.$window = $window;
        this.$rootScope = $rootScope;
        this.$routeParams = $routeParams;
        this.$interval = $interval;
        this.$timeout = $timeout;
        this.reportProvider = reportProvider;
        this.userSessionService = userSessionService;
        this.$http = $http;
        this.$location = $location;
        this.$modal = $modal;
        this.$q = $q;
        this.$compile = $compile;
        this.$sce = $sce;
        this.notificationService = notificationService;
        this.clientSettings = clientSettings;
        this.authentication = authentication;
        this.blockUI = blockUI;
        this.reportSigningChecker = reportSigningChecker;
        this.reportTemplateService = reportTemplateService;
        this.reportTemplateProvider = reportTemplateProvider;
        this.actionRepeaterService = actionRepeaterService;
        this.language = language;
        this.exportService = exportService;
        this.mailProvider = mailProvider;
        this.userPreferencesService = userPreferencesService;
        this.printService = printService;
        this.reportConfigurationProvider = reportConfigurationProvider;
        this.predefinedParametersValues = [];
        this.userDefinedParameters = [];
        this.reportViewElementId = 'reportViewHost';
        this.isReportsTreeOpened = true;
        this.exportFormats = [
            new UiSelectItem('Excel', 'Excel'),
            new UiSelectItem('Pdf', 'PDF'),
            new UiSelectItem('Html', 'Html'),
            new UiSelectItem('Xml', 'XML'),
            new UiSelectItem('Text', 'Txt'),
            new UiSelectItem('Csv', 'Csv'),
            new UiSelectItem('Json', 'Json'),
        ];
        this.editedCells = [];
        this.reportErrors = [];
        this.openedPages = {};
        this.userHasReportViewPermission = false;
        this.userHasReportCreatePermission = false;
        this.userHasReportAdministrationPermission = false;
        this.userHasReportEditPermission = false;
        this.userHasReportDeletePermission = false;
        this.userHasReportExportPermission = false;
        this.userHasReportViewManualEditsPermission = false;
        this.userHasReportMailSendingPermission = false;
        this.userHasReportPrintPermission = false;
        this.userHasReportRecreatePermission = false;
        this.userHasReportLockPermission = false;
        this.dateFormat = Date.masks.fullDateTime;
        this.cancelRequests = {};
        this.cancelGetReportRequestName = 'getReport';
        this.cancelCreateReportRequestName = 'createReport';
        this.isReportMoreButtonVisible = false;
        this.autoUpdateIntervals = [];
        this.scale = new Scale();
        this.reportActiveUsers = [];
        this.activeUsersUpdateTime = 15000;
        this.exportFormatsFilter = function (exportFormat) {
            if (_this.isSavedReport() || exportFormat.ident !== 'Json') {
                return exportFormat;
            }
        };
        this.autoUpdateAction = function () {
            var defer = _this.$q.defer();
            if (!_this.hasChanges()) {
                if (_this.isSavedReport()) {
                    _this.refreshReport().finally(defer.resolve);
                }
                else {
                    _this.createReport(false, true).finally(defer.resolve);
                }
            }
            return defer.promise;
        };
        var watchFunctions = [];
        angular.extend(this, $controller('BaseController', { $scope: $scope }));
        this.reportTree = new ReportTree(language, this.dateFilter);
        this.userPreferences = this.userPreferencesService.getPreferences();
        this.autoUpdateIntervals = __spreadArray([
            {
                name: this.language.getElementValue('autoUpdateOff'),
                ident: RepeatInterval.Off,
            }
        ], _.map(_.filter(Object.entries(RepeatInterval), function (entry) { return Number(entry[1]) > 0; }), function (entry) { return ({
            ident: entry[1],
            name: String.Format(_this.language.getElementValue('autoUpdateTimeHdr'), entry[1].toString())
        }); }), true);
        watchFunctions.push(this.$scope.$on('jstreeRefresh', function () {
            if (_this.isDisableRefreshReportTree) {
                return;
            }
            if (_this.report) {
                _this.reportTree.selectNode(_this.report.StartTime.toLongString(), _this.report.EndTime.toLongString(), _this.report.PredefinedValues.HashCode);
            }
            else if (_.isDefined(_this.$routeParams.start) &&
                _.isDefined(_this.$routeParams.predefinedValues || _this.$routeParams.predefinedValuesHashCode)) {
                if (_this.$routeParams.preview) {
                    _this.reportTree.deselectAll();
                }
                else {
                    _this.loadReportByUrl();
                    angular.element('#reportViewTab a').click();
                }
            }
            else {
                _this.reportTree.selectLastNode();
            }
        }));
        var selectedNodeEvent = null;
        var onNodeSelected = function (event, node, treeEvent) {
            if (treeEvent && (treeEvent.shiftKey || treeEvent.ctrlKey)) {
                return;
            }
            _this.saveReportChangeModalInstance()
                .then(function () {
                switch (node.type) {
                    case 'folder': {
                        _this.$location.replace();
                        _this.$location.url('reports').search({ templateGuid: _this.$routeParams.templateGuid });
                        break;
                    }
                    case 'file':
                    case 'errorfile': {
                        _this.$location.replace();
                        _this.$location.url('reports').search({
                            templateGuid: _this.$routeParams.templateGuid,
                            start: node.original.info.startDate.toLongString(),
                            stop: node.original.info.endDate.toLongString(),
                            predefinedValuesHashCode: node.original.info.predefinedValuesInfo.HashCode
                        });
                        break;
                    }
                }
            })
                .catch(function () {
                selectedNodeEvent();
                _this.reportTree.element.jstree().deselect_node(node);
                _this.reportTree.element.jstree().select_node(_this.reportTree.getNodeId(_this.report.Id));
                _this.$scope.$on('jstreeSelectNode', onNodeSelected);
            });
        };
        selectedNodeEvent = this.$scope.$on('jstreeSelectNode', onNodeSelected);
        watchFunctions.push(selectedNodeEvent);
        watchFunctions.push(this.$scope.$on('$routeUpdate', function () {
            var _a, _b, _c;
            if (_.isUndefined(_this.reportTreeData) ||
                _this.reportTreeData.uniqueGuid !== _this.$routeParams.templateGuid) {
                _this.currentPage = null;
                _this.loadReportTree(_this.$routeParams.templateGuid);
            }
            else {
                if (_.isDefined(_this.$routeParams.start) &&
                    _.isDefined(_this.$routeParams.predefinedValues || _this.$routeParams.predefinedValuesHashCode)) {
                    if (_this.$routeParams.preview) {
                        _this.reportTree.deselectAll();
                    }
                    else if (!_this.report
                        || ((_a = _this.report.PredefinedValues) === null || _a === void 0 ? void 0 : _a.HashCode) !== _this.$routeParams.predefinedValuesHashCode
                        || ((_b = _this.report.StartTime) === null || _b === void 0 ? void 0 : _b.toLongString()) !== _this.$routeParams.start
                        || ((_c = _this.report.EndTime) === null || _c === void 0 ? void 0 : _c.toLongString()) !== _this.$routeParams.stop) {
                        _this.loadReportByUrl();
                    }
                }
                else {
                    _this.reportTree.selectLastNode();
                }
            }
        }));
        watchFunctions.push(this.$rootScope.$on('$locationChangeStart', function (event, next) {
            if (_.isNull(_this.report)
                || next.contains('reports')
                || (_this.isSavedReport() && !_this.hasChanges())) {
                return;
            }
            var modalInstance = _this.$modal.open({
                templateUrl: 'ng1/dist/src/Common/Components/YesNoCancelModal.html',
                controller: 'yesNoCancelModalCtrl',
                windowClass: 'app-modal-window',
                backdrop: 'static',
                resolve: {
                    header: function () { return _this.language.getElementValue('reportUserHdr'); },
                    body: function () {
                        return String.Format(_this.language.getElementValue(_this.isSavedReport() ? 'reportSaveChangesHdr' : 'reportUnsavedHdr'), _this.report.Name);
                    },
                },
            });
            var newUrl = _this.$location.url();
            modalInstance.result.then(function (data) {
                if (data === 'ok') {
                    var promise = _this.isSavedReport()
                        ? _this.saveChanges()
                        : _this.saveReport();
                    promise.then(function () {
                        _.defer(function () { return _this.$location.url(newUrl); });
                    });
                }
                if (data === 'no') {
                    _this.editedCells.length = 0;
                    _this.report = null;
                    _this.$location.url(newUrl);
                }
            }, function () { });
            event.preventDefault();
        }));
        watchFunctions.push(this.$rootScope.$on('smsReportSignature.singatureRemoved', function () {
            if (_.isDefined(_this.report)) {
                _this.report.Signed = false;
            }
        }));
        watchFunctions.push($rootScope.$on('reportValueEdited', function (e, arg) { return _this.onReportValueEdited(arg); }));
        watchFunctions.push($rootScope.$on('reportValueStartEdit', function (e) { return _this.actionRepeaterService.pause(); }));
        this.mailProvider
            .isMailEnabled()
            .then(function (isEnable) {
            _this.isMailSendingEnabled = isEnable;
        })
            .catch(function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), data);
        });
        this.reportTemplateProvider.getAllReportTemplatesCalculationInfo().then(function (reportTemplatesShortInfo) {
            var _a;
            _this.reportTemplates = _.filter(reportTemplatesShortInfo, function (reportTemplate) { return _this.reportTemplateService.isReportTemplateVisible(reportTemplate); });
            if (_.isEmpty(_this.reportTemplates)) {
                return;
            }
            _this.selectedReportTemplate = (_a = _.find(_this.reportTemplates, function (template) { return template.uniqueGuid == _this.$routeParams.templateGuid; })) !== null && _a !== void 0 ? _a : _.first(_this.reportTemplates);
            _this.onTemplateSelected(_this.selectedReportTemplate);
        }, function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), data);
        });
        this.preview = _.isDefined($routeParams.preview)
            ? $routeParams.preview.toString() === 'true'
            : true;
        this.interval = {
            start: this.$routeParams.start,
            stop: this.$routeParams.stop
        };
        var intervalPromise = this.$interval(function () { return _this.loadReportActiveUsers(); }, this.activeUsersUpdateTime);
        this.reportConfigurationProvider
            .getReportConfiguration()
            .then(function (configuration) { return _this.useDemoDrivers = configuration.enableEmulation; })
            .catch(function (error) { return _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error); });
        this.$scope.$on('$destroy', function () {
            var _a;
            _this.$interval.cancel(intervalPromise);
            for (var key in _this.openedPages) {
                var element = _this.openedPages[key];
                if (element) {
                    element.remove();
                }
            }
            _this.openedPages = {};
            if (_this.reportViewElement) {
                _this.reportViewElement.empty();
                _this.reportViewElement = null;
            }
            for (var key in _this.cancelRequests) {
                _this.cancelRequests[key].resolve();
            }
            _this.actionRepeaterService.stop(true);
            (_a = _this.reportTree.element) === null || _a === void 0 ? void 0 : _a.jstree('destroy');
            for (var i = 0; i < watchFunctions.length; i++) {
                var func = watchFunctions[i];
                if (!_.isUndefined(func)) {
                    func();
                }
            }
            _this.report = null;
            _this.reportTree = null;
            _this.reportTreeData = null;
            _this.editedCells = [];
            _this.predefinedParametersValues = [];
            _this.userDefinedParameters = [];
        });
    }
    ReportViewCtrl.prototype.groupsOrderFilter = function (groups) {
        return _.sortBy(groups, function (g) { return g.name; });
    };
    ReportViewCtrl.prototype.onTemplateSelected = function (template) {
        var _this = this;
        var _a;
        this.actionRepeaterService.pause();
        var viewMode = (_a = this.dateTimePickerSettings) === null || _a === void 0 ? void 0 : _a.viewMode;
        var dateFormat = this.selectedReportTemplate.reportDateSelectionFormat;
        this.saveReportChangeModalInstance()
            .then(function () {
            _this.openedPages = {};
            if (template.uniqueGuid !== _this.$routeParams.templateGuid) {
                _this.$location.url('reports').search({ templateGuid: template.uniqueGuid });
            }
            else {
                _this.loadReportTree(template.uniqueGuid);
            }
            if (_.isUndefined(viewMode) || _this.getDateSelectionFormat(viewMode) !== dateFormat) {
                _this.dateTimePickerSettings = null;
                _this.$timeout(function () {
                    _this.dateTimePickerSettings = _this.getDatePickerSettings(_this.selectedReportTemplate.reportDateSelectionFormat);
                });
            }
        });
    };
    ReportViewCtrl.prototype.openPage = function (index) {
        if (this.report.pages[index] != this.currentPage) {
            this.showReportPage(this.report.pages[index]);
        }
    };
    ReportViewCtrl.prototype.unlockReport = function () {
        var _this = this;
        this.reportProvider
            .unlockReport(this.report.Id, this.reportTreeData.uniqueGuid)
            .then(function () {
            _this.report.IsLocked = false;
            _this.$rootScope.$broadcast('toggleEditable', _this.report.IsLocked);
            _this.notificationService.showMessage(_this.language.getElementValue('reportUnlockSuccessMsg'));
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('reportUnlockFailedMsg'), error);
        });
    };
    ReportViewCtrl.prototype.lockReport = function () {
        var _this = this;
        this.reportProvider
            .lockReport(this.report.Id, this.reportTreeData.uniqueGuid)
            .then(function () {
            _this.report.IsLocked = true;
            _this.$rootScope.$broadcast('toggleEditable', _this.report.IsLocked);
            _this.notificationService.showMessage(_this.language.getElementValue('reportLockSuccessMsg'));
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('reportLockFailedMsg'), error);
        });
    };
    ReportViewCtrl.prototype.valueClick = function (event) {
        var _this = this;
        if (event.target.tagName === 'INPUT')
            return;
        if (!this.userHasReportEditPermission ||
            !event.target.hasAttribute('editable') ||
            this.report.IsLocked ||
            this.reportSigningChecker.checkReportSigning()) {
            return;
        }
        this.actionRepeaterService.pause();
        var input = document.createElement('input');
        input.setAttribute('type', 'text');
        input.setAttribute('class', 'reportValueAsInput');
        input.setAttribute('value', event.target.hasAttribute('value')
            ? event.target.getAttribute('value')
            : event.target.getAttribute('originalvalue'));
        input.setAttribute('max-width', "".concat(event.target.offsetWidth, "px"));
        input.setAttribute('ng-blur', 'reportView.valueLostFocus($event)');
        input.setAttribute('ng-keydown', 'reportView.valueKeyPressed($event)');
        input.style.width = '100%';
        var onCellPaste = function (clipBoardEvent) {
            _this.handleTableValuePaste(clipBoardEvent);
            input.removeEventListener("paste", onCellPaste);
        };
        input.addEventListener("paste", onCellPaste);
        this.$compile(input)(this.$scope);
        event.target.innerHTML = '';
        event.target.appendChild(input);
        var strLength = input.value.length;
        input.focus();
        input.setSelectionRange(strLength, strLength);
    };
    ReportViewCtrl.prototype.valueLostFocus = function (event) {
        this.inputLostFocus(event);
    };
    ReportViewCtrl.prototype.valueKeyPressed = function (event) {
        var keyCode = event.which || event.keyCode;
        var keyEnterCode = 13;
        var keyEscCode = 27;
        if (keyCode === keyEnterCode) {
            this.inputLostFocus(event);
        }
        if (keyCode === keyEscCode) {
            var div_1 = event.target.parentElement;
            var roundedValue_1 = div_1.hasAttribute('value')
                ? div_1.getAttribute('value')
                : div_1.getAttribute('roundedvalue');
            var splitted_1 = div_1.hasAttribute('splitted');
            var self_1 = this;
            setTimeout(function () {
                div_1.innerHTML = '';
                div_1.innerHTML = splitted_1 ? self_1.divideByDigitGroups(roundedValue_1) : roundedValue_1;
            });
        }
    };
    ReportViewCtrl.prototype.isAllPredefinedValuesDefined = function () {
        var _a;
        if (((_a = this.predefinedParametersValues) === null || _a === void 0 ? void 0 : _a.length) > 0) {
            return _.all(this.predefinedParametersValues, function (info) {
                return _.isDefined(info) && _.isDefined(info.value) && _.isDefined(info.value.value);
            });
        }
        return true;
    };
    ReportViewCtrl.prototype.createReport = function (navigateToNewUrl, autoUpdate) {
        var _this = this;
        if (navigateToNewUrl === void 0) { navigateToNewUrl = true; }
        if (autoUpdate === void 0) { autoUpdate = false; }
        var defer = this.$q.defer();
        if (this.reportTreeData.hasStep && dateHelper.getDatePlusTimestamp(this.interval.start, this.reportTreeData.periodStep) > this.interval.stop) {
            this.notificationService.warnMessage(this.language.getElementValue('reportIncorrectSelectedMinIntervalMsg'));
            defer.reject();
            return defer.promise;
        }
        var data = {
            templateGuid: this.reportTreeData.uniqueGuid,
            startDate: this.interval.start,
            endDate: this.reportTreeData.reportType === 0
                ? this.interval.start
                : this.interval.stop,
            predefinedValues: _.map(this.predefinedParametersValues, function (parameterValue) {
                parameterValue.value.status = 5;
                return {
                    parameterIdent: parameterValue.parameter.Ident,
                    valueType: parameterValue.parameter.ParameterType,
                    value: parameterValue.value,
                };
            }),
            needSave: false
        };
        this.cancelRequests[this.cancelCreateReportRequestName] = this.$q.defer();
        this.$http
            .post(this.clientSettings.getServerInstance() + "/Report/CreateReport", data, this.getHeaders(autoUpdate, this.cancelCreateReportRequestName))
            .then(function (response) {
            var _a, _b;
            _this.report = new UserReport(_this.language.getElementValue('reportNewPageHdr'), response.data);
            if (!autoUpdate) {
                _this.loadReportActiveUsers();
            }
            _this.showReportPage(_this.report.pages[(_b = (_a = _this.currentPage) === null || _a === void 0 ? void 0 : _a.index) !== null && _b !== void 0 ? _b : 0]);
            _this.updateReportErrors();
            if (navigateToNewUrl) {
                _this.$location.url('reports').search({
                    templateGuid: _this.reportTreeData.uniqueGuid,
                    start: _this.report.StartTime.toLongString(),
                    stop: _this.report.EndTime.toLongString(),
                    predefinedValues: JSON.stringify(_this.report.PredefinedValues),
                    preview: true,
                });
            }
            if (_this.selectedAutoUpdateInterval !== RepeatInterval.Off) {
                _this.startAutoUpdate();
            }
            if (_this.useDemoDrivers && !autoUpdate) {
                _this.notificationService.infoMessage(_this.language.getElementValue('reportContainsDemoDataMsg'));
            }
            defer.resolve();
        }, function (error) {
            if (error.status === -1) {
                return;
            }
            var messageParts = error.data.detail.split(' ');
            if (messageParts[0] === 'ReportAlreadyExistsException') {
                _this.$location.url('reports').search({
                    templateGuid: data.templateGuid,
                    start: data.startDate.toLongString(),
                    stop: data.endDate.toLongString(),
                    predefinedValuesHashCode: messageParts[1],
                    preview: false,
                });
                _this.notificationService.infoMessage(_this.language.getElementValue('reportAlreadyExistMsg'));
                return;
            }
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
            defer.reject();
        });
        return defer.promise;
    };
    ReportViewCtrl.prototype.saveReport = function () {
        var _this = this;
        if (this.isSavedReport()) {
            return this.saveReportChanges();
        }
        var defer = this.$q.defer();
        this.$http
            .post(this.clientSettings.getServerInstance() + "/Report/SaveReport", { templateGuid: this.report.TemplateUniqueGuid, userReport: __assign(__assign({}, this.report), { Html: this.report.Html }) })
            .then(function (response) {
            _this.reportTree.addReportToTree(response.data, _this.reportTreeData);
            _this.isDisableRefreshReportTree = true;
            _this.saveReportChanges(response.data.Id).then(function () {
                _this.report = new UserReport(_this.language.getElementValue('reportNewPageHdr'), response.data);
                _this.isDisableRefreshReportTree = false;
                _this.renderReport(response.data);
                angular.element('#reportViewTab a').click();
                _this.$scope.$broadcast('jstreeRefresh');
                defer.resolve();
            });
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
            defer.reject(error);
        });
        return defer.promise;
    };
    ReportViewCtrl.prototype.saveReportChanges = function (reportId) {
        var _this = this;
        if (reportId === void 0) { reportId = null; }
        var defer = this.$q.defer();
        if (!_.any(this.editedCells)) {
            defer.resolve();
            return defer.promise;
        }
        if (!_.any(this.reportTreeData.signatures) ||
            !_.any(this.report.Changes, function (o) {
                return _.any(_this.reportTreeData.signatures, function (s) { return s.ident === o.parameterIdent; });
            }) ||
            _.all(this.editedCells, function (c) { return _.any(_this.reportTreeData.signatures, function (s) { return s.ident === c.ident; }); }) ||
            _.all(_.filter(this.editedCells, function (c) { return _.any(_this.reportTreeData.signatures, function (s) { return s.ident === c.ident; }); }), function (c) { return c.newValue === c.oldValue; })) {
            return this.saveChanges(reportId).then(function () {
                defer.resolve();
            });
        }
        else {
            var modalInstance = this.$modal.open({
                templateUrl: 'ng1/dist/src/UserDocuments/ReportSaveSignatureModal.html',
                controller: 'reportSaveSignatureModalCtrl',
                windowClass: 'app-modal-window report-reset-signature-question-modal-window',
                backdrop: 'static',
            });
            modalInstance.result.then(function (data) {
                if (data) {
                    _this.saveChanges(reportId);
                }
                defer.resolve();
            }, function () { return defer.resolve(); });
        }
    };
    ReportViewCtrl.prototype.reload = function () {
        var _this = this;
        if (!this.isSavedReport()) {
            this.createReport();
            return;
        }
        this.saveReportChangeModalInstance().then(function () {
            _this.refreshReport();
        });
    };
    ReportViewCtrl.prototype.openChangeLog = function () {
        var _this = this;
        this.$modal.open({
            templateUrl: 'ng1/dist/src/UserDocuments/ReportChangesLogModal.html',
            controller: 'ChangeLogCtrl',
            windowClass: 'modal-wide',
            backdrop: 'static',
            resolve: {
                changes: function () { return _this.report.Changes; },
            },
        });
    };
    ReportViewCtrl.prototype.sendingMail = function () {
        var _this = this;
        this.saveReportChangeModalInstance().then(function () {
            _this.$modal
                .open({
                templateUrl: 'ng1/dist/src/Common/Components/MailModal/MailSendModal.html',
                controller: 'mailSendModalCtrl',
                windowClass: 'app-modal-window',
                backdrop: 'static',
                resolve: {
                    subject: function () { return _this.report.Name; },
                    hideFileTypes: function () { return [6]; },
                },
            })
                .result.then(function (mailSendingInfo) {
                var _a;
                var sendingEmailAction = {
                    addressees: mailSendingInfo.addressees,
                    fileType: mailSendingInfo.fileType,
                    needArchive: mailSendingInfo.needArchive,
                    subject: mailSendingInfo.subject,
                    reportTemplateGuids: [_this.reportTreeData.uniqueGuid],
                    type: 2,
                };
                var sendEmailPromise = ((_a = _this.$routeParams.preview) !== null && _a !== void 0 ? _a : false)
                    ? _this.reportProvider.sendReportHtml(_this.report.Name, _this.report.StartTime, _this.report.EndTime, _this.selectedReportTemplate.exportFileNameTemplate, _this.report.Html, sendingEmailAction, _this.reportTreeData.uniqueGuid)
                    : _this.reportProvider.sendReport(_this.report.Id, sendingEmailAction, _this.reportTreeData.uniqueGuid);
                sendEmailPromise
                    .then(function () {
                    return _this.notificationService.showMessage(_this.language.getElementValue('mailWasSentSuccessfullyMsg'));
                })
                    .catch(function (error) {
                    return _this.notificationService.errorMessage(_this.language.getElementValue('mailWasntSentMsg'), error);
                });
            }, function () { });
        }, function () { });
    };
    ReportViewCtrl.prototype.exportTo = function (webMethodName) {
        if (this.isSavedReport()) {
            this.exportService.export('/ReportExport/ExportTo' + webMethodName + '?reportId=' + this.report.Id);
        }
        else {
            var params = {
                reportName: this.report.Name,
                reportStartDate: this.report.StartTime,
                reportEndDate: this.report.EndTime,
                exportFileNameTemplate: this.selectedReportTemplate.exportFileNameTemplate,
                html: this.report.Html
            };
            this.exportService.export('/ReportExport/ExportTo' + webMethodName, params);
        }
    };
    ReportViewCtrl.prototype.print = function () {
        if (this.isSavedReport()) {
            this.printService.printPdf('/ReportPrint/GetPdf?id=' + this.report.Id);
        }
        else {
            var params = {
                reportName: this.report.Name,
                reportStartDate: this.report.StartTime,
                reportEndDate: this.report.EndTime,
                exportFileNameTemplate: this.selectedReportTemplate.exportFileNameTemplate,
                html: this.report.Html,
            };
            this.printService.printPdf('/ReportExport/ExportToPdf', params);
        }
    };
    ReportViewCtrl.prototype.showInfo = function () {
        var _this = this;
        this.$modal.open({
            templateUrl: 'ng1/dist/src/UserDocuments/ReportInfo/ReportInfoModal.html',
            controller: 'reportInfoModalCtrl',
            backdrop: 'static',
            resolve: {
                report: function () { return _this.report; },
            },
        }).result.then(function (enabledRulesIndexes) {
            _this.reportProvider.enableRules(_this.report.Id, enabledRulesIndexes)
                .then(function () { return _this.notificationService.showMessage(_this.language.getElementValue('reportRulesEnabledSuccessMsg')); })
                .catch(function (error) { return _this.notificationService.errorMessage(_this.language.getElementValue('reportRulesEnabledFailedMsg'), error.data); });
        }, function () { });
    };
    ReportViewCtrl.prototype.openReportTemplate = function () {
        this.$location.url('report-templates').search({ uniqueGuid: this.reportTreeData.uniqueGuid });
    };
    ReportViewCtrl.prototype.recalcReport = function () {
        var _this = this;
        this.saveReportChangeModalInstance().then(function () {
            _this.$modal
                .open({
                templateUrl: 'ng1/dist/src/UserDocuments/ReportRecalculationModal/ReportRecalcModal.html',
                controller: 'ReportRecalcModalController',
                windowClass: 'app-modal-window report-recalc-modal-window',
                backdrop: 'static',
                resolve: {
                    report: function () {
                        return new ReportOperationInfo.ReportInfo(_this.report.Id, _this.report.TemplateId, _this.report.StartTime, _this.report.EndTime, _this.report.PredefinedValues);
                    },
                    reports: function () { return _this.reportTree.getReportsInfo(); },
                    templateGuid: function () { return _this.reportTreeData.uniqueGuid; },
                },
            })
                .result.then(function (recalcResults) {
                if (_.isUndefined(recalcResults) || recalcResults.length === 0) {
                    return;
                }
                var updatedNodes = [];
                _.forEach(recalcResults, function (result) {
                    var message = _this.reportTree.updateTreeNodeAfterRecalc(result, updatedNodes);
                    if (result.success) {
                        _this.notificationService.showMessage(message.message);
                    }
                    else {
                        _this.notificationService.errorMessage(message.message, message.details);
                    }
                });
                var recalcedReport = _.find(recalcResults, function (r) { return r.value.Id === _this.report.Id; }).value;
                _this.editedCells.length = 0;
                _this.report = new UserReport(_this.language.getElementValue('reportNewPageHdr'), recalcedReport);
                _this.renderReport(_this.report);
                _this.showReportPage();
                _this.updateReportErrors();
                _this.reportTree.refreshCalculationStateOfParentNodes(updatedNodes);
                _this.updateReportTemplateCalculationStatus();
            }, function () { });
        }, function () { });
    };
    ReportViewCtrl.prototype.isAnyReportSelected = function () {
        return _.any(this.reportTree.getSelectedReportsInfo());
    };
    ReportViewCtrl.prototype.deleteReports = function () {
        var _this = this;
        var selectedReportsInfo = this.reportTree.getSelectedReportsInfo();
        this.$modal
            .open({
            templateUrl: 'ng1/dist/src/UserDocuments/ReportDeleteModal.html',
            controller: 'deleteReportCtrl',
            backdrop: 'static',
            resolve: {
                templateName: function () { return _this.reportTreeData.name; },
                reportTimestamps: function () { return _.map(selectedReportsInfo, function (node) { return node.startDate; }); },
            },
        })
            .result.then(function () {
            var userReportsDeleteInfo = {
                templateName: _this.reportTreeData.name,
                reports: _.map(selectedReportsInfo, function (r) {
                    return {
                        id: r.id,
                        interval: new TimeInterval(r.startDate, r.endDate),
                    };
                }),
            };
            _this.reportProvider
                .deleteReports(userReportsDeleteInfo, _this.reportTreeData.uniqueGuid)
                .then(function () {
                _this.report = null;
                _this.reportTree.deleteReportsFromTree(selectedReportsInfo);
                _this.updateReportTemplateCalculationStatus();
                _this.updateReportErrors();
                _this.$location.url('reports').search({ templateGuid: _this.$routeParams.templateGuid });
                _this.notificationService.showMessage(_this.language.getElementValue(selectedReportsInfo.length > 1
                    ? 'reportsSuccessDeleteMsg'
                    : 'reportSuccessDeleteMsg'));
            })
                .catch(function (arg) {
                _this.notificationService.errorMessage(_this.language.getElementValue(selectedReportsInfo.length > 1 ? 'reportsFailedDeleteMsg' : 'reportFailedDeleteMsg'), arg.data);
            });
        }, function () { });
    };
    ReportViewCtrl.prototype.generateReportByQueryLink = function () {
        var predefinedValues = _.map(this.predefinedParametersValues, function (parameter) {
            return {
                parameterIdent: parameter.parameter.Ident,
                valueType: parameter.parameter.ParameterType,
                value: parameter.value
            };
        });
        var url = this.getUrl() +
            "/ReportExport/OpenReportByQuery" +
            "?templateGuid=" + this.selectedReportTemplate.uniqueGuid +
            "&startDate=" + DateExternalFormatParser.deepTransformDates(this.interval.start) +
            "&endDate=" + DateExternalFormatParser.deepTransformDates(this.interval.stop) +
            "&predefinedValues=" + encodeURIComponent(JSON.stringify(predefinedValues));
        return url;
    };
    ReportViewCtrl.prototype.generateReportByIdLink = function () {
        return this.getUrl() + "/ReportExport/OpenReportById" + "?reportId=" + this.report.Id;
    };
    ReportViewCtrl.prototype.generateLastReportLink = function () {
        var url = this.getUrl() +
            "/ReportExport/OpenLastReport" +
            "?templateGuid=" + this.selectedReportTemplate.uniqueGuid;
        return url;
    };
    ReportViewCtrl.prototype.toggleSidebar = function () {
        var sidebarreportTreeId = '#reportTreeViewSidebar';
        var sidebarViewId = '#reportsTreeSidebar';
        var templateContainerId = '#reportContainer';
        var sideBarReportTreeWidthClosed = 17;
        var sideBarReportTreeWidthOpened = 337;
        var animationDuration = 200;
        var animationQueue = false;
        if (this.isReportsTreeOpened) {
            angular.element(sidebarreportTreeId).animate({ width: sideBarReportTreeWidthClosed }, { duration: animationDuration, queue: animationQueue });
            angular.element(sidebarViewId).animate({ width: sideBarReportTreeWidthClosed }, { duration: animationDuration, queue: animationQueue });
            angular.element(templateContainerId).animate({ 'padding-left': sideBarReportTreeWidthClosed }, { duration: animationDuration, queue: animationQueue });
        }
        else {
            angular.element(sidebarreportTreeId).animate({ width: sideBarReportTreeWidthOpened }, { duration: animationDuration, queue: animationQueue });
            angular.element(sidebarViewId).animate({ width: sideBarReportTreeWidthOpened - 15 }, { duration: animationDuration, queue: animationQueue });
            angular.element(templateContainerId).animate({ 'padding-left': sideBarReportTreeWidthOpened }, { duration: animationDuration, queue: animationQueue });
        }
        this.isReportsTreeOpened = !this.isReportsTreeOpened;
    };
    ReportViewCtrl.prototype.containsPredefinedParams = function () {
        var _a, _b;
        return _.isDefined((_a = this.reportTreeData) === null || _a === void 0 ? void 0 : _a.predefinedParameters) && _.any((_b = this.reportTreeData) === null || _b === void 0 ? void 0 : _b.predefinedParameters);
    };
    ;
    ReportViewCtrl.prototype.getPredefinedValue = function (value) {
        var _a;
        if (Array.isArray(value)) {
            return _.find(value[0], function (i) { return i[2] === true; })[0];
        }
        if (_.isDefined(value.Variants)) {
            return (_a = _.find(value.Variants, function (i) { return i.IsSelected; })) === null || _a === void 0 ? void 0 : _a.Name;
        }
        if (_.isDefined(value.Name)) {
            return value.Name;
        }
        return value;
    };
    ReportViewCtrl.prototype.isShowParametersPanel = function () {
        var _a;
        return _.isDefined((_a = this.report) === null || _a === void 0 ? void 0 : _a.PredefinedValues)
            ? Object.keys(this.report.PredefinedValues.ParameterValues).length > 0
            : false;
    };
    ReportViewCtrl.prototype.isSavedReport = function () {
        return this.report && this.report.Id > 0;
    };
    ReportViewCtrl.prototype.getUrl = function () {
        return "".concat(this.$location.protocol(), "://").concat(this.$location.host(), ":").concat(this.$location.port()).concat(this.clientSettings.getServerInstance());
    };
    ReportViewCtrl.prototype.initPredefinedParameters = function () {
        var _this = this;
        var templatePredefinedParameters = _.map(this.reportTreeData.predefinedParameters, function (predefinedParameter) {
            var value = new ReportValue();
            return new ParameterWithValue(predefinedParameter, value);
        });
        var predefinedParametersValuesFromPreviousTemplate = _.filter(this.predefinedParametersValues, function (parameterWithValue) {
            return _.any(_this.reportTreeData.predefinedParameters, function (parameter) {
                return ReportParameter.isEqual(parameter, parameterWithValue.parameter);
            });
        });
        var urlPredefinedParameters = _.isDefined(this.$routeParams.predefinedValues) ? JSON.parse(this.$routeParams.predefinedValues) : undefined;
        var urlPredefinedParameterValues = _.isDefined(urlPredefinedParameters) ? _.map(urlPredefinedParameters, function (urlPredefinedParameter) {
            var parameterValue = _.find(templatePredefinedParameters, function (treeParameterValue) { return treeParameterValue.parameter.Ident === urlPredefinedParameter.parameterIdent; });
            if (_.isDefined(parameterValue.value)) {
                parameterValue.value.value = urlPredefinedParameter.value;
            }
            return parameterValue;
        }) : [];
        this.userDefinedParameters = __spreadArray(__spreadArray([], urlPredefinedParameterValues, true), _.filter(predefinedParametersValuesFromPreviousTemplate, function (parameterFromPreviousTemplate) {
            return _.all(urlPredefinedParameterValues, function (urlParameters) { return urlParameters.parameter.Ident !== parameterFromPreviousTemplate.parameter.Ident; });
        }), true);
        this.predefinedParametersValues = _.map(templatePredefinedParameters, function (treeParameterValue) {
            var _a;
            return (_a = _.find(_this.userDefinedParameters, function (userDefinedParameter) { return userDefinedParameter.parameter.Ident === treeParameterValue.parameter.Ident; })) !== null && _a !== void 0 ? _a : treeParameterValue;
        });
    };
    ReportViewCtrl.prototype.divideByDigitGroups = function (number) {
        if (number.indexOf('.') === -1) {
            return number.replace(/(\d)(?=(\d\d\d)+([^\d]|$))/g, '$1 ');
        }
        return (number.slice(0, number.indexOf('.')).replace(/(\d)(?=(\d\d\d)+([^\d]|$))/g, '$1 ') +
            number.slice(number.indexOf('.')));
    };
    ReportViewCtrl.prototype.inputLostFocus = function (event) {
        var _this = this;
        event.target.setAttribute('ng-blur', '');
        this.$compile(event.target)(this.$scope);
        var div = event.target.parentElement;
        var ts = div.getAttribute('ts');
        var ident = div.getAttribute('ident');
        var originalValue = div.getAttribute('originalvalue');
        var decimal = Number.parseInt(div.getAttribute('decimal'));
        var splitted = div.hasAttribute('splitted');
        var newValue = event.target.value;
        var previousValue = div.getAttribute('value') || originalValue;
        var isError = !div.hasAttribute('allowstrings') && newValue !== '' && !$.isNumeric(newValue);
        var self = this;
        this.$timeout(function () {
            if (previousValue !== newValue && !isError) {
                var displayedValue = !_.isNaN(decimal)
                    ? Number.parseFloat(newValue).toFixed(decimal)
                    : newValue;
                div.innerHTML = '';
                div.innerHTML = splitted ? self.divideByDigitGroups(displayedValue) : displayedValue;
                div.setAttribute('value', newValue);
                if (newValue !== originalValue) {
                    div.setAttribute('edited', '');
                }
            }
            else {
                var displayedValue = !_.isNaN(decimal)
                    ? Number.parseFloat(previousValue).toFixed(decimal)
                    : previousValue;
                div.innerHTML = '';
                div.innerHTML = splitted ? self.divideByDigitGroups(displayedValue) : displayedValue;
            }
            if (newValue !== originalValue && !isError) {
                var change = {
                    newValue: newValue,
                    oldValue: originalValue,
                    timestamp: ts,
                    ident: ident,
                };
                self.onReportValueEdited(change);
            }
            else {
                self.editedCells = _.filter(self.editedCells, function (item) {
                    return !(item.ident === ident && item.timestamp === ts);
                });
            }
            event.target.remove();
            if (!_this.hasChanges() && _this.selectedAutoUpdateInterval !== RepeatInterval.Off) {
                _this.actionRepeaterService.resume();
            }
        });
    };
    ReportViewCtrl.prototype.onReportValueEdited = function (change) {
        this.actionRepeaterService.pause();
        var changes = _.find(this.editedCells, function (item) {
            return item.ident === change.ident && item.timestamp === change.timestamp;
        });
        if (changes == undefined) {
            changes = change;
            this.editedCells.push(changes);
            var self_2 = this;
            setTimeout(function () {
                self_2.$scope.$apply();
            }, 300);
        }
        else {
            changes.newValue = change.newValue;
        }
    };
    ReportViewCtrl.prototype.saveReportChangeModalInstance = function () {
        var _this = this;
        var defer = this.$q.defer();
        if (!_.any(this.editedCells)) {
            defer.resolve();
            return defer.promise;
        }
        this.$modal
            .open({
            templateUrl: 'ng1/dist/src/Common/Components/YesNoCancelModal.html',
            controller: 'yesNoCancelModalCtrl',
            windowClass: 'app-modal-window',
            backdrop: 'static',
            resolve: {
                header: function () { return _this.language.getElementValue('reportUserHdr'); },
                body: function () { return String.Format(_this.language.getElementValue('reportSaveChangesHdr'), _this.report.Name); },
            },
        })
            .result.then(function (data) {
            if (data === 'ok') {
                _this.saveChanges().then(function () {
                    _this.showReportPage();
                    defer.resolve();
                });
            }
            if (data === 'no') {
                _this.editedCells.length = 0;
                _this.showReportPage();
                defer.resolve();
            }
            if (data === 'cancel') {
                defer.reject();
            }
        }, function () { });
        return defer.promise;
    };
    ReportViewCtrl.prototype.saveChanges = function (reportId) {
        var _this = this;
        if (reportId === void 0) { reportId = null; }
        this.blockUI.start();
        var defer = this.$q.defer();
        this.$http
            .post(this.clientSettings.getServerInstance() + '/Report/SaveReportChanges', {
            reportId: reportId !== null && reportId !== void 0 ? reportId : this.report.Id,
            changes: this.editedCells,
            templateGuid: this.reportTreeData.uniqueGuid,
        })
            .then(function (response) {
            _this.renderReport(response.data);
            defer.resolve();
            _this.blockUI.stop();
            _this.notificationService.showMessage(_this.language.getElementValue('changesSuccessSaveMsg'));
            _this.updateReportTemplateCalculationStatus();
        })
            .catch(function (arg) {
            defer.reject();
            _this.blockUI.stop();
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), arg);
        })
            .finally(function () {
            if (_this.selectedAutoUpdateInterval !== RepeatInterval.Off) {
                _this.actionRepeaterService.resume();
            }
        });
        return defer.promise;
    };
    ReportViewCtrl.prototype.refreshReport = function () {
        var _this = this;
        var defer = this.$q.defer();
        this.$http.post(this.clientSettings.getServerInstance() + "/Report/RefreshReport", {
            reportId: this.report.Id,
            templateGuid: this.reportTreeData.uniqueGuid
        }, this.getHeaders(true, undefined))
            .then(function (response) {
            _this.renderReport(response.data, true);
            defer.resolve();
        })
            .catch(function () {
            defer.reject();
        });
        return defer.promise;
    };
    ReportViewCtrl.prototype.loadReport = function (isTriggeredByAutoUpdate) {
        var _this = this;
        if (isTriggeredByAutoUpdate === void 0) { isTriggeredByAutoUpdate = false; }
        var defer = this.$q.defer();
        var reportInfo = {
            templateGuid: this.$routeParams.templateGuid,
            startDate: Date.fromStringDate(this.$routeParams.start),
            endDate: _.isDefined(this.$routeParams.stop)
                ? Date.fromStringDate(this.$routeParams.stop)
                : Date.fromStringDate(this.$routeParams.start),
            predefinedValuesHashCode: this.$routeParams.predefinedValuesHashCode,
        };
        this.cancelRequests[this.cancelGetReportRequestName] = this.$q.defer();
        this.$http.post(this.clientSettings.getServerInstance() + "/Report/GetReport", reportInfo, this.getHeaders(isTriggeredByAutoUpdate, this.cancelGetReportRequestName))
            .then(function (response) {
            _this.currentPage = null;
            if (_.isUndefined(_this.report) || response.data.Id !== _this.report.Id) {
                _this.loadReportActiveUsers();
            }
            if (!_this.hasChanges()) {
                _this.renderReport(response.data, isTriggeredByAutoUpdate);
            }
            if (_this.selectedAutoUpdateInterval !== RepeatInterval.Off) {
                _this.startAutoUpdate();
            }
            defer.resolve(response.data);
        })
            .catch(function (error) {
            if (error.status === -1) {
                return;
            }
            _this.notificationService.errorMessage(_this.language.getElementValue('reportErrorOpenPageMsg'), error);
            defer.reject();
        });
        return defer.promise;
    };
    ReportViewCtrl.prototype.setResetCarousel = function (resetFunction) {
        this.resetCarousel = resetFunction;
    };
    ReportViewCtrl.prototype.getDateSelectionFormat = function (viewMode) {
        switch (viewMode) {
            case 'days':
                return 0;
            case 'months':
                return 1;
            case 'years':
                return 2;
            default:
                return 0;
        }
    };
    ReportViewCtrl.prototype.renderReport = function (report, isTriggeredByAutoUpdate) {
        var _a;
        if (isTriggeredByAutoUpdate === void 0) { isTriggeredByAutoUpdate = false; }
        if (report.RecalculationState !== 0 && !isTriggeredByAutoUpdate) {
            this.notificationService.warnMessage(this.language.getElementValue('waitingRecalculationReportStatusMsg'));
        }
        this.editedCells.length = 0;
        this.openedPages = {};
        var userReport = new UserReport(this.language.getElementValue('reportNewPageHdr'), report);
        if (_.isDefined(this.currentPage) && angular.equals((_a = this.report) === null || _a === void 0 ? void 0 : _a.UpdatedDate, userReport === null || userReport === void 0 ? void 0 : userReport.UpdatedDate)) {
            return;
        }
        this.report = userReport;
        if (_.isDefined(this.resetCarousel)) {
            this.resetCarousel();
        }
        this.showReportPage();
        this.updateReportErrors();
        var updatedNodes = [];
        this.reportTree.updateTreeNode(report.Id, report.CalculationResult, updatedNodes);
        this.reportTree.refreshCalculationStateOfParentNodes(updatedNodes);
        this.updateReportTemplateCalculationStatus();
    };
    ReportViewCtrl.prototype.showReportPage = function (page) {
        var _this = this;
        var _a;
        var self = this;
        if (_.isUndefined(page)) {
            page = this.currentPage
                ? (_a = _.find(this.report.pages, function (p) { return p.settings.name === _this.currentPage.settings.name; })) !== null && _a !== void 0 ? _a : this.report.pages[0]
                : this.report.pages[0];
            if (_.isUndefined(page)) {
                throw new Error(this.language.getElementValue('reportErrorNotExistsAnyPages'));
            }
        }
        if (_.isUndefined(_.first(this.reportViewElement))) {
            this.reportViewElement = angular.element('#' + this.reportViewElementId);
        }
        this.reportSigningChecker.deleteAll();
        while (this.reportViewElement[0].firstChild) {
            this.reportViewElement[0].removeChild(this.reportViewElement[0].firstChild);
        }
        var reportCompiled;
        if (this.openedPages[page.index] && this.isSavedReport()) {
            reportCompiled = this.openedPages[page.index];
        }
        else {
            reportCompiled = this.$compile(page.html)(this.$scope);
            this.openedPages[page.index] = reportCompiled;
        }
        if (!_.isDefined(page.settings.size)) {
            reportCompiled.css({
                "width": "".concat(page.settings.size.width, "mm"),
                "height": "".concat(page.settings.size.height, "mm"),
                "padding": "".concat(page.settings.paddings.toCssString()),
                "margin": '0 auto'
            });
        }
        this.reportViewElement.empty().append(reportCompiled);
        this.currentPage = page;
    };
    ReportViewCtrl.prototype.loadReportTree = function (templateGuid) {
        var _this = this;
        var _a, _b, _c, _d, _e, _f, _g, _h;
        if (_.isUndefined(templateGuid)) {
            return;
        }
        this.selectedReportTemplate = _.find(this.reportTemplates, function (template) { return template.uniqueGuid === templateGuid; });
        var previousReportTemplatePeriodSettings = {
            reportType: (_a = this.currentReportTemplatePeriodSettings) === null || _a === void 0 ? void 0 : _a.reportType,
            reportStartDateType: (_b = this.currentReportTemplatePeriodSettings) === null || _b === void 0 ? void 0 : _b.reportStartDateType,
            reportStartDateOffset: (_c = this.currentReportTemplatePeriodSettings) === null || _c === void 0 ? void 0 : _c.reportStartDateOffset,
            reportDuration: (_d = this.currentReportTemplatePeriodSettings) === null || _d === void 0 ? void 0 : _d.reportDuration
        };
        this.currentReportTemplatePeriodSettings = {
            reportType: (_e = this.selectedReportTemplate) === null || _e === void 0 ? void 0 : _e.reportType,
            reportStartDateType: (_f = this.selectedReportTemplate) === null || _f === void 0 ? void 0 : _f.reportStartDateType,
            reportStartDateOffset: (_g = this.selectedReportTemplate) === null || _g === void 0 ? void 0 : _g.reportStartDateOffset,
            reportDuration: (_h = this.selectedReportTemplate) === null || _h === void 0 ? void 0 : _h.reportDuration
        };
        return this.reportProvider
            .getReportTree(templateGuid)
            .then(function (reportTreeData) {
            var _a, _b, _c, _d, _e, _f, _g, _h;
            _this.report = null;
            _this.userDefinedParameters = _this.restorePredefinedParametersValues(reportTreeData.predefinedParameters);
            _this.reportTreeData = reportTreeData;
            _this.reportTree.drawTree(reportTreeData.nodes);
            _this.updateReportPermissions();
            _this.initPredefinedParameters();
            _this.scale.value = _.isDefined(_this.userPreferences.report.reportViewsScale)
                ? (_a = _this.userPreferences.report.reportViewsScale[templateGuid]) !== null && _a !== void 0 ? _a : 1
                : 1;
            _this.selectedAutoUpdateInterval = _.isDefined(_this.userPreferences.report.reportAutoUpdateTime[templateGuid])
                ? (_b = _this.userPreferences.report.reportAutoUpdateTime[templateGuid]) !== null && _b !== void 0 ? _b : RepeatInterval.Off
                : RepeatInterval.Off;
            if (_.isDefined(_this.$routeParams.start)) {
                _this.interval = {
                    start: Date.fromStringDate(_this.$routeParams.start),
                    stop: _.isDefined(_this.$routeParams.stop)
                        ? Date.fromStringDate(_this.$routeParams.stop)
                        : Date.fromStringDate(_this.$routeParams.start)
                };
            }
            else if (!((_c = _this.interval) === null || _c === void 0 ? void 0 : _c.start) || !((_d = _this.interval) === null || _d === void 0 ? void 0 : _d.stop)
                || (previousReportTemplatePeriodSettings === null || previousReportTemplatePeriodSettings === void 0 ? void 0 : previousReportTemplatePeriodSettings.reportType) !== ((_e = _this.currentReportTemplatePeriodSettings) === null || _e === void 0 ? void 0 : _e.reportType)
                || (previousReportTemplatePeriodSettings === null || previousReportTemplatePeriodSettings === void 0 ? void 0 : previousReportTemplatePeriodSettings.reportStartDateType) !== ((_f = _this.currentReportTemplatePeriodSettings) === null || _f === void 0 ? void 0 : _f.reportStartDateType)
                || (previousReportTemplatePeriodSettings === null || previousReportTemplatePeriodSettings === void 0 ? void 0 : previousReportTemplatePeriodSettings.reportStartDateOffset) !== ((_g = _this.currentReportTemplatePeriodSettings) === null || _g === void 0 ? void 0 : _g.reportStartDateOffset)
                || (previousReportTemplatePeriodSettings === null || previousReportTemplatePeriodSettings === void 0 ? void 0 : previousReportTemplatePeriodSettings.reportDuration) !== ((_h = _this.currentReportTemplatePeriodSettings) === null || _h === void 0 ? void 0 : _h.reportDuration)) {
                _this.interval = _this.getReportPeriod(_this.selectedReportTemplate.reportType, _this.selectedReportTemplate.reportStartDateType, _this.selectedReportTemplate.reportStartDateOffset, _this.selectedReportTemplate.reportDuration);
            }
            if (_.isDefined(_this.$routeParams.start) &&
                _.isDefined(_this.$routeParams.stop) &&
                _this.$routeParams.preview) {
                if (_this.isAllPredefinedValuesDefined()) {
                    _this.createReport(false);
                }
            }
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    ReportViewCtrl.prototype.getReportPeriod = function (reportType, reportStartDateType, reportStartDateOffset, reportDuration) {
        var startDate = dateHelper.getDatePlusTimestamp(this.getReportStartDate(reportStartDateType), reportStartDateOffset);
        switch (reportType) {
            case 0: {
                return new TimeInterval(startDate, startDate);
            }
            case 1: {
                return new TimeInterval(startDate, dateHelper.getDatePlusTimestamp(startDate, reportDuration));
            }
        }
    };
    ReportViewCtrl.prototype.getReportStartDate = function (reportStartDate) {
        var now = Date.getNow();
        switch (reportStartDate) {
            case 0:
                return now;
            case 1:
                return now.getBeginHour();
            case 2:
                return now.getBeginDay();
            case 3:
                return now.getBeginMonth();
            case 4:
                return now.getBeginYear();
            default:
                return now;
        }
    };
    ReportViewCtrl.prototype.updateReportPermissions = function () {
        this.userHasReportViewPermission = this.reportTemplateService.checkViewCurrentReportPermission();
        this.userHasReportCreatePermission = this.reportTemplateService.checkCreateCurrentReportPermission();
        this.userHasReportEditPermission = this.reportTemplateService.checkEditCurrentReportPermission();
        this.userHasReportDeletePermission = this.reportTemplateService.checkDeleteCurrentReportPermission();
        this.userHasReportAdministrationPermission = this.authentication.hasPermission(this.$rootScope.permissions.ReportAdministrate);
        this.userHasReportExportPermission = this.reportTemplateService.checkExportReportPermission();
        this.userHasReportViewManualEditsPermission = this.reportTemplateService.checkViewManualEditsReportPermission();
        this.userHasReportMailSendingPermission = this.reportTemplateService.checkManualSendingCurrentReportByMailPermission();
        this.userHasReportPrintPermission = this.reportTemplateService.checkPrintReportPermission();
        this.userHasReportRecreatePermission = this.reportTemplateService.checkRecreateCurrentReportPermission();
        this.userHasReportLockPermission = this.reportTemplateService.checkLockReportCurrentReportPermisson();
    };
    ReportViewCtrl.prototype.isMoreButtonVisible = function () {
        return this.selectedReportTemplate.isAllowAnonymousView
            || this.isSavedReport() && _.any([
                this.userHasReportViewManualEditsPermission,
                this.userHasReportEditPermission,
                this.userHasReportRecreatePermission,
                this.userHasReportLockPermission,
            ]);
    };
    ReportViewCtrl.prototype.isTemplateExist = function () {
        var _a;
        return ((_a = this.reportTemplates) === null || _a === void 0 ? void 0 : _a.length) > 0;
    };
    ReportViewCtrl.prototype.updateReportErrors = function () {
        this.reportErrors = [];
        if (!this.report) {
            return;
        }
        if (_.any(this.report.Errors)) {
            var groupedErrors = _.groupBy(this.report.Errors, function (e) {
                return e.Ident;
            });
            this.reportErrors = _.map(groupedErrors, function (e, key) {
                var err = {
                    ident: key,
                    status: e[0].Title,
                    errors: e,
                    isOpen: false,
                };
                return err;
            });
        }
    };
    ReportViewCtrl.prototype.updateReportTemplateCalculationStatus = function () {
        var lastNode = this.reportTree.getLastNode();
        if (lastNode && this.reportTreeData) {
            this.selectedReportTemplate.isLastReportSuccessfullyCalculated = lastNode.info.calculationResult === 0;
        }
        else if (this.reportTreeData) {
            this.selectedReportTemplate.isLastReportSuccessfullyCalculated = true;
        }
    };
    ReportViewCtrl.prototype.handleTableValuePaste = function (event) {
        var input = event.target;
        var pastedData = event.clipboardData.getData('Text').replaceAllPolyfill('\r', '');
        var rows = pastedData.split('\n');
        if (rows[rows.length - 1] === '') {
            rows.splice(rows.length - 1);
        }
        var td = input.closest('td');
        if (_.isUndefined(td)) {
            return;
        }
        var tr = td.closest('tr');
        var otherTd = tr.querySelectorAll('td');
        if (!_.any(otherTd)) {
            return;
        }
        var startIndex = 0;
        for (; startIndex < otherTd.length; startIndex++) {
            if (otherTd[startIndex] === td) {
                break;
            }
        }
        for (var i = 0; i < rows.length; i++) {
            if (_.isUndefined(tr)) {
                break;
            }
            var tdArray = tr.querySelectorAll('td');
            var cells = rows[i].split('\t');
            for (var j = 0; j < Math.min(cells.length, tdArray.length - startIndex); j++) {
                var span = tdArray[startIndex + j].querySelector('span[editable]');
                if (_.isUndefined(span)) {
                    break;
                }
                var isEditable = span.hasAttribute('editable');
                if (isEditable) {
                    var value = cells[j];
                    if ($.isNumeric(value.replaceAllPolyfill(',', '.'))) {
                        value = value.replaceAllPolyfill(',', '.');
                    }
                    var change = {
                        newValue: value,
                        oldValue: span.getAttribute('originalvalue'),
                        timestamp: span.getAttribute('ts'),
                        ident: span.getAttribute('ident'),
                    };
                    if (i === 0 && j === 0) {
                        var inputElement = span.querySelector('input');
                        if (_.isDefined(inputElement)) {
                            inputElement.value = value;
                        }
                    }
                    span.setAttribute('value', value);
                    span.setAttribute('roundedvalue', value);
                    span.setAttribute('edited', '');
                    span.innerHTML = value;
                    this.onReportValueEdited(change);
                }
            }
            tr = tr.nextElementSibling;
        }
    };
    ReportViewCtrl.prototype.increaseViewScale = function () {
        this.scale.increase();
        this.updateUserPreferencesScale();
    };
    ReportViewCtrl.prototype.decreaseViewScale = function () {
        this.scale.decrease();
        this.updateUserPreferencesScale();
    };
    ReportViewCtrl.prototype.onRepeatIntervalSelect = function (repeatInterval) {
        this.selectedAutoUpdateInterval = repeatInterval;
        if (repeatInterval === RepeatInterval.Off) {
            this.userPreferences.report.reportAutoUpdateTime[this.selectedReportTemplate.uniqueGuid] = undefined;
            this.actionRepeaterService.stop();
        }
        else {
            this.userPreferences.report.reportAutoUpdateTime[this.selectedReportTemplate.uniqueGuid] = repeatInterval;
            this.actionRepeaterService.start(this.autoUpdateAction, repeatInterval);
        }
        this.userPreferencesService.setPreferences(this.userPreferences);
    };
    ReportViewCtrl.prototype.canSave = function () {
        return !this.isSavedReport()
            || (this.hasChanges()
                && !this.report.Signed
                && this.userHasReportEditPermission);
    };
    ReportViewCtrl.prototype.updateUserPreferencesScale = function () {
        this.userPreferences.report.reportViewsScale[this.selectedReportTemplate.uniqueGuid] = this.scale.value;
        this.userPreferencesService.setPreferences(this.userPreferences);
    };
    ReportViewCtrl.prototype.loadReportActiveUsers = function () {
        var _this = this;
        this.userSessionService.getUsersOnPage(this.$location.url())
            .then(function (data) {
            _this.reportActiveUsers = [];
            _.forEach(_.uniq(data), function (user) {
                var _a;
                _this.reportActiveUsers.push({
                    fullName: user,
                    initials: (_a = _.first(user)) !== null && _a !== void 0 ? _a : ''
                });
            });
        }, function () { });
    };
    ReportViewCtrl.prototype.loadReportByUrl = function () {
        var _this = this;
        this.loadReport().then(function (report) {
            _this.reportTree.selectNode(report.StartTime.toLongString(), report.EndTime.toLongString(), report.PredefinedValues.HashCode);
        });
    };
    ReportViewCtrl.prototype.getActiveUserNames = function () {
        return _.map(this.reportActiveUsers, function (user) { return user.fullName; }).join("\n");
    };
    ReportViewCtrl.prototype.restorePredefinedParametersValues = function (predefinedParameters) {
        var _this = this;
        var parameters = [];
        _.forEach(predefinedParameters, function (parameter) {
            var existingParameterWithValue = _.find(_this.predefinedParametersValues, function (parameterWithValue) {
                return ReportParameter.isEqual(parameter, parameterWithValue.parameter);
            });
            if (existingParameterWithValue) {
                parameters.push(existingParameterWithValue);
            }
        });
        return parameters;
    };
    ReportViewCtrl.prototype.startAutoUpdate = function () {
        if (this.selectedAutoUpdateInterval !== RepeatInterval.Off && !this.hasChanges()) {
            if (this.actionRepeaterService.interval > 0) {
                this.actionRepeaterService.resume();
            }
            else {
                this.actionRepeaterService.start(this.autoUpdateAction, this.selectedAutoUpdateInterval);
            }
        }
    };
    ReportViewCtrl.prototype.getHeaders = function (autoUpdate, cancelRequestKey) {
        if (!autoUpdate && this.selectedAutoUpdateInterval === RepeatInterval.Off) {
            return {};
        }
        var headers = {};
        if (autoUpdate) {
            headers.ignoreBlockUI = true;
        }
        if (this.selectedAutoUpdateInterval !== RepeatInterval.Off) {
            headers.ExcludeFromLogging = true;
        }
        return __assign({ headers: __assign({}, headers) }, (cancelRequestKey ? { timeout: this.cancelRequests[cancelRequestKey].promise } : undefined));
    };
    ReportViewCtrl.prototype.hasChanges = function () {
        var _a;
        return _.isDefined(this.editedCells) && ((_a = this.editedCells) === null || _a === void 0 ? void 0 : _a.length) > 0;
    };
    ReportViewCtrl.prototype.getDatePickerSettings = function (dateFormat) {
        var datePickerSettings = {
            pickTime: true,
            dateFormat: 'DD.MM.YYYY HH:mm:ss',
            viewMode: 'days'
        };
        switch (dateFormat) {
            case 0:
                return datePickerSettings;
            case 1:
                datePickerSettings.pickTime = false;
                datePickerSettings.dateFormat = 'MMMM YYYY';
                datePickerSettings.viewMode = 'months';
                return datePickerSettings;
            case 2:
                datePickerSettings.pickTime = false;
                datePickerSettings.dateFormat = 'YYYY';
                datePickerSettings.viewMode = 'years';
                return datePickerSettings;
            default:
                return datePickerSettings;
        }
    };
    ReportViewCtrl.prototype.onStartDateChanged = function () {
        if (this.selectedReportTemplate.reportType === 0) {
            this.interval.stop = new Date(this.interval.start.getTime());
            return;
        }
        if (this.interval.start >= this.interval.stop) {
            this.interval.stop = dateHelper.getDatePlusTimestamp(this.interval.start, this.selectedReportTemplate.reportDuration);
        }
    };
    ReportViewCtrl.prototype.onEndDateChanged = function () {
        if (this.interval.stop <= this.interval.start) {
            this.interval.start = dateHelper.getDatePlusTimestamp(this.interval.stop, this.selectedReportTemplate.reportDuration, true);
        }
    };
    ReportViewCtrl.$inject = [
        '$scope',
        'dateFilter',
        '$window',
        '$controller',
        '$rootScope',
        '$routeParams',
        '$interval',
        '$timeout',
        'reportProvider',
        'userSessionService',
        '$http',
        '$location',
        '$modal',
        '$q',
        '$compile',
        '$sce',
        'notificationService',
        'clientSettings',
        'authentication',
        'blockUI',
        'reportSigningChecker',
        'reportTemplateService',
        'reportTemplateProvider',
        'actionRepeaterService',
        'language',
        'exportService',
        'mailProvider',
        'userPreferencesService',
        'printService',
        'reportConfigurationProvider',
    ];
    return ReportViewCtrl;
}());
angular.module('kamhpp').controller('ReportViewCtrl', ReportViewCtrl);
