app.directive('inputIpAddress', function () {
    return {
        require: 'ngModel',
        link: function (scope, element, attr, ngModelCtrl) {
            var fromUser = function (address) {
                var ipAddressPartsCount = 4;
                var ipAddressParts = _.filter(address.split('.'), function (num) {
                    return num !== '';
                });
                var isValid = ipAddressParts.length == ipAddressPartsCount &&
                    _.all(_.map(ipAddressParts, function (part) { return Number(part); }), function (part) { return _.isNumber(part) && !_.isNaN(part) && part <= 255 && part >= 0; });
                if (!isValid) {
                    ngModelCtrl.$setViewValue(ngModelCtrl.$modelValue);
                    ngModelCtrl.$render();
                    address = ngModelCtrl.$modelValue;
                }
                return address;
            };
            ngModelCtrl.$parsers.push(fromUser);
        },
    };
});
