app.directive('smsResizable', function () {
    return {
        restrict: 'A',
        link: function (scope, element) {
            var resizable = element[0];
            element[0].classList.add('qwerty');
            var dragHandle = document.createElement('div');
            dragHandle.className = 'drag-handle';
            resizable.appendChild(dragHandle);
            var isResizing = false;
            var initialWidth;
            var containerWidth;
            dragHandle.addEventListener('mousedown', function (event) {
                isResizing = true;
                initialWidth = resizable.offsetWidth;
                containerWidth = resizable.parentElement.offsetWidth;
                var startX = event.clientX;
                document.addEventListener('mousemove', resizeElement);
                document.addEventListener('mouseup', function () {
                    isResizing = false;
                    document.removeEventListener('mousemove', resizeElement);
                });
                function resizeElement(event) {
                    if (isResizing) {
                        var widthChange = event.clientX - startX;
                        var newWidth = initialWidth + widthChange;
                        var newWidthPercentage = (newWidth / containerWidth) * 100;
                        resizable.style.width = newWidthPercentage + '%';
                    }
                }
            });
        },
    };
})
    .controller('MainController', function () {
});
