app.directive('stickyTableHeaders', function () {
    return {
        restrict: 'A',
        link: function (scope, element, attrs) {
            var width = attrs.containerWidth || '100%';
            var height = attrs.containerHeight || '500px';
            var container = angular.element('<div class="sticky-table-container"></div>');
            container.css({
                width: "min(100%, ".concat(width, ")"),
                height: height,
                overflow: 'auto',
                position: 'relative',
                border: '1px solid #ccc',
                resize: 'both',
            });
            element.wrap(container);
            element.addClass('sticky-table');
        },
    };
});
