var Dictionary = (function () {
    function Dictionary(keys, values) {
        this._keys = [];
        this._values = [];
        this._keys = keys !== null && keys !== void 0 ? keys : [];
        this._values = values !== null && values !== void 0 ? values : [];
    }
    Dictionary.prototype.add = function (key, value) {
        this._keys.push(key);
        this._values.push(value);
    };
    Dictionary.prototype.remove = function (key) {
        var index = this._keys.indexOf(key, 0);
        this._keys.splice(index, 1);
        this._values.splice(index, 1);
    };
    Dictionary.prototype.keys = function () {
        return this._keys;
    };
    Dictionary.prototype.values = function () {
        return this._values;
    };
    Dictionary.prototype.containsKey = function (key) {
        if (this._keys.indexOf(key, 0) === -1) {
            return false;
        }
        return true;
    };
    Dictionary.prototype.toLookup = function () {
        return this;
    };
    Dictionary.prototype.get = function (key) {
        var itemIndex = this._keys.indexOf(key, 0);
        if (itemIndex === -1) {
            return undefined;
        }
        return this._values[itemIndex];
    };
    Dictionary.prototype.clone = function () {
        return new Dictionary(_.deepclone(this._keys), _.deepclone(this._values));
    };
    Dictionary.prototype.equals = function (other) {
        return angular.equals(this, other);
    };
    return Dictionary;
}());
