var app = angular.module('kamhpp', [
    'angularFileUpload',
    'ngRoute',
    'ngAnimate',
    'ngSanitize',
    'ngDrag',
    'blockUI',
    'toaster',
    'ui.bootstrap',
    'ui.toggle',
    'ui.select',
    'treeGrid',
    'smsValidatorService',
    'dataServiceProvider',
    'pascalprecht.translate',
]);
app.config([
    'blockUIConfigProvider',
    function (blockUIConfig) {
        blockUIConfig.message('');
        blockUIConfig.delay(200);
        blockUIConfig.requestFilter(function (config) {
            if (config.headers['ignoreBlockUI']) {
                return false;
            }
            if (config.url.contains('/GetServerId') ||
                config.url.contains('/GetAllReportTemplatesShortInfo') ||
                config.url.contains('/OperationTimeParameter/Recalculate') ||
                config.url.contains('/Report/RecreateReport') ||
                config.url.contains('/ReportCalculation/CalculateParametersValues') ||
                config.url.contains('/SwitchoverForm/VerifyAutomaticCondition') ||
                config.url.contains('/SwitchoverForm/VerifyCondition') ||
                config.url.contains('/SwitchoverForm/ExecuteOperation') ||
                config.url.contains('/SwitchoverForm/CancelManualOperationExecution') ||
                config.url.contains('/SwitchoverForm/CancelManualConditionVerification') ||
                config.url.contains('/AppDiagnostic/GetAppHealth') ||
                config.url.contains('/UserSession')) {
                return false;
            }
            return true;
        });
    },
]);
app.config(function ($locationProvider, $translateProvider) {
    $translateProvider.translations('en', en);
    $translateProvider.translations('ru', ru);
    $translateProvider.useSanitizeValueStrategy('escape');
    $locationProvider.hashPrefix('');
});
app.value('coreConfiguration', new CoreConfiguration());
var AppConfigurationCtrl = (function () {
    function AppConfigurationCtrl(authentication, coreConfiguration) {
        this.authentication = authentication;
        this.coreConfiguration = coreConfiguration;
    }
    AppConfigurationCtrl.$inject = ['authentication', 'coreConfiguration'];
    return AppConfigurationCtrl;
}());
app.controller('AppConfigurationCtrl', AppConfigurationCtrl);
app.run(function (coreConfiguration, coreConfigurationProvider, notificationService, language, userSessionService, smsNg2HandlerService, $templateCache, $http) {
    var serviceUnavailableViewTemplatePath = 'ng1/dist/src/ErrorPages/ServiceUnavailable/ServiceUnavailableView.html';
    $http.get(serviceUnavailableViewTemplatePath).then(function (response) {
        $templateCache.put(serviceUnavailableViewTemplatePath, response.data);
    });
    coreConfigurationProvider
        .getApplicationTitle()
        .then(function (applicationTitle) {
        coreConfiguration.applicationTitle = applicationTitle;
    })
        .catch(function (error) {
        notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), error);
    });
    userSessionService.run();
    smsNg2HandlerService.run();
});
