﻿BEGIN TRANSACTION;

CREATE TABLE "OTParameters" (
    "Id" TEXT NOT NULL CONSTRAINT "PK_OTParameters" PRIMARY KEY,
    "Name" TEXT NOT NULL,
    "Algorithm" TEXT NOT NULL
);

CREATE TABLE "OTSettings" (
    "Name" TEXT NOT NULL CONSTRAINT "PK_OTSettings" PRIMARY KEY,
    "Value" TEXT NULL
);

CREATE TABLE "OTAlgorithmConstants" (
    "Id" TEXT NOT NULL CONSTRAINT "PK_OTAlgorithmConstants" PRIMARY KEY,
    "Name" TEXT NOT NULL,
    "ParameterId" TEXT NOT NULL,
    CONSTRAINT "FK_OTAlgorithmConstants_OTParameters_ParameterId" FOREIGN KEY ("ParameterId") REFERENCES "OTParameters" ("Id") ON DELETE CASCADE
);

CREATE TABLE "OTAlgorithmParameters" (
    "Id" TEXT NOT NULL CONSTRAINT "PK_OTAlgorithmParameters" PRIMARY KEY,
    "Name" TEXT NOT NULL,
    "ParameterId" TEXT NOT NULL,
    CONSTRAINT "FK_OTAlgorithmParameters_OTParameters_ParameterId" FOREIGN KEY ("ParameterId") REFERENCES "OTParameters" ("Id") ON DELETE CASCADE
);

CREATE TABLE "OTDevices" (
    "Id" TEXT NOT NULL CONSTRAINT "PK_OTDevices" PRIMARY KEY,
    "Name" TEXT NOT NULL,
    "ParameterId" TEXT NOT NULL,
    CONSTRAINT "FK_OTDevices_OTParameters_ParameterId" FOREIGN KEY ("ParameterId") REFERENCES "OTParameters" ("Id") ON DELETE CASCADE
);

CREATE TABLE "OTParameterStates" (
    "Id" TEXT NOT NULL CONSTRAINT "PK_OTParameterStates" PRIMARY KEY,
    "Name" TEXT NOT NULL,
    "ParameterId" TEXT NOT NULL,
    "Value" INTEGER NOT NULL,
    "LineType" INTEGER NOT NULL,
    "BackgroundColor" INTEGER NOT NULL,
    CONSTRAINT "FK_OTParameterStates_OTParameters_ParameterId" FOREIGN KEY ("ParameterId") REFERENCES "OTParameters" ("Id") ON DELETE CASCADE
);

CREATE TABLE "OTAlgorithmConstantCrosses" (
    "Id" TEXT NOT NULL CONSTRAINT "PK_OTAlgorithmConstantCrosses" PRIMARY KEY,
    "AlgorithmConstantId" TEXT NOT NULL,
    "DeviceId" TEXT NOT NULL,
    "Value" REAL NOT NULL,
    CONSTRAINT "FK_OTAlgorithmConstantCrosses_OTAlgorithmConstants_AlgorithmConstantId" FOREIGN KEY ("AlgorithmConstantId") REFERENCES "OTAlgorithmConstants" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_OTAlgorithmConstantCrosses_OTDevices_DeviceId" FOREIGN KEY ("DeviceId") REFERENCES "OTDevices" ("Id") ON DELETE CASCADE
);

CREATE TABLE "OTAlgorithmParameterCrosses" (
    "Id" TEXT NOT NULL CONSTRAINT "PK_OTAlgorithmParameterCrosses" PRIMARY KEY,
    "AlgorithmParameterId" TEXT NOT NULL,
    "DeviceId" TEXT NOT NULL,
    "Address" TEXT NULL,
    CONSTRAINT "FK_OTAlgorithmParameterCrosses_OTAlgorithmParameters_AlgorithmParameterId" FOREIGN KEY ("AlgorithmParameterId") REFERENCES "OTAlgorithmParameters" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_OTAlgorithmParameterCrosses_OTDevices_DeviceId" FOREIGN KEY ("DeviceId") REFERENCES "OTDevices" ("Id") ON DELETE CASCADE
);

CREATE TABLE "OTChanges" (
    "Id" INTEGER NOT NULL CONSTRAINT "PK_OTChanges" PRIMARY KEY AUTOINCREMENT,
    "UserId" TEXT NOT NULL,
    "ChangeTime" TEXT NOT NULL,
    "OldTimestamp" TEXT NULL,
    "NewTimestamp" TEXT NULL,
    "OldParameterStateId" TEXT NULL,
    "NewParameterStateId" TEXT NULL,
    "DeviceId" TEXT NOT NULL,
    CONSTRAINT "FK_OTChanges_OTDevices_DeviceId" FOREIGN KEY ("DeviceId") REFERENCES "OTDevices" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_OTChanges_OTParameterStates_NewParameterStateId" FOREIGN KEY ("NewParameterStateId") REFERENCES "OTParameterStates" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_OTChanges_OTParameterStates_OldParameterStateId" FOREIGN KEY ("OldParameterStateId") REFERENCES "OTParameterStates" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_OTChanges_Users_UserId" FOREIGN KEY ("UserId") REFERENCES "Users" ("Id") ON DELETE CASCADE
);

CREATE TABLE "OTRecords" (
    "Id" TEXT NOT NULL CONSTRAINT "PK_OTRecords" PRIMARY KEY,
    "StateId" TEXT NOT NULL,
    "DeviceId" TEXT NOT NULL,
    "CreatedTimeStamp" TEXT NOT NULL,
    "CreatedUserId" TEXT NOT NULL,
    "TimeStamp" TEXT NOT NULL,
    CONSTRAINT "FK_OTRecords_OTDevices_DeviceId" FOREIGN KEY ("DeviceId") REFERENCES "OTDevices" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_OTRecords_OTParameterStates_StateId" FOREIGN KEY ("StateId") REFERENCES "OTParameterStates" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_OTRecords_Users_CreatedUserId" FOREIGN KEY ("CreatedUserId") REFERENCES "Users" ("Id") ON DELETE CASCADE
);

CREATE INDEX "IX_OTAlgorithmConstantCrosses_AlgorithmConstantId" ON "OTAlgorithmConstantCrosses" ("AlgorithmConstantId");

CREATE INDEX "IX_OTAlgorithmConstantCrosses_DeviceId" ON "OTAlgorithmConstantCrosses" ("DeviceId");

CREATE INDEX "IX_OTAlgorithmConstants_ParameterId" ON "OTAlgorithmConstants" ("ParameterId");

CREATE INDEX "IX_OTAlgorithmParameterCrosses_AlgorithmParameterId" ON "OTAlgorithmParameterCrosses" ("AlgorithmParameterId");

CREATE INDEX "IX_OTAlgorithmParameterCrosses_DeviceId" ON "OTAlgorithmParameterCrosses" ("DeviceId");

CREATE INDEX "IX_OTAlgorithmParameters_ParameterId" ON "OTAlgorithmParameters" ("ParameterId");

CREATE INDEX "IX_OTChanges_DeviceId" ON "OTChanges" ("DeviceId");

CREATE INDEX "IX_OTChanges_NewParameterStateId" ON "OTChanges" ("NewParameterStateId");

CREATE INDEX "IX_OTChanges_OldParameterStateId" ON "OTChanges" ("OldParameterStateId");

CREATE INDEX "IX_OTChanges_UserId" ON "OTChanges" ("UserId");

CREATE INDEX "IX_OTDevices_ParameterId" ON "OTDevices" ("ParameterId");

CREATE UNIQUE INDEX "IX_OTParameters_Name" ON "OTParameters" ("Name");

CREATE INDEX "IX_OTParameterStates_ParameterId" ON "OTParameterStates" ("ParameterId");

CREATE INDEX "IX_OTRecords_CreatedUserId" ON "OTRecords" ("CreatedUserId");

CREATE UNIQUE INDEX "IX_OTRecords_DeviceId_TimeStamp" ON "OTRecords" ("DeviceId", "TimeStamp");

CREATE INDEX "IX_OTRecords_StateId" ON "OTRecords" ("StateId");

COMMIT;

