var OpenSwitchoverFormLogModalCtrl = (function () {
    function OpenSwitchoverFormLogModalCtrl(scope, modal, systemLogProvider, notificationService, language, normalizeLineBreakFilter, switchoverForm) {
        var _this = this;
        this.scope = scope;
        this.modal = modal;
        this.systemLogProvider = systemLogProvider;
        this.notificationService = notificationService;
        this.language = language;
        this.normalizeLineBreakFilter = normalizeLineBreakFilter;
        this.switchoverForm = switchoverForm;
        this.sort = {
            columnName: 'actionTime',
            descending: true,
        };
        this.dateFormat = Date.masks.fullDateTime;
        this.users = [];
        this.logs = [];
        this.scope.ctrl = this;
        this.startDate = new Date(this.switchoverForm.creationDate);
        this.endDate = new Date().addDays(1);
        this.allUsersItem = this.language.getElementValue('allHdr');
        this.selectedUser = this.allUsersItem;
        this.systemLogProvider
            .getSystemLogsWithSubstring(String.Format(this.language.getElementValue('switchoverFormsSystemLogSearchPttrn'), this.switchoverForm.name, this.switchoverForm.serialNumber.toString()))
            .then(function (logs) {
            _this.users = _this.getUsers(logs);
            _this.logs = _this.formatLogDescriptions(_.sortBy(logs, function (log) { return log.actionTime; }).reverse());
        })
            .catch(function (error) {
            return _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    }
    OpenSwitchoverFormLogModalCtrl.prototype.close = function () {
        this.modal.close();
    };
    OpenSwitchoverFormLogModalCtrl.prototype.filterLogs = function () {
        var _this = this;
        return function (log) {
            return (log.actionTime >= _this.startDate &&
                log.actionTime <= _this.endDate &&
                (_this.selectedUser === _this.allUsersItem || log.user === _this.selectedUser) &&
                (!_this.descriptionSearchText ||
                    log.description.toLowerCase().contains(_this.descriptionSearchText.toLowerCase())));
        };
    };
    OpenSwitchoverFormLogModalCtrl.prototype.changeSorting = function (columnName) {
        if (this.sort.columnName === columnName) {
            this.sort.descending = !this.sort.descending;
        }
        else {
            this.sort.columnName = columnName;
            this.sort.descending = false;
        }
    };
    OpenSwitchoverFormLogModalCtrl.prototype.formatLogDescriptions = function (logs) {
        var _this = this;
        _.forEach(logs, function (log) {
            log.description = _this.normalizeLineBreakFilter(log.description);
        });
        _.forEach(logs, function (log) {
            _.forEach(_this.switchoverForm.conditions, function (condition) {
                var subString = String.Format(_this.language.getElementValue('switchoverFormsConditionLogReplacePttrn'), condition.orderNumber.toString());
                var subStringWithHint = _this.getLogDescription(subString, condition.description);
                log.description = log.description.replaceAllPolyfill(subString, subStringWithHint);
            });
            _.forEach(_this.switchoverForm.operations, function (operation) {
                var subString = String.Format(_this.language.getElementValue('switchoverFormsOperationLogReplacePttrn'), operation.orderNumber.toString());
                var subStringWithHint = _this.getLogDescription(subString, operation.description);
                log.description = log.description.replaceAllPolyfill(subString, subStringWithHint);
            });
        });
        return logs;
    };
    OpenSwitchoverFormLogModalCtrl.prototype.getLogDescription = function (description, tooltip) {
        return ('<div class="log-tooltip">' + description + '<span class="log-tooltip-content">' + tooltip + '</span></div>');
    };
    OpenSwitchoverFormLogModalCtrl.prototype.getUsers = function (logs) {
        var users = [];
        users = _.uniq(_.map(logs, function (log) { return log.user; }));
        users.unshift(this.allUsersItem);
        return users;
    };
    OpenSwitchoverFormLogModalCtrl.$inject = [
        '$scope',
        '$modalInstance',
        'systemLogProvider',
        'notificationService',
        'language',
        'normalizeLineBreakFilter',
        'switchoverForm',
    ];
    return OpenSwitchoverFormLogModalCtrl;
}());
angular.module('kamhpp').controller('openSwitchoverFormLogModalCtrl', OpenSwitchoverFormLogModalCtrl);
