var RepeatInterval;
(function (RepeatInterval) {
    RepeatInterval[RepeatInterval["Off"] = 0] = "Off";
    RepeatInterval[RepeatInterval["Time5s"] = 5] = "Time5s";
    RepeatInterval[RepeatInterval["Time15s"] = 15] = "Time15s";
    RepeatInterval[RepeatInterval["Time30s"] = 30] = "Time30s";
    RepeatInterval[RepeatInterval["Time60s"] = 60] = "Time60s";
})(RepeatInterval || (RepeatInterval = {}));
var ActionRepeaterService = (function () {
    function ActionRepeaterService($timeout, notificationService, language) {
        var _this = this;
        this.$timeout = $timeout;
        this.notificationService = notificationService;
        this.language = language;
        this.isRunning = false;
        this.run = function () {
            if (_this.interval <= 0) {
                return;
            }
            _this.timer = _this.$timeout(function () {
                if (!_this.isRunning) {
                    return;
                }
                _this.action().finally(function () {
                    _this.$timeout.cancel(_this.timer);
                    _this.run();
                });
            }, _this.interval);
        };
    }
    ActionRepeaterService.prototype.start = function (action, intervalInSeconds) {
        this.action = action;
        this.interval = intervalInSeconds * 1000;
        this.notificationService.infoMessage(String.Format(this.language.getElementValue('autoUpdateOnMsg'), intervalInSeconds.toString()));
        if (!this.isRunning) {
            this.run();
        }
        this.isRunning = true;
    };
    ActionRepeaterService.prototype.stop = function (skipNotification) {
        if (skipNotification === void 0) { skipNotification = false; }
        if (this.interval > 0 && !skipNotification) {
            this.notificationService.infoMessage(this.language.getElementValue('autoUpdateOffMsg'));
        }
        if (_.isDefined(this.timer)) {
            this.$timeout.cancel(this.timer);
        }
        this.action = undefined;
        this.interval = undefined;
        this.isRunning = false;
    };
    ActionRepeaterService.prototype.pause = function () {
        if (this.isRunning && this.interval > 0) {
            this.notificationService.infoMessage(this.language.getElementValue('autoUpdateStopMsg'));
        }
        this.isRunning = false;
    };
    ActionRepeaterService.prototype.resume = function () {
        if (!this.isRunning && this.interval > 0) {
            this.notificationService.infoMessage(this.language.getElementValue('autoUpdateResumedMsg'));
            this.run();
        }
        this.isRunning = true;
    };
    ActionRepeaterService.$inject = [
        '$timeout',
        'notificationService',
        'language'
    ];
    return ActionRepeaterService;
}());
angular
    .module('kamhpp')
    .service('actionRepeaterService', ActionRepeaterService);
