var InfluxSettings = (function () {
    function InfluxSettings() {
        this.func = 'tables';
        this.includeHeader = true;
    }
    InfluxSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new InfluxSettings();
        clone.func = obj.func;
        clone.connectionGuid = obj.connectionGuid;
        clone.includeHeader = obj.includeHeader;
        clone.sql = obj.sql;
        return clone;
    };
    InfluxSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.func === other.func &&
            obj.connectionGuid === other.connectionGuid &&
            obj.includeHeader === other.includeHeader &&
            obj.sql === other.sql);
    };
    InfluxSettings.prototype.canEdited = function () {
        return this.func === 'cellString' || this.func === 'cellDouble';
    };
    InfluxSettings.prototype.canPlanned = function () {
        return true;
    };
    InfluxSettings.prototype.canBacklight = function () {
        return !_.contains(['table', 'string[]', 'double[][][]'], this.func);
    };
    InfluxSettings.prototype.canPredefined = function () {
        return false;
    };
    return InfluxSettings;
}());
