var PostgreSqlSettings = (function () {
    function PostgreSqlSettings() {
        this.func = 'table';
        this.includeHeader = true;
        this.sql = '';
    }
    PostgreSqlSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new PostgreSqlSettings();
        clone.connectionGuid = obj.connectionGuid;
        clone.func = obj.func;
        clone.includeHeader = obj.includeHeader;
        clone.sql = obj.sql;
        return clone;
    };
    PostgreSqlSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.connectionGuid === other.connectionGuid &&
            obj.func === other.func &&
            obj.includeHeader === other.includeHeader &&
            obj.sql === other.sql);
    };
    PostgreSqlSettings.prototype.canEdited = function () {
        return this.func === 'cellString' || this.func === 'cellDouble';
    };
    PostgreSqlSettings.prototype.canPlanned = function () {
        return true;
    };
    PostgreSqlSettings.prototype.canBacklight = function () {
        return !_.contains(['table', 'doubleArray', 'objectArray', 'stringOneDimArray'], this.func);
    };
    PostgreSqlSettings.prototype.canPredefined = function () {
        return false;
    };
    return PostgreSqlSettings;
}());
