var TemplateParameterService = (function () {
    function TemplateParameterService($q, $modal, language, notificationService, userPreferencesService) {
        this.$q = $q;
        this.$modal = $modal;
        this.language = language;
        this.notificationService = notificationService;
        this.userPreferencesService = userPreferencesService;
        this.userPreferences = this.userPreferencesService.getPreferences();
    }
    TemplateParameterService.prototype.createParameter = function (template, parameterSource) {
        var _this = this;
        var deferred = this.$q.defer();
        var parameter = new ReportParameter();
        parameter.Ident = this.getParameterUniqueName(_.map(template.Parameters, function (parameter) { return parameter.Ident; }), this.language.getElementValue('reportParameterHdr'));
        parameter.Timestamp = template.HasStep
            ? 3
            : 0;
        parameter.setSource(parameterSource !== null && parameterSource !== void 0 ? parameterSource : this.userPreferences.report.reportParameterSource, template.UniqueGuid, template.ReportType, template.HasStep, this.language);
        if (parameter.Source === 'calc') {
            parameter.ParameterType = this.userPreferences.report.reportParameterCalcType;
        }
        this.getEditParameterModalInstance(template, parameter).result.then(function (parameter) {
            template.Parameters.push(parameter);
            _this.userPreferences.report.reportParameterSource = parameter.Source;
            _this.userPreferences.report.reportParameterCalcType = parameter.ParameterType;
            _this.userPreferencesService.setPreferences(_this.userPreferences);
            deferred.resolve(parameter);
        }, function () {
            deferred.reject(parameter);
        });
        return deferred.promise;
    };
    TemplateParameterService.prototype.copyParameter = function (template, parameter) {
        var clone = ReportParameter.clone(parameter);
        clone.Ident = this.getParameterUniqueName(_.map(template.Parameters, function (parameter) {
            return parameter.Ident;
        }), String.Format(this.language.getElementValue('copyHdr'), clone.Ident));
        template.Parameters.push(clone);
        return clone;
    };
    TemplateParameterService.prototype.editParameter = function (template, parameter) {
        var _this = this;
        var deferred = this.$q.defer();
        var clonedParameter = ReportParameter.clone(parameter);
        this.getEditParameterModalInstance(template, clonedParameter).result.then(function (editedParameter) {
            _this.userPreferences.report.reportParameterSource = parameter.Source;
            _this.userPreferences.report.reportParameterCalcType = parameter.ParameterType;
            var index = template.Parameters.indexOf(parameter);
            if (index > -1) {
                template.Parameters[index] = editedParameter;
            }
            _this.userPreferencesService.setPreferences(_this.userPreferences);
            deferred.resolve(editedParameter);
        }, function () {
            deferred.reject(parameter);
        });
        return deferred.promise;
    };
    TemplateParameterService.prototype.deleteParameter = function (template, parameter) {
        var _this = this;
        var deferred = this.$q.defer();
        this.$modal
            .open({
            templateUrl: 'ng1/dist/src/Common/Components/YesNoModal.html',
            controller: 'yesNoModalCtrl',
            backdrop: 'static',
            resolve: {
                header: function () { return _this.language.getElementValue('reportParameterConfirmDeleteHdr'); },
                body: function () {
                    return String.Format(_this.language.getElementValue('reportParameterWillBeDeletedMsg'), parameter.Ident);
                },
            },
        })
            .result.then(function () {
            if (_.any(template.Rules, function (rule) { var _a; return ((_a = rule.parameterConditionTrigger) === null || _a === void 0 ? void 0 : _a.parameterIdent) === parameter.Ident; })) {
                _this.notificationService.warnMessage(_this.language.getElementValue('reportParameterUsedInRulesMsg'));
                deferred.reject();
                return;
            }
            template.Parameters = _.filter(template.Parameters, function (p) { return p.Ident !== parameter.Ident; });
            deferred.resolve();
        }, function () {
            deferred.reject();
        });
        return deferred.promise;
    };
    TemplateParameterService.prototype.getParameterUniqueName = function (names, name) {
        var i = 1;
        while (names.indexOf(name + ' ' + i) !== -1) {
            i++;
        }
        return name + ' ' + i;
    };
    TemplateParameterService.prototype.getEditParameterModalInstance = function (template, parameter) {
        return this.$modal.open({
            templateUrl: 'ng1/dist/src/UserDocuments/Administration/ParameterEditModal/ParameterEditModal.html',
            controller: 'ReportParameterEditModalCtrl',
            windowClass: 'app-modal-window report-parameter-edit-modal-window level-one',
            backdrop: 'static',
            resolve: {
                parameter: function () {
                    return parameter;
                },
                reportTemplate: function () {
                    return template;
                },
            },
        });
    };
    TemplateParameterService.$inject = ['$q', '$modal', 'language', 'notificationService', 'userPreferencesService'];
    return TemplateParameterService;
}());
angular.module('kamhpp').service('templateParameterService', TemplateParameterService);
