var SendingReportEditModalController = (function () {
    function SendingReportEditModalController($scope, $modalInstance, reportTemplateGuid, reportTemplatesShortInfo, userPreferencesService) {
        var _this = this;
        this.$scope = $scope;
        this.$modalInstance = $modalInstance;
        this.reportTemplateGuid = reportTemplateGuid;
        this.reportTemplatesShortInfo = reportTemplatesShortInfo;
        this.userPreferencesService = userPreferencesService;
        $scope.reportTemplates = getVariantsContainer(this.$scope, _.map(this.reportTemplatesShortInfo, function (reportTemplate) {
            return new UiSelectItem(reportTemplate.uniqueGuid, reportTemplate.name);
        }), function (item) {
            return item.ident === _this.reportTemplateGuid;
        }, function (after, before) {
            if (after === before || _.isUndefined(after)) {
                return;
            }
            _this.reportTemplateGuid = after.ident;
        });
        $scope.ok = function () {
            _this.$modalInstance.close(_this.reportTemplateGuid);
        };
        $scope.cancel = function () {
            _this.$modalInstance.dismiss('cancel');
        };
    }
    SendingReportEditModalController.$inject = [
        '$scope',
        '$modalInstance',
        'reportTemplateGuid',
        'reportTemplatesShortInfo',
        'userPreferencesService',
    ];
    return SendingReportEditModalController;
}());
angular.module('kamhpp').controller('SendingReportEditModalCtrl', SendingReportEditModalController);
