var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var ReportRuleCtrl = (function () {
    function ReportRuleCtrl($timeout, scope, rule, language, reportTemplateProvider, notification, modal, owner, mailValidationService, mailProvider, userPreferencesService, printProvider) {
        var _this = this;
        this.$timeout = $timeout;
        this.scope = scope;
        this.rule = rule;
        this.language = language;
        this.reportTemplateProvider = reportTemplateProvider;
        this.notification = notification;
        this.modal = modal;
        this.owner = owner;
        this.mailValidationService = mailValidationService;
        this.mailProvider = mailProvider;
        this.userPreferencesService = userPreferencesService;
        this.printProvider = printProvider;
        this.dateFormat = Date.masks.fullDateTime;
        this.actionTypes = [];
        this.triggerTypes = [
            new UiSelectItem(0, this.language.getElementValue('scheduleRuleSourceTypePeriodicTaskCheckTimeConditionHdr')),
            new UiSelectItem(1, this.language.getElementValue('scheduleRuleSourceTypePeriodicTaskCheckParameterConditionHdr')),
            new UiSelectItem(3, this.language.getElementValue('scheduleRuleSourceTypeSelfReportEventHdr')),
            new UiSelectItem(2, this.language.getElementValue('scheduleRuleSourceTypeAnotherReportEventHdr')),
        ];
        this.watchFunctions = [];
        var self = this;
        self.rule = rule;
        this.mailProvider.isMailEnabled().then(function (isMailEnabled) {
            self.actionTypes = __spreadArray(__spreadArray([
                new UiSelectItem(0, _this.language.getElementValue('reportScheduleActionRecalcHdr'))
            ], (isMailEnabled
                ? [
                    new UiSelectItem(2, _this.language.getElementValue('reportScheduleActionExportToMailSettingsHdr')),
                ]
                : []), true), [
                new UiSelectItem(3, _this.language.getElementValue('reportScheduleActionSaveToFileHdr')),
                new UiSelectItem(4, _this.language.getElementValue('reportScheduleActionLockHdr')),
                new UiSelectItem(5, _this.language.getElementValue('reportScheduleRuleActionCreateHdr')),
                new UiSelectItem(6, _this.language.getElementValue('reportScheduleRuleActionPrintHdr')),
                new UiSelectItem(7, _this.language.getElementValue('reportScheduleRuleActionDeleteHdr'))
            ], false);
            self.sourceTriggerTypesVariationContainer = _this.getSourceTriggerTypesVariationContainer();
            self.completionTypesVariationContainer = _this.getCompletionTypesVariationContainer();
            self.triggerTypesVariationContainer = _this.getTriggerTypesVariationContainer(_this.rule.trigger.sourceType);
            self.actionTypesVariationContainer = _this.getActionTypesVariationContainer(_this.rule.trigger.type);
        });
        self.watchFunctions.push(scope.$on('$destroy', function () {
            self.destroy();
        }));
    }
    ReportRuleCtrl.prototype.onReportModificationTypeChanged = function () {
        var _this = this;
        this.$timeout(function () {
            var actionTypesVariants = _.filter(_this.actionTypesVariationContainer, _this.filterActionTypes());
            _this.actionTypesVariationContainer.selected = actionTypesVariants[0];
            _this.setAction(_this.actionTypesVariationContainer.selected.ident);
        });
    };
    ReportRuleCtrl.prototype.filterActionTypes = function () {
        var _a, _b, _c, _d;
        var rule = this.rule;
        var isSelfReportTrigger = ((_a = rule.selfReportEventTrigger) === null || _a === void 0 ? void 0 : _a.type) === 3;
        var selfReportModificationType = (_b = rule.selfReportEventTrigger) === null || _b === void 0 ? void 0 : _b.reportModificationType;
        var isTimeTrigger = ((_c = rule.timeTrigger) === null || _c === void 0 ? void 0 : _c.type) === 0;
        var isParameterTrigger = ((_d = rule.parameterConditionTrigger) === null || _d === void 0 ? void 0 : _d.type) === 1;
        return function (item) {
            if (isTimeTrigger || isParameterTrigger) {
                return true;
            }
            var isCreateOrDeleteAction = item.ident === 5
                || item.ident === 7;
            if (isSelfReportTrigger && (selfReportModificationType === 0
                || selfReportModificationType === 1
                || selfReportModificationType === 9)) {
                return !isCreateOrDeleteAction
                    && item.ident !== 0
                    && !(selfReportModificationType === 0 && item.ident === 4)
                    && !(selfReportModificationType === 0 && item.ident === 2);
            }
            return !isCreateOrDeleteAction;
        };
    };
    ReportRuleCtrl.prototype.getErrorMessages = function () {
        var errorMessages = [];
        switch (this.rule.action.type) {
            case 2: {
                errorMessages = errorMessages.concat(this.rule.sendingEmailAction.getErrorMessages());
                break;
            }
        }
        switch (this.rule.trigger.type) {
            case 1: {
                errorMessages = errorMessages.concat(this.rule.parameterConditionTrigger.getErrorMessages());
                break;
            }
            case 2: {
                errorMessages = errorMessages.concat(this.rule.anotherReportEventTrigger.getErrorMessages());
                break;
            }
        }
        return errorMessages;
    };
    ReportRuleCtrl.prototype.updateNextTriggerTime = function () {
        var _this = this;
        this.$timeout(function () {
            var now = new Date();
            var nextTime = dateHelper.getDatePlusTimestamp(_this.rule.timeTrigger.startTime, _this.rule.timeTrigger.period);
            while (nextTime <= now) {
                nextTime = dateHelper.getDatePlusTimestamp(nextTime, _this.rule.timeTrigger.period);
            }
            _this.rule.timeTrigger.nextTime = nextTime;
        });
    };
    ReportRuleCtrl.prototype.destroy = function () {
        this.triggerTypesVariationContainer.destroy();
        this.sourceTriggerTypesVariationContainer.destroy();
        this.completionTypesVariationContainer.destroy();
        this.actionTypesVariationContainer.destroy();
    };
    ReportRuleCtrl.prototype.getTriggerTypes = function (triggerSourceType) {
        switch (triggerSourceType) {
            case 0: {
                return this.triggerTypes.filter(function (t) { return t.ident === 0 || t.ident === 1; });
            }
            case 1: {
                return this.triggerTypes.filter(function (t) {
                    return t.ident === 3 || t.ident === 2;
                });
            }
        }
    };
    ReportRuleCtrl.prototype.getActionTypes = function (triggerType) {
        return triggerType !== 2
            ? this.actionTypes
            : _.filter(this.actionTypes, function (type) {
                return type.ident === 0;
            });
    };
    ReportRuleCtrl.prototype.getSourceTriggerTypesVariationContainer = function () {
        var _this = this;
        return getVariantsContainer(this.scope, [
            new UiSelectItem(0, this.language.getElementValue('scheduleRuleSourceTypePeriodicTaskHdr')),
            new UiSelectItem(1, this.language.getElementValue('scheduleRuleSourceTypeReportEventHdr')),
        ], function (item) {
            return item.ident === _this.rule.trigger.sourceType;
        }, function (after, before) {
            if (before === after || _.isUndefined(after)) {
                return;
            }
            _this.rule.trigger.sourceType = after.ident;
            _this.triggerTypesVariationContainer.destroy();
            _this.triggerTypesVariationContainer = _this.getTriggerTypesVariationContainer(after.ident);
            _this.triggerTypesVariationContainer.selected = _this.triggerTypesVariationContainer[0];
            _this.setTrigger(_this.triggerTypesVariationContainer[0].ident);
        });
    };
    ReportRuleCtrl.prototype.getCompletionTypesVariationContainer = function () {
        var _this = this;
        return getVariantsContainer(this.scope, [
            new UiSelectItem(0, this.language.getElementValue('scheduleRuleCompletionWhenTriggeredHdr')),
            new UiSelectItem(1, this.language.getElementValue('scheduleRuleCompletionWhenMultipleTriggeredHdr')),
            new UiSelectItem(2, this.language.getElementValue('scheduleRuleCompletionInfiniteHdr')),
        ], function (item) {
            return item.ident === _this.rule.trigger.completionType;
        }, function (after, before) {
            if (after === before || _.isUndefined(after)) {
                return;
            }
            _this.rule.trigger.completionType = after.ident;
            switch (after.ident) {
                case 1:
                    _this.rule.trigger.duration = '1d';
                    break;
                case 0:
                case 2:
                    _this.rule.trigger.duration = null;
                    break;
            }
        });
    };
    ReportRuleCtrl.prototype.getTriggerTypesVariationContainer = function (triggerSourceType) {
        var _this = this;
        return getVariantsContainer(this.scope, this.getTriggerTypes(triggerSourceType), function (item) {
            return item.ident === _this.rule.trigger.type;
        }, function (after, before) {
            if (after === before || _.isUndefined(after)) {
                return;
            }
            _this.setTrigger(after.ident);
        });
    };
    ReportRuleCtrl.prototype.getActionTypesVariationContainer = function (triggerType) {
        var _this = this;
        return getVariantsContainer(this.scope, this.getActionTypes(triggerType), function (item) {
            return item.ident === _this.rule.action.type;
        }, function (after, before) {
            if (after === before || _.isUndefined(after)) {
                return;
            }
            _this.setAction(after.ident);
        });
    };
    ReportRuleCtrl.prototype.setTrigger = function (triggerType) {
        var triggerCompletionType = this.rule.trigger.completionType;
        var triggerDuration = this.rule.trigger.duration;
        this.resetTriggers();
        switch (triggerType) {
            case 0:
                this.rule.timeTrigger = new TimeTrigger();
                break;
            case 1:
                this.rule.parameterConditionTrigger = new ParameterConditionTrigger(this.scope, this.owner.Parameters, this.language);
                break;
            case 3:
                this.rule.selfReportEventTrigger = new SelfReportEventTrigger(this.scope, this.language);
                break;
            case 2:
                this.rule.anotherReportEventTrigger = new AnotherReportEventTrigger(this.scope, this.language, this.reportTemplateProvider, this.notification, this.owner);
                break;
        }
        this.rule.trigger.completionType = triggerCompletionType;
        this.rule.trigger.duration = triggerDuration;
        this.actionTypesVariationContainer.destroy();
        this.actionTypesVariationContainer = this.getActionTypesVariationContainer(this.rule.trigger.type);
        this.actionTypesVariationContainer.selected = _.filter(this.actionTypesVariationContainer, this.filterActionTypes())[0];
        this.setAction(this.actionTypesVariationContainer.selected.ident);
    };
    ReportRuleCtrl.prototype.setAction = function (actionType) {
        this.resetActions();
        switch (actionType) {
            case 0:
                this.rule.recalcAction = new RecalcAction(0);
                break;
            case 3:
                this.rule.fileExportAction = new FileExportAction(this.scope);
                break;
            case 2:
                this.rule.sendingEmailAction = new SendingEmailAction(this.scope, this.reportTemplateProvider, this.notification, this.language, this.modal, this.owner.UniqueGuid, null, this.mailValidationService, this.userPreferencesService);
                break;
            case 4:
                this.rule.lockAction = new LockAction(this.scope, this.language);
                break;
            case 5:
                this.rule.creationAction = new CreationAction(this.scope, this.owner);
                break;
            case 6:
                this.rule.printAction = new PrintAction(this.language, this.notification, this.printProvider);
                break;
            case 7:
                this.rule.deleteAction = new DeleteAction();
        }
    };
    ReportRuleCtrl.prototype.resetActions = function () {
        this.rule.sendingEmailAction = null;
        this.rule.fileExportAction = null;
        this.rule.lockAction = null;
        this.rule.creationAction = null;
        this.rule.recalcAction = null;
        this.rule.printAction = null;
        this.rule.deleteAction = null;
    };
    ReportRuleCtrl.prototype.resetTriggers = function () {
        this.rule.timeTrigger = null;
        this.rule.parameterConditionTrigger = null;
        this.rule.anotherReportEventTrigger = null;
        this.rule.selfReportEventTrigger = null;
    };
    return ReportRuleCtrl;
}());
