var ReportCompletionsProvider = (function () {
    function ReportCompletionsProvider($q, reportFormulaProviderService, externalConnectionsProviderService) {
        this.$q = $q;
        this.reportFormulaProviderService = reportFormulaProviderService;
        this.externalConnectionsProviderService = externalConnectionsProviderService;
    }
    ReportCompletionsProvider.prototype.getCompletions = function () {
        var deferred = this.$q.defer();
        var completions = this.getCalculatorCompletions().concat(this.getMathCompletions());
        this.$q.all({
            formulasCompletions: this.getFormulaCompletion(),
            connectionCompletions: this.getConnectionsCompletions(),
        })
            .then(function (results) {
            deferred.resolve(completions
                .concat(results.formulasCompletions)
                .concat(results.connectionCompletions));
        })
            .catch(function (error) { return deferred.reject(error); });
        return deferred.promise;
    };
    ReportCompletionsProvider.prototype.getFormulaCompletion = function () {
        var _this = this;
        var deferred = this.$q.defer();
        if (_.isDefined(this.formulasCompletions)) {
            deferred.resolve(this.formulasCompletions);
        }
        else {
            this.reportFormulaProviderService.getFormulasInfo()
                .then(function (formulaInfos) {
                _this.formulasCompletions = _.map(formulaInfos, (function (info) {
                    var getDocTooltip = function (formulaInfo) {
                        return "<p style=\"margin-bottom: 5px\"><strong>\u041E\u043F\u0438\u0441\u0430\u043D\u0438\u0435:</strong></p>"
                            + "<p>      ".concat(formulaInfo.description, "</p>")
                            + '<p style="margin-bottom: 5px"><strong>Параметры:</strong></p>'
                            + '<ul style="margin-top: 0px">'
                            + "".concat(_.map(formulaInfo.parameters, function (parameter) {
                                return "<li><em>".concat(parameter.name, " (").concat(_this.escapeHtmlTags(parameter.typeName), "):</em> ").concat(parameter.description, "</li>");
                            }).join(''))
                            + '</ul>'
                            + "<p style=\"margin-bottom: 5px\"><strong>\u0412\u043E\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043C\u043E\u0435 \u0437\u043D\u0430\u0447\u0435\u043D\u0438\u0435 (".concat(_this.escapeHtmlTags(formulaInfo.returnValueTypeName), "):</strong></p>")
                            + "<p>      ".concat(formulaInfo.returnValueDescription, "</p>");
                    };
                    return {
                        caption: info.shortcut,
                        snippet: "".concat(info.name, "(").concat(_.map(info.parameters, function (parameter, index) {
                            var parameterSnippet = "${".concat(index + 1, ":").concat(parameter.description, "}")
                                .replace(/ /g, "_")
                                .toUpperCase();
                            return parameter.typeName.toLowerCase() === 'string'
                                ? "\"".concat(parameterSnippet, "\"")
                                : parameterSnippet;
                        })
                            .join(', '), ")"),
                        meta: 'formula',
                        score: 2,
                        docHTML: getDocTooltip(info)
                    };
                }));
                deferred.resolve(_this.formulasCompletions);
            })
                .catch(function (error) { return deferred.reject(error); });
        }
        return deferred.promise;
    };
    ReportCompletionsProvider.prototype.getConnectionsCompletions = function () {
        var deferred = this.$q.defer();
        this.externalConnectionsProviderService
            .getAll()
            .then(function (connections) {
            deferred.resolve(_.map(connections, function (connection) { return ({
                caption: "\u0421\u043E\u0435\u0434\u0438\u043D\u0435\u043D\u0438\u0435: ".concat(connection.name),
                value: "".concat(connection.id),
                meta: 'connection'
            }); }));
        })
            .catch(function (error) { return deferred.reject(error); });
        return deferred.promise;
    };
    ReportCompletionsProvider.prototype.getCalculatorCompletions = function () {
        return [
            { caption: 'День отчета', value: 'ReportDay', meta: 'property' },
            { caption: 'Неделя отчета', value: 'ReportWeek', meta: 'property' },
            { caption: 'Месяц отчета', value: 'ReportMonth', meta: 'property' },
            { caption: 'Год отчета', value: 'ReportYear', meta: 'property' },
            { caption: 'Метка времени', value: 'Timestamp', meta: 'property' },
            { caption: 'Дата начала отчета', value: 'StartDate', meta: 'property' },
            { caption: 'Дата окончания отчета', value: 'EndDate', meta: 'property' },
            { caption: 'Дата создания отчета', value: 'ReportCreationDate', meta: 'property' },
            { caption: 'Дата обновления отчета', value: 'ReportCreationDate', meta: 'property' },
            { caption: 'Шаг отчета', value: 'Step', meta: 'property' },
            { caption: 'Дата расчета ', value: 'Now', meta: 'property' },
            { caption: 'История расчета', snippet: 'History["${1:НАЗВАНИЕ_ПАРАМЕТРА}"]', value: 'History[${1:"Имя параметра"}]', meta: 'property' },
        ];
    };
    ReportCompletionsProvider.prototype.getMathCompletions = function () {
        return [
            { caption: "abs", snippet: "Math.Abs(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "acos", snippet: "Math.Acos(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "asin", snippet: "Math.Asin(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "atan", snippet: "Math.Atan(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "cos", snippet: "Math.Cos(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "cosh", snippet: "Math.Cosh(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "exp", snippet: "Math.Exp(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "log", snippet: "Math.Log(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "log10", snippet: "Math.Log10(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "pow", snippet: "Math.Pow(${1:ЗНАЧЕНИЕ}, ${2:СТЕПЕНЬ})", meta: "function", score: 1, value: null },
            { caption: "round", snippet: "Math.Round(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "sin", snippet: "Math.Sin(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "sinh", snippet: "Math.Sinh(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "sqrt", snippet: "Math.Sqrt(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "tan", snippet: "Math.Tan(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "tanh", snippet: "Math.Tanh(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "Модуль", snippet: "Math.Abs(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "Арккосинус", snippet: "Math.Acos(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "Арксинус", snippet: "Math.Asin(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "Арктангенс", snippet: "Math.Atan(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "Косинус", snippet: "Math.Cos(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "Гиперболический косинус", snippet: "Math.Cosh(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "Экспонента", snippet: "Math.Exp(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "Натуральный логарифм", snippet: "Math.Log(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "Десятичный логарифм", snippet: "Math.Log10(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "Степень", snippet: "Math.Pow(${1:ЗНАЧЕНИЕ}, ${2:СТЕПЕНЬ})", meta: "function", score: 1, value: null },
            { caption: "Округление", snippet: "Math.Round(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "Синус", snippet: "Math.Sin(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "Гиперболический синус", snippet: "Math.Sinh(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "Квадратный корень", snippet: "Math.Sqrt(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "Тангенс", snippet: "Math.Tan(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
            { caption: "Гиперболический тангенс", snippet: "Math.Tanh(${1:ЗНАЧЕНИЕ})", meta: "function", score: 1, value: null },
        ];
    };
    ReportCompletionsProvider.prototype.escapeHtmlTags = function (text) {
        return text
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;');
    };
    ReportCompletionsProvider.$inject = [
        '$q',
        'reportFormulasProvider',
        'externalConnectionsProvider'
    ];
    return ReportCompletionsProvider;
}());
angular.module('kamhpp')
    .service('reportCompletionsProvider', ReportCompletionsProvider);
