app.directive('freezeTable', [
    '$timeout',
    'blockUI',
    function ($timeout, blockUI) {
        return {
            restrict: 'A',
            scope: {
                freezeRowsCount: '=?',
                freezeColumnsCount: '=?',
            },
            link: function (scope, element) {
                var getHeightOrWidthElementWithConsideringLinearGradient = function (elem, size) {
                    return size;
                };
                blockUI.start();
                $timeout(function () {
                    var tree = $('.tree');
                    var treeWidth = tree.width();
                    var toolbar = $('.toolbar');
                    var toolBarHeight = getHeightOrWidthElementWithConsideringLinearGradient(toolbar, toolbar.offset().top);
                    var options = {
                        contextElement: $('.view'),
                        scrollElement: $('.page'),
                        freezeRowsCount: _.isUndefined(scope.freezeRowsCount) ? 0 : scope.freezeRowsCount,
                        freezeColumnsCount: _.isUndefined(scope.freezeColumnsCount) ? 0 : scope.freezeColumnsCount,
                        freezeHeaderBorder: {
                            shift: {
                                top: toolBarHeight,
                                right: undefined,
                                bottom: undefined,
                                left: treeWidth - 2,
                            },
                            top: function (tableTop, contextTop) {
                                return tableTop - contextTop - this.shift.top;
                            },
                            right: function (tableRight, contextLeft) {
                                return tableRight - this.shift.left;
                            },
                            bottom: function (tableBottom, contextTop) {
                                return tableBottom - contextTop - this.shift.top;
                            },
                            left: function (tableLeft, contextLeft) {
                                return tableLeft;
                            },
                        },
                    };
                    element.freezeHeader(options);
                    blockUI.stop();
                }, 500);
                element.bind('DOMNodeRemovedFromDocument', function (e) {
                    element.freezeHeader('destroy');
                });
                var unregDestroyOnFunc = scope.$on('$destroy', function () {
                    element.unbind('DOMNodeRemovedFromDocument');
                    element.freezeHeader('destroy');
                    unregDestroyOnFunc();
                });
            },
        };
    },
]);
