app.directive('inputTimeSpan', function () {
    return {
        restrict: 'A',
        require: '^ngModel',
        link: function (scope, element, attrs, ngModelCtrl) {
            var lastValidValue = ngModelCtrl.$modelValue;
            ngModelCtrl.$parsers.push(function (viewValue) {
                if (viewValue == '') {
                    return '00:00:00';
                }
                var matches = viewValue.match(/^(([0-1][0-9])|(2[0-3])):([0-5]\d):([0-5]\d)$/);
                if (matches) {
                    lastValidValue = viewValue;
                    return viewValue;
                }
                else {
                    return lastValidValue;
                }
            });
            var unwatch = scope.$watch(function () {
                return ngModelCtrl.$viewValue;
            }, function (value) {
                if (value) {
                    lastValidValue = value;
                    unwatch();
                }
            });
            scope.getValueInput = function () {
                return ngModelCtrl.$modelValue;
            };
            var inputElement = element[0];
            var onFocusOut = function (event) {
                var targetElement = event.relatedTarget ||
                    document.activeElement;
                if (inputElement !== targetElement) {
                    ngModelCtrl.$modelValue = ngModelCtrl.$modelValue
                        ? ngModelCtrl.$modelValue
                        : '00:00:00';
                    ngModelCtrl.$setViewValue(ngModelCtrl.$modelValue);
                    ngModelCtrl.$render();
                }
            };
            if (inputElement.addEventListener) {
                inputElement.addEventListener('blur', onFocusOut, true);
            }
            else {
                inputElement.attachEvent('onfocusout', onFocusOut, true);
            }
        }
    };
});
