angular.module('kamhpp').directive('smsCkeditor', [
    '$rootScope',
    '$timeout',
    function ($rootScope, $timeout) {
        return {
            restrict: 'A',
            scope: {
                value: '=',
                config: '=?',
                inline: '=?',
                buttons: '=?',
                trackFocus: '=?',
                height: '=?',
                onChange: '&onchange',
                startupFocus: '=?'
            },
            link: function (scope, elem) {
                var events = [];
                if (!scope.config) {
                    scope.config = {};
                }
                scope.config.height = _.isDefined(scope.height) ? scope.height : '100%';
                scope.config.allowedContent = true;
                scope.config.skin = 'moono-lisa';
                scope.config.startupFocus = _.isDefined(scope.startupFocus) ? scope.startupFocus : true;
                scope.config.enterMode = CKEDITOR.ENTER_BR;
                scope.config.shiftEnterMode = CKEDITOR.ENTER_P;
                if (scope.config.removePlugins) {
                    scope.config.removePlugins += ', elementspath';
                }
                else {
                    scope.config.removePlugins = 'elementspath';
                }
                if (!scope.config.title) {
                    scope.config.title = false;
                }
                var editor = null;
                if (scope.inline) {
                    CKEDITOR.disableAutoInline = true;
                    editor = CKEDITOR.inline(elem[0], scope.config);
                }
                else {
                    editor = CKEDITOR.replace(elem[0], scope.config);
                }
                _.forEach(scope.buttons, function (button) {
                    editor.addCommand(button.command.name, button.command.definition);
                    editor.ui.addButton(button.button.name, button.button.definition);
                });
                var setData = function (editor, value, noSnapshot) {
                    if (noSnapshot === void 0) { noSnapshot = true; }
                    editor.setData(value, { noSnapshot: noSnapshot });
                    editor.undoManager.reset();
                };
                editor.on('instanceReady', function () {
                    if (_.isEmpty(scope.config.toolbar)) {
                        angular.element('#' + editor.id + '_top').css('display', 'none');
                    }
                    editor.dataProcessor.writer.setRules('p', {
                        breakAfterClose: false,
                    });
                    var sourceDialogLabel = angular.element('#' + editor.id + '_top .cke_button_label.cke_button__sourcedialog_label');
                    if (sourceDialogLabel) {
                        sourceDialogLabel.css('display', 'none');
                    }
                    var sourceLabel = angular.element('#' + editor.id + '_top .cke_button_label.cke_button__source_label');
                    if (sourceLabel) {
                        sourceLabel.css('display', 'none');
                    }
                    editor.dataProcessor.writer.sortAttributes = 0;
                    setData(editor, scope.value);
                    editor.setReadOnly(scope.config.readOnly || false);
                    if (scope.config.startupFocus) {
                        var range = editor.createRange();
                        range.moveToElementEditEnd(range.root);
                        editor.getSelection().selectRanges([range]);
                    }
                    events.push(scope.$watch('value', function (newValue) {
                        if (newValue === editor.getData()) {
                            return;
                        }
                        setData(editor, scope.value);
                    }));
                    events.push(scope.$watch('config.readOnly', function (newValue, oldValue) {
                        if (newValue === oldValue) {
                            return;
                        }
                        editor.setReadOnly(newValue);
                    }));
                    editor.on('change', function () {
                        $timeout(function () {
                            var oldValue = scope.value;
                            scope.value = editor.getData();
                            if (_.isDefined(scope.onChange)) {
                                scope.onChange({ newValue: scope.value, oldValue: oldValue });
                            }
                        });
                    });
                    if (scope.trackFocus) {
                        editor.on('blur', function () {
                            $rootScope.$broadcast('ckInstanceEditorLostFocus', editor);
                        });
                        editor.on('focus', function () {
                            $rootScope.$broadcast('ckInstanceEditorGetFocus', editor);
                        });
                    }
                });
                events.push(scope.$on('$destroy', function () {
                    _.forEach(events, function (event) {
                        if (event) {
                            event();
                        }
                    });
                    editor.destroy();
                }));
            },
        };
    },
]);
