angular.module('kamhpp').filter('formatTimezone', function (dateFilter) {
    return function (utcDate, format, offsetMinutes) {
        if (_.isUndefined(utcDate)) {
            return '';
        }
        var offset = _.isDefined(offsetMinutes)
            ? offsetMinutes
            : Date.getLocalTimezoneUtcOffsetMinutes();
        utcDate = new Date(utcDate.getTime() + offset * 60 * 1000);
        return dateFilter(utcDate, format);
    };
});
