var JsonAccessTokenInterceptor = (function () {
    function JsonAccessTokenInterceptor($q, authentication, language, $injector) {
        var _this = this;
        this.$q = $q;
        this.authentication = authentication;
        this.language = language;
        this.$injector = $injector;
        this.request = function (config) {
            config.headers = config.headers || {};
            var authHeader = _this.authentication.getAccessTokenHeader();
            if (authHeader) {
                config.headers.Authorization = authHeader;
            }
            return config;
        };
        this.responseError = function (response) {
            var deferred = _this.$q.defer();
            if (response.status === 401 && response.data[dto.reasonProblemResponseFieldName] === 'JwtTokenInvalidOrMissingOrExpired') {
                _this.authentication.refreshToken().then(function (accessToken) {
                    var retryConfig = response.config;
                    retryConfig.headers.Authorization = "Bearer ".concat(accessToken);
                    var $http = _this.$injector.get('$http');
                    $http(retryConfig).then(deferred.resolve, deferred.reject);
                }).catch(function () {
                    _this.$injector.get('notificationService').errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), response);
                    deferred.reject(response);
                });
            }
            else {
                deferred.reject(response);
            }
            return deferred.promise;
        };
    }
    JsonAccessTokenInterceptor.Factory = function ($q, authentication, language, $injector) {
        return new JsonAccessTokenInterceptor($q, authentication, language, $injector);
    };
    JsonAccessTokenInterceptor.$inject = ['$q', 'authentication', 'language', '$injector'];
    return JsonAccessTokenInterceptor;
}());
