var TableSelectedInfo = (function () {
    function TableSelectedInfo() {
        this.rowIndex = undefined;
        this.colIndex = undefined;
        this.item = undefined;
    }
    return TableSelectedInfo;
}());
var TableScope = (function () {
    function TableScope(notificationService) {
        this.selected = new TableSelectedInfo();
        this.validatedCells = new Dictionary();
        this.notificationService = notificationService;
    }
    TableScope.prototype.selectCell = function (rowIndex, colIndex) {
        this.clearSelection();
        this.selected.rowIndex = rowIndex;
        this.selected.colIndex = colIndex;
        if (this.items != undefined) {
            this.selected.item = this.items[rowIndex];
            if (!_.isUndefined(this.afterSelectedChange)) {
                this.afterSelectedChange(this.selected.item);
            }
        }
    };
    TableScope.prototype.clearSelection = function () {
        this.selected.rowIndex = undefined;
        this.selected.colIndex = undefined;
        this.selected.item = undefined;
    };
    TableScope.prototype.successValidation = function (item, colIndex) {
        var verifiableRow = this.validatedCells.get(item);
        if (_.isUndefined(verifiableRow)) {
            verifiableRow = [];
            this.validatedCells.add(item, verifiableRow);
        }
        verifiableRow[colIndex] = true;
    };
    TableScope.prototype.errorValidation = function (item, colIndex, msg) {
        var verifiableRow = this.validatedCells.get(item);
        if (_.isUndefined(verifiableRow)) {
            verifiableRow = [];
            this.validatedCells.add(item, verifiableRow);
        }
        verifiableRow[colIndex] = false;
        this.notificationService.warnMessage(msg);
    };
    TableScope.prototype.isValid = function (rowIndex, colIndex) {
        var verifiableRow = this.validatedCells.get(this.items[rowIndex]);
        if (_.isUndefined(verifiableRow)) {
            return true;
        }
        if (_.isUndefined(verifiableRow[colIndex])) {
            return true;
        }
        return verifiableRow[colIndex];
    };
    TableScope.prototype.thereAreInorrectChanges = function () {
        return _.some(this.validatedCells.values(), function (row) {
            return _.some(row, function (o) {
                return o === false;
            });
        });
    };
    TableScope.prototype.setFocus = function (currentValue, rowIndex, colIndex) {
        this.beforeChangeValue = currentValue;
    };
    TableScope.prototype.loseFocus = function (newValue, rowIndex, colIndex) {
        var _this = this;
        if (newValue === this.beforeChangeValue) {
            return;
        }
        if (this.validate != undefined) {
            var item_1 = this.items[rowIndex];
            this.validate(item_1, rowIndex, colIndex).then(function () {
                _this.successValidation(item_1, colIndex);
            }, function (msg) {
                _this.errorValidation(item_1, colIndex, msg);
            });
        }
        if (!_.isUndefined(this.afterItemChange)) {
            this.afterItemChange(this.beforeChangeValue, newValue, rowIndex, colIndex);
        }
    };
    return TableScope;
}());
