﻿BEGIN TRANSACTION;

CREATE TABLE [SFTemplates] (
    [Id] int IDENTITY NOT NULL,
    [Name] nvarchar(450) NOT NULL,
    [HeaderHtml] nvarchar(max) NULL,
    [FooterHtml] nvarchar(max) NULL,
    [IsTypical] bit NOT NULL,
    [CreationDate] datetime NULL,
    [CreatedUserName] nvarchar(max) NOT NULL,
    [ParentTemplateId] int NULL,
    CONSTRAINT [PK_SFTemplates] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_SFTemplates_SFTemplates_ParentTemplateId] FOREIGN KEY ([ParentTemplateId]) REFERENCES [SFTemplates] ([Id]),
    CONSTRAINT [UQ_Name] UNIQUE([Name])
);

CREATE TABLE [SFForms] (
    [Id] int IDENTITY NOT NULL,
    [TemplateId] int NULL,
    [Name] nvarchar(450) NOT NULL,
    [SerialNumber] INT NOT NULL CHECK ([SerialNumber] > 0),
    [HeaderHtml] nvarchar(max) NULL,
    [FooterHtml] nvarchar(max) NULL,
    [Status] int NOT NULL,
    [CreationDate] datetime NOT NULL,
    [CloseDate] datetime NULL,
    [StopDate] datetime NULL,
    [StopReason] nvarchar(max) NULL,
    [StopUserFullName] nvarchar(max) NULL,
    CONSTRAINT [PK_SFForms] PRIMARY KEY ([Id]),
    CONSTRAINT [UQ_Name_SerialNumber] UNIQUE([Name], [SerialNumber]),
    CONSTRAINT [FK_SFForms_SFTemplates_TemplateId] FOREIGN KEY ([TemplateId]) REFERENCES [SFTemplates] ([Id]) ON DELETE SET NULL
);

CREATE TABLE [SFFormOperations] (
    [Id] int IDENTITY NOT NULL,
    [Description] nvarchar(max) NOT NULL,
    [Type] int NOT NULL,
    [OrderNumber] int NOT NULL,
    [Status] int NOT NULL,
    [ExecutionDate] datetime NULL,
    [RemoteControlKeyPosition] int NOT NULL,
    [SwitchoverFormId] int NOT NULL,
    CONSTRAINT [PK_SFFormOperations] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_SFFormOperations_SFForms_SwitchoverFormId] FOREIGN KEY ([SwitchoverFormId]) REFERENCES [SFForms] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [SFFormConditions] (
    [Id] int IDENTITY NOT NULL,
    [Description] nvarchar(max) NOT NULL,
    [Type] int NOT NULL,
    [OrderNumber] int NOT NULL,
    [Status] int NOT NULL,
    [ExecutionDate] datetime NULL,
    [RemoteControlKeyPosition] int NOT NULL,
    [SwitchoverFormId] int NOT NULL,
    CONSTRAINT [PK_SFFormConditions] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_SFFormConditions_SFForms_SwitchoverFormId] FOREIGN KEY ([SwitchoverFormId]) REFERENCES [SFForms] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [SFFormOperationCommands] (
    [Id] int IDENTITY NOT NULL,
    [Name] nvarchar(max) NULL,
    [Type] int NOT NULL,
    [Source] int NOT NULL,
    [OrderNumber] int NOT NULL,
    [TagAddress] nvarchar(max) NOT NULL,
    [Value] nvarchar(max) NOT NULL,
    [SwitchoverFormOperationId] int NOT NULL,
    CONSTRAINT [PK_SFFormOperationCommands] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_SFFormOperationCommands_SFFormOperations_SwitchoverFormOperationId] FOREIGN KEY ([SwitchoverFormOperationId]) REFERENCES [SFFormOperations] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [SFFormConditionCommands] (
    [Id] int IDENTITY NOT NULL,
    [Name] nvarchar(max) NULL,
    [Type] int NOT NULL,
    [Source] int NOT NULL,
    [OrderNumber] int NOT NULL,
    [TagAddress] nvarchar(max) NOT NULL,
    [Value] nvarchar(max) NOT NULL,
    [SwitchoverFormConditionId] int NOT NULL,
    CONSTRAINT [PK_SFFormConditionCommands] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_SFFormConditionCommands_SFFormConditions_SwitchoverFormConditionId] FOREIGN KEY ([SwitchoverFormConditionId]) REFERENCES [SFFormConditions] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [SFSettings] (
    [Name] nvarchar(128) NOT NULL,
    [Value] nvarchar(max) NULL,
    CONSTRAINT [PK_SFSettings] PRIMARY KEY ([Name])
);

CREATE TABLE [SFOperations] (
    [Id] int IDENTITY NOT NULL,
    [Description] nvarchar(max) NOT NULL,
    [Type] int NOT NULL,
    [IsTypical] bit NOT NULL,
    CONSTRAINT [PK_SFOperations] PRIMARY KEY ([Id])
);

CREATE TABLE [SFConditions] (
    [Id] int IDENTITY NOT NULL,
    [Description] nvarchar(max) NOT NULL,
    [Type] int NOT NULL,
    [IsTypical] bit NOT NULL,
    CONSTRAINT [PK_SFConditions] PRIMARY KEY ([Id])
);

CREATE TABLE [SFTemplateOperation] (
    [Id] int IDENTITY NOT NULL,
    [SwitchoverFormTemplateId] int NOT NULL,
    [SwitchoverFormCommonOperationId] int NOT NULL,
    [OrderNumber] int NOT NULL,
    CONSTRAINT [PK_SFTemplateOperation] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_SFTemplateOperation_SFTemplates_SwitchoverFormTemplateId] FOREIGN KEY ([SwitchoverFormTemplateId]) REFERENCES [SFTemplates] ([Id]) ON DELETE CASCADE,
    CONSTRAINT [FK_SFTemplateOperation_SFOperations_SwitchoverFormCommonOperationId] FOREIGN KEY ([SwitchoverFormCommonOperationId]) REFERENCES [SFOperations] ([Id])
);

CREATE TABLE [SFTemplateCondition] (
    [Id] int IDENTITY NOT NULL,
    [SwitchoverFormTemplateId] int NOT NULL,
    [SwitchoverFormCommonConditionId] int NOT NULL,
    [OrderNumber] int NOT NULL,
    CONSTRAINT [PK_SFTemplateCondition] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_SFTemplateCondition_SFTemplates_SwitchoverFormTemplateId] FOREIGN KEY ([SwitchoverFormTemplateId]) REFERENCES [SFTemplates] ([Id]) ON DELETE CASCADE,
    CONSTRAINT [FK_SFTemplateCondition_SFConditions_SwitchoverFormCommonConditionId] FOREIGN KEY ([SwitchoverFormCommonConditionId]) REFERENCES [SFConditions] ([Id])
);

CREATE TABLE [SFOperationCommands] (
    [Id] int IDENTITY NOT NULL,
    [Name] nvarchar(max) NULL,
    [Type] int NOT NULL,
    [Source] int NOT NULL,
    [OrderNumber] int NOT NULL,
    [TagAddress] nvarchar(max) NOT NULL,
    [Value] nvarchar(max) NOT NULL,
    [SwitchoverFormCommonOperationId] int NOT NULL,
    CONSTRAINT [PK_SFOperationCommands] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_SFOperationCommands_SFOperations_SwitchoverFormCommonOperationId] FOREIGN KEY ([SwitchoverFormCommonOperationId]) REFERENCES [SFOperations] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [SFConditionCommands] (
    [Id] int IDENTITY NOT NULL,
    [Name] nvarchar(max) NULL,
    [Type] int NOT NULL,
    [Source] int NOT NULL,
    [OrderNumber] int NOT NULL,
    [TagAddress] nvarchar(max) NOT NULL,
    [Value] nvarchar(max) NOT NULL,
    [SwitchoverFormCommonConditionId] int NOT NULL,
    CONSTRAINT [PK_SFConditionCommands] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_SFConditionCommands_SFConditions_SwitchoverFormConditionId] FOREIGN KEY ([SwitchoverFormCommonConditionId]) REFERENCES [SFConditions] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [SFFormAlarms] (
    [Id] int IDENTITY NOT NULL,
    [Name] nvarchar(max) NOT NULL,
    [SwitchoverFormId] int NOT NULL,
    CONSTRAINT [PK_SFFormAlarms] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_SFFormAlarms_SFForms_SwitchoverFormId] FOREIGN KEY ([SwitchoverFormId]) REFERENCES [SFForms] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [SFFormAlarmCommands] (
    [Id] int IDENTITY NOT NULL,
    [Name] nvarchar(max) NULL,
    [Source] int NOT NULL,
    [TagAddress]  nvarchar(max) NOT NULL,
    [Value] nvarchar(max) NOT NULL,
    [SwitchoverFormAlarmId] int NOT NULL,
    CONSTRAINT [PK_SFFormAlarmCommands] PRIMARY KEY ([Id]),
    CONSTRAINT[FK_SFFormAlarmCommands_SFFormAlarms_SwitchoverFormAlarmId] FOREIGN KEY ([SwitchoverFormAlarmId]) REFERENCES [SFFormAlarms] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [SFFormCommonAlarms] (
    [Id] int IDENTITY NOT NULL,
    [Name] nvarchar(max) NOT NULL,
    CONSTRAINT [PK_SFFormCommonAlarms] PRIMARY KEY ([Id])
);

CREATE TABLE [SFFormCommonAlarmCommands] (
    [Id] int IDENTITY NOT NULL,
    [Name] nvarchar(max) NULL,
    [Source] int NOT NULL,
    [TagAddress] nvarchar(max) NOT NULL,
    [Value] nvarchar(max) NOT NULL,
    [SwitchoverFormCommonAlarmId] int NOT NULL,
    CONSTRAINT [PK_SFFormCommonAlarmCommands] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_SFFormCommonAlarmCommands_SFFormCommonAlarms_SwitchoverFormCommonAlarmId] FOREIGN KEY ([SwitchoverFormCommonAlarmId]) REFERENCES [SFFormCommonAlarms] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [SFFormTemplateAlarms] (
    [SwitchoverFormTemplateId] int NOT NULL,
    [SwitchoverFormCommonAlarmId] int NOT NULL,
    CONSTRAINT [PK_SFFormTemplateAlarms] PRIMARY KEY ([SwitchoverFormTemplateId], [SwitchoverFormCommonAlarmId]),
    CONSTRAINT [FK_SFFormTemplateAlarms_SFTemplates_SwitchoverFormTemplateId] FOREIGN KEY ([SwitchoverFormTemplateId]) REFERENCES [SFTemplates] ([Id]) ON DELETE CASCADE,
    CONSTRAINT [FK_SFFormTemplateAlarms_SFFormCommonAlarms_SwitchoverFormCommonAlarmId] FOREIGN KEY ([SwitchoverFormCommonAlarmId]) REFERENCES [SFFormCommonAlarms] ([Id])
);

CREATE INDEX [IX_SFFormOperations_SwitchoverFormId] ON [SFFormOperations] ([SwitchoverFormId]);

CREATE INDEX [IX_SFFormConditions_SwitchoverFormId] ON [SFFormConditions] ([SwitchoverFormId]);

CREATE INDEX [IX_SFFormOperationCommands_SwitchoverFormOperationId] ON [SFFormOperationCommands] ([SwitchoverFormOperationId]);

CREATE INDEX [IX_SFFormConditionCommands_SwitchoverFormConditionId] ON [SFFormConditionCommands] ([SwitchoverFormConditionId]);

CREATE INDEX [IX_SFTemplates_ParentTemplateId] ON [SFTemplates] ([ParentTemplateId]);

CREATE INDEX [IX_SFTemplateOperation_SwitchoverFormTemplateId] ON [SFTemplateOperation] ([SwitchoverFormTemplateId]);

CREATE INDEX [IX_SFTemplateOperation_SwitchoverFormCommonOperationId] ON [SFTemplateOperation] ([SwitchoverFormCommonOperationId]);

CREATE INDEX [IX_SFTemplateCondition_SwitchoverFormTemplateId] ON [SFTemplateCondition] ([SwitchoverFormTemplateId]);

CREATE INDEX [IX_SFTemplateCondition_SwitchoverFormCommonConditionId] ON [SFTemplateCondition] ([SwitchoverFormCommonConditionId]);

CREATE INDEX [IX_SFOperationCommands_SwitchoverFormCommonOperationId] ON [SFOperationCommands] ([SwitchoverFormCommonOperationId]);

CREATE INDEX [IX_SFConditionCommands_SwitchoverFormCommonConditionId] ON [SFConditionCommands] ([SwitchoverFormCommonConditionId]);

CREATE INDEX [IX_SFFormAlarms_SwitchoverFormId] ON [SFFormAlarms] ([SwitchoverFormId]);

CREATE INDEX [IX_SFFormAlarmCommands_SwitchoverFormAlarmId] ON [SFFormAlarmCommands] ([SwitchoverFormAlarmId]);

CREATE INDEX [IX_SFFormTemplateAlarms_SwitchoverFormTemplateId] ON [SFFormTemplateAlarms] ([SwitchoverFormTemplateId]);

CREATE INDEX [IX_SFFormTemplateAlarms_SwitchoverFormCommonAlarmId] ON [SFFormTemplateAlarms] ([SwitchoverFormCommonAlarmId]);

CREATE INDEX [IX_SFFormCommonAlarmCommands_SwitchoverFormCommonAlarmId] ON [SFFormCommonAlarmCommands] ([SwitchoverFormCommonAlarmId]);

COMMIT;

