// $License: NOLICENSE
//--------------------------------------------------------------------------------
/**
  Функции по работе с алармами из отчетов ТехноДок

  @file $relPath
  @copyright $copyright
  @author SMS-Automation
*/

//--------------------------------------------------------------------------------
// Libraries used (#uses)
#uses "Technodoc/Common/technodocTime"
#uses "Technodoc/Common/technodocDatapoint"


//--------------------------------------------------------------------------------
// Variables and Constants


//--------------------------------------------------------------------------------
//@public members
//--------------------------------------------------------------------------------

/** Вернуть список аварий по указанному оборудованию на указанный момент времени
  @param dp Адрес точки данных
  @param t Метка времени
  @return Список состоящий из списка со структурой:
      0 - Текст алерта
      1 - Время прихода
      2 - Время ухода
*/
dyn_dyn_string getAlarms(string dp, time t)
{
    string correctAddress = getCorrectDpAddress(dp);
    dyn_dyn_string result;

    dyn_string dps = dpNames(correctAddress + ".Alm.*.*");

    for (int i = 1; i <= dynlen(dps); i++)
    {
        // Тег должен архивироваться, иначе нет исторических данных
        bool isArchived;
        dpGet(dps[i] + ":_archive.._archive", isArchived);

        if (!isArchived)
            continue;

        // В теге на заданный момент времени должен быть признак аварии
        bool isAlarm;
        dpGetAsynch(t, dps[i], isAlarm);

        if (!isAlarm)
            continue;

        dyn_string alert = getAlertsForAlarm(dps[i], t);
        dynAppend(result, alert);
    }

    return result;
}

/** Вернуть список аварий по указанному оборудованию на указанный период времени
  @param dp Адрес точки данных
  @param startTime Дата начала периода
  @param endTime Дата окончания периода
  @return  Список состоящий из списка со структурой:
      0 - Текст алерта
      1 - Время прихода
      2 - Время ухода
*/
dyn_dyn_string getAlarmsOnPeriod(string dp, time startTime, time endTime)
{
    string correctAddress = getCorrectDpAddress(dp);

    dyn_dyn_string result;
    string start = timeToStringForUtcTD(startTime),
    end = timeToStringForUtcTD(endTime);
    dyn_string istDP = strsplit(correctAddress, ":");
    dyn_dyn_anytype resultQuery;
    string sQuery = "SELECT ALERT '_alert_hdl.._text', '_alert_hdl.._ack_time', '_alert_hdl.._class' " +
	    "FROM \'" + istDP[2] + "\' " +
	    "REMOTE \'" + istDP[1] + ":\' " +
	    "TIMERANGE(\"" + start + "\",\"" + end + "\",1,0) " +
	    "SORT BY 2";
    // DebugTN(sQuery);
    dpQuery(sQuery,	resultQuery);

    if (dynlen(resultQuery) > 1)
    {
      for(int i = 2; i <= dynlen(resultQuery); i++)
      {
        dynAppend(result,
          makeDynString((string)resultQuery[i][3],
            (string)resultQuery[i][2],
            (string)resultQuery[i][5]));
      }
    }
    return result;
}

//--------------------------------------------------------------------------------
//@private members
//--------------------------------------------------------------------------------

/** Вернуть информацию об аварийном сигнале за метку времени
  @param dp
  @param t
  @return Информация об аварийном сигнале в виде списка со структурой:
      0 - Текст алерта
      1 - Время прихода
      2 - Время ухода
*/
private dyn_string getAlertsForAlarm(string dp, time t)
{
    dyn_bool values;
    dyn_time times;

    // count = 3 для предотвращения случаев, когда значение TRUE установилось два раза подряд
    dpGetPeriod(t, addMillisecondsTD(t, 1), 3, dp, values, times);

    time startTime;
    time endTime;

    for (int i = 1; i <= dynlen(times); i++)
    {
        if ((times[i] <= t) && (values[i] == true))
            startTime = times[i];

        if ((times[i] >= t) && (values[i] == false))
            endTime = times[i];
    }

    return makeDynString(dpGetDescription(dp), TimeToStr(startTime), TimeToStr(endTime));
}
