// $License: NOLICENSE
//--------------------------------------------------------------------------------
/**
  Функции по работе с авторизацией

  @file $relPath
  @copyright $copyright
  @author SMS-Automation
*/

//--------------------------------------------------------------------------------
// Libraries used (#uses)

#uses "Technodoc/Common/technodocNet"

//--------------------------------------------------------------------------------
// Variables and Constants

// Тип аутентификации по умолчанию
const int STANDARD_AUTH_TYPE = 0;

//--------------------------------------------------------------------------------
//@public members
//--------------------------------------------------------------------------------

/** Авторизоваться в ТехноДоке
  @param hostAddress Адрес сервера ТехноДок
  @param login Имя пользователя
  @param password Пароль
  @return Токен авторизации
*/
string getAccessToken(string hostAddress, string login, string password) {
  string url = hostAddress + "/api/Authentication/GetAccessToken";
  string content = "{"
    + "login: \"" + login + "\","
    + "password: \"" + password + "\","
    + "authenticationType: " + STANDARD_AUTH_TYPE
    + "}";

  mapping response;
  mapping headers = makeMapping("Content-Type","application/json; charset=utf-8");
  mapping data = makeMapping("content", content,
                             "headers", headers);

  int result = technodocNetPost(url, data, response);

  if (result != 0) {
    DebugTN("Не удалось авторизоваться в ПО \"ТехноДок\"."
           + " Код состояния: " + response["httpStatusCode"] + ": " + response["httpStatusText"] + "."
           + " Подробности: " + response["errorString"]);

    return "";
  }

  return response["content"];
}

/*
  Получить список ролей пользователя
*/
string getUserRoles(string userName)
{
  //DebugN(userName);
  unsigned userId = getUserId(userName);
  string groups;
  dyn_mapping groupInfos = getGroupsOfUserPVSS(userId);

  for (int i = 1; i <= dynlen(groupInfos); i++)
  {
    if(i == 1)
    {
      groups = groups + groupInfos[i].Name;
    }
    else
    {
      groups = groups + "," + groupInfos[i].Name;
    }
  }

  return groups;
}

