var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ReportParameter = (function () {
    function ReportParameter(parameter) {
        if (!parameter) {
            this.Decimal = 2;
            this.Backlight = [];
        }
        else {
            this.Source = parameter.Source;
            this.Ident = parameter.Ident;
            this.Timestamp = parameter.Timestamp;
            this.CopyOrientation = parameter.CopyOrientation;
            this.Formula = parameter.Formula;
            this.ParameterType = parameter.ParameterType;
            this.Decimal = parameter.Decimal;
            this.Editable = parameter.Editable;
            this.Planned = parameter.Planned;
            this.Predefined = parameter.Predefined;
            this.Splitted = parameter.Splitted;
            this.Compilable = parameter.Compilable;
            this.IsExternal = parameter.IsExternal;
            this.DependencyParameters = parameter.DependencyParameters;
            this.Sign = parameter.Sign;
            this.Aggregation = AggregationSettings.clone(parameter.Aggregation);
            this.MsSql = MsSqlSettings.clone(parameter.MsSql);
            this.MySql = MySqlSettings.clone(parameter.MySql);
            this.Influx = InfluxSettings.clone(parameter.Influx);
            this.Oracle = OracleSettings.clone(parameter.Oracle);
            this.Piramida = PiramidaSettings.clone(parameter.Piramida);
            this.Excel = ExcelSettings.clone(parameter.Excel);
            this.Log = ReportParameterLog.clone(parameter.Log);
            this.Dropdown = ReportParameterDropdown.clone(parameter.Dropdown);
            this.Chart = ReportParameterChart.clone(parameter.Chart);
            this.Dictionary = ReportParameterDictionary.clone(parameter.Dictionary);
            this.DictionaryDropdown = DictionaryDropdown.clone(parameter.DictionaryDropdown);
            this.OperationTime = ReportParameterOperationTime.clone(parameter.OperationTime);
            this.OperationTimeDiagram = OperationTimeDiagramSettings.clone(parameter.OperationTimeDiagram);
            this.Opc = OpcSettings.clone(parameter.Opc);
            this.OleDb = OleDbSettings.clone(parameter.OleDb);
            this.RandomValue = ReportParameterRandomValue.clone(parameter.RandomValue);
            this.Navigation = NavigationSettings.clone(parameter.Navigation);
            this.Backlight = _.isUndefined(parameter.Backlight)
                ? parameter.Backlight
                : _.map(parameter.Backlight, function (p) { return ReportParameterBacklight.clone(p); });
            this.SpecificDate = ReportSpecificDate.clone(parameter.SpecificDate);
            this.Odbc = OdbcSettings.clone(parameter.Odbc);
            this.Wincc = ReportParameterWincc.clone(parameter.Wincc);
            this.WinccOa = WinccOaSettings.clone(parameter.WinccOa);
            this.Report = ReportLinkSettings.clone(parameter.Report);
            this.Sign = SignSettings.clone(parameter.Sign);
            this.Http = HttpSettings.clone(parameter.Http);
            this.WinccOaInflux = WinccOaInfluxSettings.clone(parameter.WinccOaInflux);
            this.PostgreSql = PostgreSqlSettings.clone(parameter.PostgreSql);
            this.File = FileSettings.clone(parameter.File);
            this.ClientFile = UserFileSettings.clone(parameter.ClientFile);
        }
    }
    Object.defineProperty(ReportParameter.prototype, "SourceName", {
        get: function () {
            var _this = this;
            return _.find(TemplateParametersCtrl.parameterSourcesWithGroups, function (s) { return s.ident == _this.Source; }).name;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ReportParameter.prototype, "SourceGroup", {
        get: function () {
            var _this = this;
            return _.find(TemplateParametersCtrl.parameterSourcesWithGroups, function (s) { return s.ident == _this.Source; }).group;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ReportParameter.prototype, "TagAddress", {
        get: function () {
            switch (this.ParameterType) {
                case "OpcValue":
                    return this.Opc.address;
                case "WinccValue":
                    return this.Wincc.tagName;
                case "WinccOaValue":
                    return this.WinccOa.requestDPValuesSettings.uploadAddress;
                default:
                    return undefined;
            }
        },
        enumerable: false,
        configurable: true
    });
    ReportParameter.prototype.getParameterSettings = function () {
        switch (this.Source) {
            case 'aggregation':
                return this.Aggregation;
            case 'signature':
                return this.Sign;
            case 'dropdown':
                return this.Dropdown;
            case 'log':
                return this.Log;
            case 'chart':
                return this.Chart;
            case 'dictionary':
                return this.Dictionary;
            case 'operationTime':
                return this.OperationTime;
            case 'operationTimeDiagram':
                return this.OperationTimeDiagram;
            case 'randomValue':
                return this.RandomValue;
            case 'msSql':
                return this.MsSql;
            case 'mySql':
                return this.MySql;
            case 'influx':
                return this.Influx;
            case 'oracle':
                return this.Oracle;
            case 'piramida':
                return this.Piramida;
            case 'excel':
                return this.Excel;
            case 'opc':
                return this.Opc;
            case 'navigation':
                return this.Navigation;
            case 'odbc':
                return this.Odbc;
            case 'wincc':
                return this.Wincc;
            case 'report':
                return this.Report;
            case 'specificDate':
                return this.SpecificDate;
            case 'winccoa':
                return this.WinccOa;
            case 'http':
                return this.Http;
            case 'winccOaInflux':
                return this.WinccOaInflux;
            case 'postgreSql':
                return this.PostgreSql;
            case 'oleDb':
                return this.OleDb;
            case 'file':
                return this.File;
            case UserFileSettings.UserFileParameterTypeName:
                return this.ClientFile;
            default:
                return null;
        }
    };
    ReportParameter.prototype.setSource = function (source, reportTemplateGuid, reportType, reportHasStep, language, needChangeFormula) {
        if (needChangeFormula === void 0) { needChangeFormula = true; }
        this.Source = source;
        this.Aggregation = null;
        this.Piramida = null;
        this.Chart = null;
        this.Dictionary = null;
        this.DictionaryDropdown = null;
        this.OperationTime = null;
        this.OperationTimeDiagram = null;
        this.RandomValue = null;
        this.Dropdown = null;
        this.Log = null;
        this.MsSql = null;
        this.MySql = null;
        this.Influx = null;
        this.Oracle = null;
        this.Excel = null;
        this.SpecificDate = null;
        this.Navigation = null;
        this.Odbc = null;
        this.Opc = null;
        this.Wincc = null;
        this.Report = null;
        this.Splitted = false;
        this.Planned = false;
        this.Predefined = false;
        this.Editable = true;
        this.Compilable = true;
        this.IsExternal = false;
        this.Sign = null;
        this.WinccOa = null;
        this.Http = null;
        this.OleDb = null;
        this.WinccOaInflux = null;
        this.PostgreSql = null;
        this.File = null;
        this.ClientFile = null;
        switch (this.Source) {
            case 'aggregation':
                this.Aggregation = new AggregationSettings(reportHasStep);
                this.Planned = true;
                this.Timestamp = 1;
                break;
            case 'signature':
                this.Sign = new SignSettings();
                break;
            case 'dropdown':
                this.Editable = true;
                this.Dropdown = new ReportParameterDropdown();
                break;
            case 'log':
                this.Planned = true;
                this.Log = new ReportParameterLog();
                this.Log.fields = [];
                this.Log.widthDimension = 'px';
                this.Log.initialParameter = undefined;
                break;
            case 'chart':
                this.Chart = new ReportParameterChart();
                this.Planned = true;
                this.Timestamp = 1;
                break;
            case 'dictionary':
                this.Planned = true;
                this.Dictionary = new ReportParameterDictionary();
                break;
            case 'operationTime':
                this.OperationTime = new ReportParameterOperationTime();
                break;
            case 'operationTimeDiagram':
                this.Planned = true;
                this.OperationTimeDiagram = new OperationTimeDiagramSettings();
                break;
            case 'randomValue':
                this.RandomValue = new ReportParameterRandomValue();
                this.Planned = true;
                break;
            case 'msSql':
                this.MsSql = new MsSqlSettings();
                break;
            case 'mySql':
                this.MySql = new MySqlSettings();
                break;
            case 'influx':
                this.Influx = new InfluxSettings();
                break;
            case 'oracle':
                this.Oracle = new OracleSettings();
                break;
            case 'piramida':
                this.Piramida = new PiramidaSettings(reportHasStep);
                break;
            case 'excel':
                this.Excel = new ExcelSettings();
                break;
            case 'opc':
                this.Opc = new OpcSettings(reportHasStep);
                break;
            case 'specificDate':
                this.Planned = true;
                this.SpecificDate = new ReportSpecificDate();
                break;
            case 'navigation':
                this.Navigation = new NavigationSettings(language.getElementValue('reportParameterNavigationTitleBtn'));
                break;
            case 'odbc':
                this.Odbc = new OdbcSettings();
                break;
            case 'wincc':
                this.Wincc = new ReportParameterWincc(reportHasStep);
                break;
            case 'report':
                this.Report = new ReportLinkSettings(reportTemplateGuid, reportHasStep);
                break;
            case 'winccoa':
                this.WinccOa = new WinccOaSettings(reportHasStep);
                break;
            case 'http':
                this.Http = new HttpSettings();
                break;
            case 'winccOaInflux':
                this.WinccOaInflux = new WinccOaInfluxSettings(reportHasStep);
                break;
            case 'postgreSql':
                this.PostgreSql = new PostgreSqlSettings();
                break;
            case 'oleDb':
                this.OleDb = new OleDbSettings();
                break;
            case 'file':
                this.File = new FileSettings();
                break;
            case 'calc':
                if (needChangeFormula) {
                    this.Formula = 'return 0;';
                    this.ParameterType = 'double';
                }
                break;
            case UserFileSettings.UserFileParameterTypeName:
                this.ClientFile = new UserFileSettings();
                break;
        }
        if (source !== 'aggregation' && source != 'chart' && reportType === 1 && reportHasStep) {
            this.Timestamp = this.SourceGroup === language.getElementValue('groupComponentsHdr')
                ? 0
                : 3;
        }
    };
    ReportParameter.prototype.canEdited = function () {
        switch (this.Source) {
            case 'calc':
                return true;
            case 'userNumber':
                return false;
            default:
                return this.getParameterSettings().canEdited();
        }
    };
    ReportParameter.prototype.canPlanned = function () {
        return this.Source === 'calc' || this.Source === 'userNumber'
            ? true
            : this.getParameterSettings().canPlanned();
    };
    ReportParameter.prototype.canPredefined = function () {
        if (this.Source === 'calc') {
            return this.ParameterType === 'int' ||
                this.ParameterType === 'int?' ||
                this.ParameterType === 'double' ||
                this.ParameterType === 'double?' ||
                this.ParameterType === 'string' ||
                this.ParameterType === 'DateTime' ||
                this.ParameterType === 'DropDownValue' ||
                this.ParameterType === 'ReportFileValue';
        }
        return this.Source === 'userNumber' || this.getParameterSettings().canPredefined();
    };
    ReportParameter.clone = function (parameter) {
        return new ReportParameter(parameter);
    };
    ReportParameter.isEqual = function (parameter, other) {
        if (parameter.Source !== other.Source ||
            parameter.Ident !== other.Ident ||
            parameter.Timestamp !== other.Timestamp ||
            parameter.CopyOrientation !== other.CopyOrientation ||
            (other.Source === 'calc' && parameter.Formula !== other.Formula) ||
            parameter.ParameterType !== other.ParameterType ||
            parameter.Decimal !== other.Decimal ||
            parameter.Editable !== other.Editable ||
            parameter.Splitted !== other.Splitted ||
            parameter.Planned !== other.Planned ||
            parameter.Predefined !== other.Predefined ||
            parameter.Compilable !== other.Compilable ||
            parameter.IsExternal !== other.IsExternal) {
            return false;
        }
        if (_.isUndefined(parameter.Backlight) || _.isUndefined(other.Backlight)) {
            if (parameter.Backlight !== other.Backlight) {
                return false;
            }
        }
        else if (parameter.Backlight.length !== other.Backlight.length) {
            return false;
        }
        return (AggregationSettings.isEqual(parameter.Aggregation, other.Aggregation) &&
            MsSqlSettings.isEqual(parameter.MsSql, other.MsSql) &&
            MySqlSettings.isEqual(parameter.MySql, other.MySql) &&
            InfluxSettings.isEqual(parameter.Influx, other.Influx) &&
            OracleSettings.isEqual(parameter.Oracle, other.Oracle) &&
            PiramidaSettings.isEqual(parameter.Piramida, other.Piramida) &&
            ExcelSettings.isEqual(parameter.Excel, other.Excel) &&
            ReportParameterDropdown.isEqual(parameter.Dropdown, other.Dropdown) &&
            ReportParameterChart.isEqual(parameter.Chart, other.Chart) &&
            ReportParameterDictionary.isEqual(parameter.Dictionary, other.Dictionary) &&
            DictionaryDropdown.isEqual(parameter.DictionaryDropdown, other.DictionaryDropdown) &&
            ReportParameterOperationTime.isEqual(parameter.OperationTime, other.OperationTime) &&
            OperationTimeDiagramSettings.isEqual(parameter.OperationTimeDiagram, other.OperationTimeDiagram) &&
            ReportParameterRandomValue.isEqual(parameter.RandomValue, other.RandomValue) &&
            ReportParameterLog.isEqual(parameter.Log, other.Log) &&
            ReportSpecificDate.isEqual(parameter.SpecificDate, other.SpecificDate) &&
            NavigationSettings.isEqual(parameter.Navigation, other.Navigation) &&
            OpcSettings.isEqual(parameter.Opc, other.Opc) &&
            OdbcSettings.isEqual(parameter.Odbc, other.Odbc) &&
            _.every(parameter.Backlight, function (p, index) {
                return ReportParameterBacklight.isEqual(p, other.Backlight[index]);
            }) &&
            ReportParameterWincc.isEqual(parameter.Wincc, other.Wincc) &&
            ReportLinkSettings.isEqual(parameter.Report, other.Report) &&
            SignSettings.isEqual(parameter.Sign, other.Sign) &&
            WinccOaSettings.isEqual(parameter.WinccOa, other.WinccOa) &&
            HttpSettings.isEqual(parameter.Http, other.Http) &&
            OleDbSettings.isEqual(parameter.OleDb, other.OleDb) &&
            WinccOaInfluxSettings.isEqual(parameter.WinccOaInflux, other.WinccOaInflux) &&
            PostgreSqlSettings.isEqual(parameter.PostgreSql, other.PostgreSql) &&
            FileSettings.isEqual(parameter.File, other.File) &&
            UserFileSettings.isEqual(parameter.ClientFile, other.ClientFile));
    };
    return ReportParameter;
}());
var SafeReportParameter = (function (_super) {
    __extends(SafeReportParameter, _super);
    function SafeReportParameter() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return SafeReportParameter;
}(ReportParameter));
var ReportParameterDictionary = (function () {
    function ReportParameterDictionary() {
        this.Func = 'dictionaryClassInstanceAttributeValue';
        this.UniqueCodes = JSON.stringify([]);
        this.Filter = JSON.stringify([]);
    }
    ReportParameterDictionary.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new ReportParameterDictionary();
        clone.Func = obj.Func;
        clone.UniqueCodes = obj.UniqueCodes;
        clone.Filter = obj.Filter;
        return clone;
    };
    ReportParameterDictionary.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return obj.Func === other.Func && obj.UniqueCodes === other.UniqueCodes && obj.Filter === other.Filter;
    };
    ReportParameterDictionary.prototype.canEdited = function () {
        return false;
    };
    ReportParameterDictionary.prototype.canPlanned = function () {
        return true;
    };
    ReportParameterDictionary.prototype.canBacklight = function () {
        return false;
    };
    ReportParameterDictionary.prototype.canPredefined = function () {
        return false;
    };
    return ReportParameterDictionary;
}());
var ReportParameterOperationTime = (function () {
    function ReportParameterOperationTime() {
        this.Func = 'durationForPeriod';
    }
    ReportParameterOperationTime.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new ReportParameterOperationTime();
        clone.Func = obj.Func;
        clone.DeviceName = obj.DeviceName;
        clone.ParameterName = obj.ParameterName;
        clone.StateName = obj.StateName;
        clone.StartDate = obj.StartDate;
        clone.EndDate = obj.EndDate;
        return clone;
    };
    ReportParameterOperationTime.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.Func === other.Func &&
            obj.DeviceName === other.DeviceName &&
            obj.ParameterName === other.ParameterName &&
            obj.StateName === other.StateName &&
            obj.StartDate === other.StartDate &&
            obj.EndDate === other.EndDate);
    };
    ReportParameterOperationTime.prototype.canEdited = function () {
        return false;
    };
    ReportParameterOperationTime.prototype.canPlanned = function () {
        return true;
    };
    ReportParameterOperationTime.prototype.canBacklight = function () {
        return false;
    };
    ReportParameterOperationTime.prototype.canPredefined = function () {
        return false;
    };
    return ReportParameterOperationTime;
}());
var ReportParameterRandomValue = (function () {
    function ReportParameterRandomValue() {
        this.MinValue = 0;
        this.MaxValue = 100;
    }
    ReportParameterRandomValue.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new ReportParameterRandomValue();
        clone.MinValue = obj.MinValue;
        clone.MaxValue = obj.MaxValue;
        return clone;
    };
    ReportParameterRandomValue.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return obj.MinValue === other.MinValue && obj.MaxValue === other.MaxValue;
    };
    ReportParameterRandomValue.prototype.canEdited = function () {
        return true;
    };
    ReportParameterRandomValue.prototype.canPlanned = function () {
        return true;
    };
    ReportParameterRandomValue.prototype.canBacklight = function () {
        return true;
    };
    ReportParameterRandomValue.prototype.canPredefined = function () {
        return true;
    };
    return ReportParameterRandomValue;
}());
var ReportParameterExcel = (function () {
    function ReportParameterExcel() {
        this.Func = 'table';
    }
    ReportParameterExcel.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new ReportParameterExcel();
        clone.ConnectionGuid = obj.ConnectionGuid;
        clone.Func = obj.Func;
        clone.FilePath = obj.FilePath;
        clone.SheetName = obj.SheetName;
        clone.FieldA = obj.FieldA;
        clone.FieldB = obj.FieldB;
        return clone;
    };
    ReportParameterExcel.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.Func === other.Func &&
            obj.FilePath === other.FilePath &&
            obj.SheetName === other.SheetName &&
            obj.FieldA === other.FieldA &&
            obj.FieldB === other.FieldB &&
            obj.ConnectionGuid === other.ConnectionGuid);
    };
    return ReportParameterExcel;
}());
var ReportParameterLog = (function () {
    function ReportParameterLog() {
    }
    ReportParameterLog.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new ReportParameterLog();
        clone.fields = _.isUndefined(obj.fields)
            ? obj.fields
            : _.map(obj.fields, function (field) {
                return ({
                    caption: field.caption,
                    defaultValue: field.defaultValue,
                    width: field.width,
                    isRequired: field.isRequired,
                    isKey: field.isKey,
                    type: field.type,
                    additionalSettings: _.isUndefined(field.additionalSettings)
                        ? field.additionalSettings
                        : _.map(field.additionalSettings, function (s) { return s; }),
                });
            });
        clone.widthDimension = obj.widthDimension;
        clone.initialParameter = obj.initialParameter;
        return clone;
    };
    ReportParameterLog.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        if (_.isUndefined(obj.fields) || _.isUndefined(other.fields)) {
            if (obj.fields !== other.fields) {
                return false;
            }
        }
        else {
            if (obj.fields.length !== other.fields.length)
                return false;
            for (var i = 0; i < obj.fields.length; i++) {
                if (obj.fields[i].caption !== other.fields[i].caption ||
                    obj.fields[i].type !== other.fields[i].type ||
                    obj.fields[i].isRequired !== other.fields[i].isRequired ||
                    obj.fields[i].isKey !== other.fields[i].isKey ||
                    !_.isEqual(obj.fields[i].defaultValue, other.fields[i].defaultValue) ||
                    !_.isEqual(obj.fields[i].additionalSettings, other.fields[i].additionalSettings) ||
                    obj.fields[i].width !== other.fields[i].width) {
                    return false;
                }
            }
        }
        return obj.widthDimension === other.widthDimension && obj.initialParameter === other.initialParameter;
    };
    ReportParameterLog.prototype.canEdited = function () {
        return false;
    };
    ReportParameterLog.prototype.canPlanned = function () {
        return true;
    };
    ReportParameterLog.prototype.canBacklight = function () {
        return false;
    };
    ReportParameterLog.prototype.canPredefined = function () {
        return false;
    };
    return ReportParameterLog;
}());
var ReportSpecificDate = (function () {
    function ReportSpecificDate() {
    }
    ReportSpecificDate.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new ReportSpecificDate();
        clone.parameter = obj.parameter;
        clone.format = obj.format;
        clone.monthOffset = obj.monthOffset;
        clone.dayOffset = obj.dayOffset;
        clone.hourOffset = obj.hourOffset;
        clone.minuteOffset = obj.minuteOffset;
        clone.secondsOffset = obj.secondsOffset;
        clone.manualDate = obj.manualDate;
        return clone;
    };
    ReportSpecificDate.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.parameter === other.parameter &&
            obj.format === other.format &&
            obj.monthOffset === other.monthOffset &&
            obj.dayOffset === other.dayOffset &&
            obj.hourOffset === other.hourOffset &&
            obj.minuteOffset === other.minuteOffset &&
            obj.secondsOffset === other.secondsOffset &&
            obj.manualDate === other.manualDate);
    };
    ReportSpecificDate.prototype.canEdited = function () {
        return false;
    };
    ReportSpecificDate.prototype.canPlanned = function () {
        return true;
    };
    ReportSpecificDate.prototype.canBacklight = function () {
        return true;
    };
    ReportSpecificDate.prototype.canPredefined = function () {
        return true;
    };
    return ReportSpecificDate;
}());
var NavigationSettings = (function () {
    function NavigationSettings(title) {
        this.reportStart = '';
        this.reportEnd = '';
        this.templateUniqueGuid = '';
        this.url = '';
        this.reportParameterValues = [];
        this.func = 'url',
            this.link = {
                type: 0,
                linkOpenInNewWindow: false,
                linkOpenSavedReport: true,
                title: title,
            };
    }
    NavigationSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.func === other.func &&
            obj.reportStart === other.reportStart &&
            obj.reportEnd === other.reportEnd &&
            obj.templateUniqueGuid === other.templateUniqueGuid &&
            obj.url == other.url &&
            obj.link.type === other.link.type &&
            obj.link.linkOpenInNewWindow === other.link.linkOpenInNewWindow &&
            obj.link.linkOpenSavedReport === other.link.linkOpenSavedReport &&
            obj.link.title === other.link.title &&
            obj.reportParameterValues.length === other.reportParameterValues.length &&
            _.all(obj.reportParameterValues, function (predefinedValue) {
                var _a, _b;
                var parameter = _.find(other.reportParameterValues, function (otherPredefinedValue) { return otherPredefinedValue.parameterIdent === predefinedValue.parameterIdent; });
                return _.isDefined(parameter) &&
                    ((_a = parameter.value) === null || _a === void 0 ? void 0 : _a.value) === ((_b = predefinedValue.value) === null || _b === void 0 ? void 0 : _b.value) &&
                    parameter.valueType === predefinedValue.valueType;
            }));
    };
    NavigationSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new NavigationSettings(obj.link.title);
        clone.reportStart = obj.reportStart;
        clone.reportEnd = obj.reportEnd;
        clone.templateUniqueGuid = obj.templateUniqueGuid;
        clone.func = obj.func;
        clone.url = obj.url;
        clone.link.type = obj.link.type;
        clone.link.linkOpenInNewWindow = obj.link.linkOpenInNewWindow;
        clone.link.linkOpenSavedReport = obj.link.linkOpenSavedReport;
        clone.link.title = obj.link.title;
        clone.reportParameterValues = _.map(obj.reportParameterValues, function (predefinedValue) {
            var parameterValue = _.find(obj.reportParameterValues, function (otherPredefinedValue) {
                return otherPredefinedValue.parameterIdent === predefinedValue.parameterIdent;
            });
            return {
                parameterIdent: parameterValue.parameterIdent,
                value: parameterValue.value,
                valueType: parameterValue.valueType,
            };
        });
        return clone;
    };
    NavigationSettings.prototype.canPlanned = function () {
        return true;
    };
    NavigationSettings.prototype.canBacklight = function () {
        return false;
    };
    NavigationSettings.prototype.canEdited = function () {
        return false;
    };
    NavigationSettings.prototype.canPredefined = function () {
        return false;
    };
    return NavigationSettings;
}());
