var VerifySwitchoverFormConditionModalCtrl = (function () {
    function VerifySwitchoverFormConditionModalCtrl(scope, modal, timeout, notificationService, language, delayBetweenSteps, switchoverFormProviderService, formSerialNumber, formName, conditions, alarms) {
        this.scope = scope;
        this.modal = modal;
        this.timeout = timeout;
        this.notificationService = notificationService;
        this.language = language;
        this.delayBetweenSteps = delayBetweenSteps;
        this.switchoverFormProviderService = switchoverFormProviderService;
        this.formSerialNumber = formSerialNumber;
        this.formName = formName;
        this.conditions = conditions;
        this.alarms = alarms;
        this.isProcessed = true;
        this.currentConditionIndex = 0;
        this.automaticConditions = [];
        this.scope.ctrl = this;
        this.conditions = conditions;
        this.alarms = alarms;
        this.delayBetweenSteps = delayBetweenSteps;
        this.automaticConditions = _.map(_.filter(this.conditions, function (condition) { return condition.type === 1; }), function (condition) { return condition; });
        this.processStep();
    }
    VerifySwitchoverFormConditionModalCtrl.prototype.processStep = function () {
        var _this = this;
        if (!this.isProcessed) {
            return;
        }
        if (this.currentConditionIndex > this.automaticConditions.length - 1) {
            this.modal.close(this.conditions);
            return;
        }
        var condition = this.automaticConditions[this.currentConditionIndex];
        condition.isProcessed = true;
        this.switchoverFormProviderService
            .verifyAutomaticCondition(this.formName, this.formSerialNumber, condition, this.alarms, condition.uiOrderNumber)
            .then(function (verifivationResullt) {
            condition.isProcessed = false;
            condition.status = verifivationResullt.status;
            condition.executionDate = verifivationResullt.verificationDate;
            condition.remoteControlKeyPosition = verifivationResullt.remoteControlKeyPosition;
            _this.timeout(function () {
                if (condition.status === 2) {
                    _this.currentConditionIndex++;
                    _this.processStep();
                }
                else {
                    _this.isProcessed = false;
                    _this.notificationService.warnMessage(String.Format(_this.language.getElementValue('switchoverFormsConditionVerificationInterruptedMsg'), verifivationResullt.failedCommand.name, verifivationResullt.errorMessage), undefined, NotificationBodyOutputType.TrustedHtml, 0);
                }
            }, _this.delayBetweenSteps);
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsCreatedErrorMsg'), error);
        });
    };
    VerifySwitchoverFormConditionModalCtrl.prototype.getStatusMessage = function (condition) {
        switch (condition.status) {
            case 2:
                return this.language.getElementValue('switchoverFormsCompletedAutomaticallyStatusMsg');
            case 3:
                return this.language.getElementValue('switchoverFormsFailedStatusMsg');
            default:
                return '';
        }
    };
    VerifySwitchoverFormConditionModalCtrl.prototype.ok = function () {
        this.modal.close();
    };
    VerifySwitchoverFormConditionModalCtrl.prototype.close = function () {
        this.isProcessed = false;
        this.modal.dismiss();
    };
    VerifySwitchoverFormConditionModalCtrl.$inject = [
        '$scope',
        '$modalInstance',
        '$timeout',
        'notificationService',
        'language',
        'delayBetweenSteps',
        'switchoverFormProvider',
        'formSerialNumber',
        'formName',
        'conditions',
        'alarms',
    ];
    return VerifySwitchoverFormConditionModalCtrl;
}());
angular.module('kamhpp').controller('verifySwitchoverFormConditionModalCtrl', VerifySwitchoverFormConditionModalCtrl);
