var ExcelSettings = (function () {
    function ExcelSettings() {
        this.func = 'table';
    }
    ExcelSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.connectionGuid === other.connectionGuid &&
            obj.sheetName === other.sheetName &&
            obj.fieldA === other.fieldA &&
            obj.func === other.func &&
            obj.fieldB === other.fieldB);
    };
    ExcelSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new ExcelSettings();
        clone.connectionGuid = obj.connectionGuid;
        clone.sheetName = obj.sheetName;
        clone.func = obj.func;
        clone.fieldA = obj.fieldA;
        clone.fieldB = obj.fieldB;
        return clone;
    };
    ExcelSettings.prototype.canEdited = function () {
        return this.func !== 'table';
    };
    ExcelSettings.prototype.canPlanned = function () {
        return true;
    };
    ExcelSettings.prototype.canBacklight = function () {
        return !_.contains(['table', 'doubleArray', 'stringOneDimArray'], this.func);
    };
    ExcelSettings.prototype.canPredefined = function () {
        return false;
    };
    return ExcelSettings;
}());
