var BaseTrigger = (function () {
    function BaseTrigger(source) {
        if (source === void 0) { source = null; }
        if (source) {
            this.completionType = source.completionType;
            this.state = source.state;
            this.duration = source.duration;
            this.startTime = source.startTime;
            this.lastTriggeredTime = source.lastTriggeredTime;
            this.lastCheckTime = source.lastCheckTime;
        }
        else {
            this.completionType = 0;
            this.state = 0;
            this.duration = null;
            this.startTime = new Date().getBeginDay();
            this.lastTriggeredTime = null;
            this.lastCheckTime = null;
        }
    }
    BaseTrigger.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.completionType === other.completionType &&
            obj.state === other.state &&
            obj.duration === other.duration &&
            Date.equals(obj.startTime, other.startTime) &&
            Date.equals(obj.lastTriggeredTime, other.lastTriggeredTime) &&
            Date.equals(obj.lastCheckTime, other.lastCheckTime));
    };
    return BaseTrigger;
}());
