var ReportTemplateEditorCtrl = (function () {
    function ReportTemplateEditorCtrl($rootScope, $scope, $upload, $http, $modal, $q, $timeout, $location, clientSettings, notificationService, language, authentication, reportTemplateProviderService, userProvider, mailValidationService, mailProvider, userPreferencesService, templateParameterService, exportService, reportTemplateService, configuration, printProvider) {
        var _this = this;
        this.$rootScope = $rootScope;
        this.$scope = $scope;
        this.$upload = $upload;
        this.$http = $http;
        this.$modal = $modal;
        this.$q = $q;
        this.$timeout = $timeout;
        this.$location = $location;
        this.clientSettings = clientSettings;
        this.notificationService = notificationService;
        this.language = language;
        this.authentication = authentication;
        this.reportTemplateProviderService = reportTemplateProviderService;
        this.userProvider = userProvider;
        this.mailValidationService = mailValidationService;
        this.mailProvider = mailProvider;
        this.userPreferencesService = userPreferencesService;
        this.templateParameterService = templateParameterService;
        this.exportService = exportService;
        this.reportTemplateService = reportTemplateService;
        this.configuration = configuration;
        this.printProvider = printProvider;
        this.containerForImportReportTemplate = { data: {} };
        this.tabs = [
            { name: this.language.getElementValue('markingHdr'), ctrl: undefined, isSelected: true },
            { name: this.language.getElementValue('parametersHdr'), ctrl: undefined, isSelected: false },
            { name: this.language.getElementValue('reportRulesSettingsHdr'), ctrl: undefined, isSelected: false },
            { name: this.language.getElementValue('reportSettingTemplateHdr'), ctrl: undefined, isSelected: false },
        ];
        this.isMailEnabled = false;
        this.isParametersSidebarOpened = true;
        this.onTemplateEditorChanged = function () {
            _this.template.isChanged = true;
        };
        this.getCheckResult = function () {
            var result = true;
            var message = new NotificationMessage(_this.language.getElementValue('reportErrorNotFoundMsg'));
            var deffered = _this.$q.defer();
            _this.$http
                .post(_this.clientSettings.getServerInstance() + '/ReportTemplate/Check', {
                reportTemplate: _this.template,
            })
                .then(function (response) {
                if (response.data !== '') {
                    result = false;
                    message = new NotificationMessage(_this.language.getElementValue('reportErrorCalculationMsg'), [
                        response.data,
                    ]);
                }
                deffered.resolve({ result: result, notification: message });
            }, function (data) {
                deffered.reject(data);
            });
            return deffered.promise;
        };
        this.checkTemplate = function (showSuccessToast) {
            var checkResults = _.map(_this.afterGenerationCtrl.getErrorMessages(), function (message) { return new CheckResult(false, message); });
            _this.getCheckResult()
                .then(function (data) {
                checkResults.push(data);
            })
                .then(function () {
                _.each(checkResults, function (checkResult) {
                    if (!checkResult.result) {
                        _this.notificationService.warnMessage(checkResult.notification.message, checkResult.notification.details);
                    }
                });
                if (showSuccessToast &&
                    _.every(checkResults, function (checkResult) {
                        return checkResult.result;
                    })) {
                    _this.notificationService.showMessage(_this.language.getElementValue('reportErrorNotFoundMsg'));
                }
            })
                .catch(function (error) {
                _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
            });
        };
        this.exportReportTemplate = function () {
            var url = '/ReportTemplate/ExportReportTemplate?templateId=' + _this.template.Id;
            _this.exportService.export(url);
        };
        this.importReportTemplate = function (file) {
            _this.$upload
                .upload({
                url: _this.clientSettings.getServerInstance() + '/ReportTemplate/ImportReportTemplate',
                file: file,
            })
                .then(function (response) {
                var newVersionReportTemplate = new ReportTemplate(_this.parentScope, response.data, _this.notificationService, _this.language, _this.$http, _this.clientSettings, _this.reportTemplateProviderService, _this.$modal, _this.mailValidationService, _this.mailProvider, _this.userPreferencesService, _this.printProvider);
                _this.template = newVersionReportTemplate;
                _this.markupCtrl.setSelectedTemplate(_this.template);
                _this.primarySettingsCtrl.setSelectedTemplate(_this.template);
                _this.parametersCtrl.setSelectedTemplate(_this.template);
                _this.afterGenerationCtrl.setSelectedTemplate(_this.template);
                _this.notificationService.showMessage(_this.language.getElementValue('reportSuccessTemplateImportMsg'));
                _this.isReportVisible = _this.reportTemplateService.isReportTemplateVisible(new ReportTemplateInfo(_this.template));
            }, function (data) {
                _this.notificationService.errorMessage(_this.language.getElementValue('reportErrorTemplateImportMsg'), data);
            });
        };
        this.save = function (template) {
            _this.checkTemplate(false);
            template.HtmlTemplate = _this.markupCtrl.getHtml();
            _this.$http
                .post(_this.clientSettings.getServerInstance() + '/ReportTemplate/SaveReportTemplate', {
                reportTemplate: template,
            })
                .then(function (response) {
                template.isChanged = false;
                _this.notificationService.showMessage(_this.language.getElementValue('changesSuccessSaveMsg'));
                _this.template.Version = response.data.Version;
                _this.template.Id = response.data.Id;
                _this.onSaveConfirmed({ template: response.data });
                _this.isReportVisible = _this.reportTemplateService.isReportTemplateVisible(new ReportTemplateInfo(_this.template));
            }, function (data) {
                _this.notificationService.errorMessage(_this.language.getElementValue('failedSaveChangesMsg'), data);
            });
        };
        this.openReport = function () {
            _this.$location.url('reports').search({ templateGuid: _this.template.UniqueGuid });
        };
        this.isReportPeriodic = function () {
            return _this.template.ReportType === 1;
        };
        this.selectTemplate = function (after) {
            _this.parametersCtrl.setSelectedTemplate(after);
            _this.afterGenerationCtrl.setSelectedTemplate(after);
            _this.primarySettingsCtrl.setSelectedTemplate(after);
            _this.markupCtrl.setSelectedTemplate(after);
            if (_.all(_this.tabs, function (tab) {
                return !tab.isSelected;
            })) {
                _this.tabs[0].isSelected = true;
            }
            _this.isReportVisible = _this.reportTemplateService.isReportTemplateVisible(new ReportTemplateInfo(_this.template));
        };
        this.mailProvider.isMailEnabled().then(function (isEnable) {
            _this.isMailEnabled = isEnable;
        });
        this.$scope.$watch(function () {
            return _this.containerForImportReportTemplate.data;
        }, function (data) {
            if (_.isUndefined(data) || !_.any(data))
                return;
            _this.importReportTemplate(data);
        });
    }
    ReportTemplateEditorCtrl.prototype.$onInit = function () {
        this.editorCtrlApi = { onNeedSave: this.save };
        this.primarySettingsCtrl = new TemplatePrimarySettingsCtrl(this.$scope, this.language);
        this.markupCtrl = new ReportTemplateMarkupCtrl(this.language, this.$timeout, this.templateParameterService, this.configuration);
        this.parametersCtrl = new TemplateParametersCtrl(this.$timeout, this.language, this.markupCtrl, this.userPreferencesService, this.templateParameterService);
        this.afterGenerationCtrl = new ReportScheduleRulesSettingsCtrl(this.$timeout, this.parentScope, this.language, this.template, this.reportTemplateProviderService, this.notificationService, this.$modal, this.mailValidationService, this.mailProvider, this.userPreferencesService, this.printProvider);
    };
    ReportTemplateEditorCtrl.prototype.$onChanges = function (onChangesObj) {
        var template = onChangesObj['template'];
        if (_.isDefined(template === null || template === void 0 ? void 0 : template.currentValue) && !_.isEqual(template.currentValue, template.previousValue)) {
            this.selectTemplate(template.currentValue);
        }
    };
    ReportTemplateEditorCtrl.prototype.setActiveTab = function (after) {
        _.each(this.tabs, function (t, i) {
            t.isSelected = i === after;
        });
        this.isParametersSidebarOpened = after == 0;
    };
    ReportTemplateEditorCtrl.$inject = [
        '$rootScope',
        '$scope',
        '$upload',
        '$http',
        '$modal',
        '$q',
        '$timeout',
        '$location',
        'clientSettings',
        'notificationService',
        'language',
        'authentication',
        'reportTemplateProvider',
        'userProvider',
        'mailValidationService',
        'mailProvider',
        'userPreferencesService',
        'templateParameterService',
        'exportService',
        'reportTemplateService',
        'smsTemplateEditorConfiguration',
        'printProvider',
    ];
    return ReportTemplateEditorCtrl;
}());
