var ReportFileValue = (function () {
    function ReportFileValue(Name, Type, Data) {
        this.Name = Name;
        this.Type = Type;
        this.Data = Data;
    }
    return ReportFileValue;
}());
var PredefinedUserFileValueComponent = (function () {
    function PredefinedUserFileValueComponent() {
        this.bindings = {
            value: '<',
            fileExtension: '<',
            onChanged: '&',
            isDisabled: '<?'
        };
        this.templateUrl = 'ng1/dist/src/UserDocuments/PredefinedParameters/UserFileValue/PredefinedUserFileValue.html';
        this.controller = PredefinedUserFileValueComponentController;
    }
    return PredefinedUserFileValueComponent;
}());
var PredefinedUserFileValueComponentController = (function () {
    function PredefinedUserFileValueComponentController($timeout, notificationService, language) {
        this.$timeout = $timeout;
        this.notificationService = notificationService;
        this.language = language;
        this.files = [];
    }
    PredefinedUserFileValueComponentController.prototype.uploadUserFile = function ($files) {
        var _this = this;
        if ($files && $files[0]) {
            var reader_1 = new FileReader();
            reader_1.readAsDataURL($files[0]);
            var self_1 = this;
            reader_1.onload = function () {
                self_1.$timeout(function () {
                    var data = reader_1.result.toString().split(',')[1];
                    var name = $files[0].name;
                    self_1.value.value.value = new ReportFileValue(name, name.split('.').pop(), data);
                    _this.onChanged({ change: _this.value });
                });
            };
            reader_1.onerror = function (error) {
                self_1.notificationService.errorMessage(self_1.language.getElementValue('reportUserFileUploadErrorMsg'), error);
            };
        }
    };
    PredefinedUserFileValueComponentController.$inject = [
        '$timeout',
        'notificationService',
        'language'
    ];
    return PredefinedUserFileValueComponentController;
}());
angular.module('kamhpp').component('predefinedUserFileParameter', new PredefinedUserFileValueComponent());
