app.directive('inputInteger', function () {
    return {
        require: 'ngModel',
        link: function (scope, element, attr, ngModelCtrl) {
            var fromUser = function (value) {
                var text = value.toString();
                if (!text || text === '-') {
                    return text;
                }
                var result = text.match(/-?\d+/g);
                var transformedInput = '0';
                if (!_.isNull(result)) {
                    transformedInput = result[0];
                }
                if (transformedInput !== text) {
                    ngModelCtrl.$setViewValue(transformedInput);
                    ngModelCtrl.$render();
                }
                return parseInt(transformedInput);
            };
            ngModelCtrl.$parsers.push(fromUser);
            element.bind('blur', function () {
                if (ngModelCtrl.$viewValue === '' || ngModelCtrl.$viewValue === '-') {
                    ngModelCtrl.$setViewValue('0');
                    ngModelCtrl.$render();
                }
            });
        },
    };
});
