[Ru](#технодок)
[En](#technodoc)

# ТехноДок

## Содержание
1. [Системные требования](#системные-требования)
2. [Установка](#установка)
3. [Запуск](#запуск)
4. [Авторизация](#авторизация)
5. [Обновление](#обновление)
6. [Удаление](#удаление)
7. [Дальнейшие шаги](#дальнейшие-шаги)

## Системные требования
### Сервер 
- Процессор: 64-разрядный с тактовой частотой 1 ГГц или выше.
- Свободное место на жестком диске: не менее 1ГБ.
- Оперативная память: не менее 2ГБ.
- Операционная система:
    - Windows:
        - Windows 10 и выше.
        - Windows Server 2012 (с расширенными обновлениями безопасности) и выше.
    - Linux:
        - Debian 12 и выше.
        - Ubuntu 20.04 и выше.
        - Fedora 39 и выше.
        - Производные от них.

### СУБД:
- SQLite 3 (используется по умолчанию). 
- PostgreSQL 11 и выше.
- Microsoft SQL Server 2017 и выше.
- MariaDB 10.3 и выше.

### Клиент
- Браузер на основе Chromium последней версии: Google Chrome, Microsoft Edge, Яндекс Браузер и т.д.
- Браузер Mozilla Firefox последней версии.

## Установка
Для установки необходимо выполнить следующие шаги:
1. Создать любую директорию, например, `Programs`.
2. Распаковать архив `ТехноДок` в созданную директорию.

#### Linux
```sh
# Создать директорию "Programs"
sudo mkdir /opt/Programs && sudo chown $USER: /opt/Programs

# Распаковать архив "ТехноДок" в созданную директорию
unzip -d "/opt/Programs/TechnoDoc" "[Путь до архива ТехноДок]"
```

#### Windows
```bat
rem Создать директорию "Programs"
mkdir "C:\Programs"

rem Распаковать архив "ТехноДок" в созданную директорию
tar -xf "[Путь до архива ТехноДок]" -C "C:\Programs\TechnoDoc"
```

## Запуск
### Запуск из терминала
Для запуска из терминала необходимо выполнить следующие шаги:
1. Перейти в директорию `scripts`.
2. Выполнить скрипт `run`.

#### Linux
```sh
# Перейти в директорию "scripts"
cd /opt/Programs/TechnoDoc/scripts

# Выполнить скрипт "run"
sh run.sh
```

#### Windows
```bat
rem Перейти в директорию "scripts"
cd "C:\Programs\TechnoDoc\scripts"

rem Выполнить скрипт "run"
start "TechnoDoc" "run.bat"
```

### Запуск в качестве сервиса
Для запуска в качестве сервиса необходимо выполнить следующие шаги:
1. Перейти в директорию `scripts/service`.
2. Выполнить скрипт `create`.
3. Выполнить скрипт `start`.

#### Linux
```sh
# Перейти в директорию "scripts/service"
cd /opt/Programs/TechnoDoc/scripts

# Выполнить скрипт "create"
sh create.sh

# Выполнить скрипт "start"
sh start.sh
```

> **Важно:**   
> Для создания и запуска сервиса требуется наличие прав суперпользователя.

#### Windows
```bat
rem Перейти в директорию "scripts/service"
cd "C:\Programs\TechnoDoc\scripts\service"

rem Выполнить скрипт "create"
create.bat

rem Выполнить скрипт "start"
start.bat
```

> **Важно:**   
> Для создания и запуска сервиса требуется наличие прав администратора.

> *Примечания*:
> - Для останова сервиса необходимо выполнить скрипт `stop`.
> - Для удаления сервиса необходимо выполнить скрипт `delete`.
> - Перед запуском `ТехноДок` в качестве сервиса необходимо остановить `ТехноДок`, запущенный из терминала.

## Авторизация
Для авторизации необходимо выполнить следующие шаги:
1. Открыть в браузере страницу `http://127.0.0.1:8003`.
2. Ввести лицензионный ключ и нажать кнопку `Активировать` в появившемся модальном окне `Активация лицензии`. 
3. Ввести логин/пароль - `admin/admin` и нажать кнопку "Войти".

> *Примечания*:
> - Демо-лицензию можно получить, нажав на кнопку `Запросить демо-лицензию`.
> - Долгосрочную лицензию можно запросить по адресу `technodoc@sms-a.ru`.

## Обновление
Для обновления необходимо выполнить следующие шаги:
1. Остановить сервер текущей версии `ТехноДок`.
2. Распаковать новую версию `ТехноДок` в директорию отличную от той, в которой установлена и запущена текущая версия `ТехноДок`.
3. Скопировать следующие файлы из директории, в которой установлена текущая версия `ТехноДок`, в директорию куда была распакована новая версия `ТехноДок` с опцией замены файлов:
    - `technodoc.conf`
    - `data/technodoc.license`
    - `data/databases` (если в качестве БД используется SQLite)
4. Перейти в директорию `scripts`.
5. Выполнить скрипт `run-migrator`.
6. Запустить сервер `ТехноДок`.

> **Важно:**
> - Перед обновлением рекомендуется создать резервную копию директории, в которой установлен и запущен `ТехноДок`.
> - Перед обновлением, в случае интеграции с внешней СУБД, рекомендуется сделать резервную копию БД `technodoc`.
> - Совместимость между мажорными версиями не гарантируется.
> - В случае интеграции с внешними SCADA системами (КАСКАД, АСОКУ, Alpha) необходимо заменить файлы `ТехноДок` в проекте SCADA на новые версии файлов из директории `components`.

## Удаление
Для удаления необходимо выполнить следующие шаги:
1. Остановить сервер `ТехноДок`.
2. Удалить директорию, в которую был распакован архив `ТехноДок`.

*Примечания*:
- Если `ТехноДок` был запущен в качестве сервиса, то необходимо удалить сервис при помощи скрипта `delete`.
- Если `ТехноДок` был интегрирован с внешними СУБД, то необходимо вручную удалить БД `technodoc`.

## Дальнейшие шаги
Более подробную информацию о `ТехноДок` можно найти в [документации](https://sms-technodoc.ru/docs/), например:
- [Интеграция с внешними СУБД](https://sms-technodoc.ru/en/docs/#интеграция-с-субд)
- [Интеграция с SCADA](https://sms-technodoc.ru/en/docs/#интеграция-с-scada)
- [Конфигурация обмена данными по протоколу HTTPS](https://sms-technodoc.ru/docs/settings/system-settings#настройка-https)

# TechnoDoc

## Contents
1. [System Requirements](#system-requirements)
2. [Installation](#installation)
3. [Run](#run)
4. [Login](#login)
5. [Update](#update)
6. [Uninstallation](#uninstallation)
7. [Next Steps](#next-steps)

## System Requirements
### Server 
- Processor: 64-bit with a clock speed of 1 GHz or higher.
- Free disk space: at least 1 GB.
- RAM: at least 2 GB.
- Operating System:
  - Windows:
    - Windows 10 and above.
    - Windows Server 2012 (with extended security updates) and above.
  - Linux:
    - Debian 12 and above.
    - Ubuntu 20.04 and above.
    - Fedora 39 and above.
    - Derivatives of these.

#### Databases
- SQLite (used by default).
- PostgreSQL 11 and above.
- Microsoft SQL Server 2017 and above.
- MariaDB 10.3 and above.

### Client
- Browser based on Chromium of the latest version: Google Chrome, Microsoft Edge, Yandex Browser, etc.
- Browser Mozilla Firefox of the latest version.

## Installation
To install, follow these steps:
1. Create a directory, for example, `Programs`.
2. Unpack `TechnoDoc` archive into the created directory.

#### Linux
```sh
# Create "Programs" directory
sudo mkdir /opt/Programs && sudo chown $USER: /opt/Programs

# Unpack "TechnoDoc" archive into the created directory
unzip -d "/opt/Programs/TechnoDoc" "[Path to TechnoDoc archive]"
```

#### Windows
```bat
rem Create "Programs" directory
mkdir "C:\Programs"

rem Unpack "TechnoDoc" archive into the created directory
tar -xf "[Path to TechnoDoc archive]" -C "C:\Programs\TechnoDoc"
```

## Run
### Run from terminal
To run from terminal, follow these steps:
1. Open `scripts` directory.
2. Run the `run` script.

#### Linux
```sh
# Open "scripts" directory
cd /opt/Programs/TechnoDoc/scripts

# Run the "run" script
sh run.sh
```

#### Windows
```bat
rem Open "scripts" directory
cd "C:\Programs\TechnoDoc\scripts"

rem Run the "run" script
start "TechnoDoc" "run.bat"
```

### Run as service
To run as a service, follow these steps:
1. Open `scripts/service` directory.
2. Run the `create` script.
3. Run the `start` script.

#### Linux
```sh
# Open "scripts/service" directory
cd /opt/Programs/TechnoDoc/scripts

# Run the "create" script
sh create.sh

# Run the "start" script
sh start.sh
```

> **Important:**    
To create and run the service, you must have superuser rights.

#### Windows
```bat
rem Open "scripts/service" directory
cd "C:\Programs\TechnoDoc\scripts\service"

rem Run the "create" script
create.bat

rem Run the "start" script
start.bat
```

> **Important:**    
To create and run the service, you must have administrator rights.

> *Notes*:
> - To stop the service, you should run the `stop` script.
> - To delete the service, you should run the `delete` script.
> - You must stop `TechnoDoc` running from the terminal before running `TechnoDoc` as a service.

## Login
1. Open a browser and navigate to `http://127.0.0.1:8003`.
2. Enter the license key and click `Activate` button in the `License Activation` modal window.
3. Enter login/password - `admin/admin` and click `Sign In` button.

> *Notes*:
> - Demo license can be obtained by clicking on the `Request demo license` button.
> - A long-term license can be requested at `technodoc@sms-a.ru`.

## Update
To update, follow these steps:
1. Stop current version of `TechnoDoc` server.
2. Unpack new version of `TechnoDoc` into a directory different from the one in which the current version of `TechnoDoc` is installed and running.
3. Copy the following files from the directory in which the current version of `TechnoDoc` is installed to the directory where the new version of `TechnoDoc` was unpacked with the option to replace files:
    - `technodoc.conf`
    - `data/technodoc.license`
    - `data/databases/` (if SQLite is used as a database)
4. Open `scripts` directory.
5. Run the `run-migrator` script.
6. Start the `TechnoDoc` server.

> **Important:**
> - It is recommended to create a backup of the `TechnoDoc` directory before updating.
> - It is recommended to create a backup of the `technodoc` database in case of integration with an external DBMS, before updating.
> - It is necessary to replace the `TechnoDoc` files in the SCADA project with new versions of the files from the `components` directory in case of integration with external SCADA systems.

## Uninstallation
To uninstall, follow these steps:
1. Stop the `TechnoDoc` server.
2. Delete the directory where the `TechnoDoc` archive was unpacked.

*Notes*:
- If `TechnoDoc` was launched as a service, you must delete the service using the `delete` script.
- If `TechnoDoc` was integrated with external database, you must manually delete the `technodoc` database.

## Next steps
More detailed information about `TechnoDoc` can be found in the [documentation](https://sms-technodoc.ru/en/docs/), for example:
- [Integration with databases](https://sms-technodoc.ru/en/docs/#интеграция-с-субд)
- [Integration with SCADA](https://sms-technodoc.ru/en/docs/#интеграция-с-scada)
- [Configuration of data exchange via HTTPS](https://sms-technodoc.ru/docs/settings/system-settings#настройка-https)