var SysLogsDiagnosticCtrl = (function () {
    function SysLogsDiagnosticCtrl(systemLogProvider, routeParams, $modal, language, normalizeLineBreakFilter, notificationService) {
        var _this = this;
        var _a;
        this.systemLogProvider = systemLogProvider;
        this.routeParams = routeParams;
        this.$modal = $modal;
        this.language = language;
        this.normalizeLineBreakFilter = normalizeLineBreakFilter;
        this.notificationService = notificationService;
        this.systemLogs = [];
        this.systemTags = [];
        this.dateFormat = Date.masks.fullDateTime;
        this.filterFunction = function (log) {
            if (_this.selectedSystemTag &&
                log.tags.includes(_this.selectedSystemTag.ident) &&
                (!_this.descriptionSearchText ||
                    log.description.toLowerCase().includes(_this.descriptionSearchText.toLowerCase()) ||
                    log.user.toLowerCase().includes(_this.descriptionSearchText.toLowerCase()))) {
                return log;
            }
        };
        var now = new Date();
        var beginDay = this.routeParams.start
            ? Date.fromStringDate(this.routeParams.start)
            : now.getBeginDay();
        var endDate = this.routeParams.stop
            ? Date.fromStringDate(this.routeParams.stop).addMinutes(1)
            : now.addDays(1);
        this.systemLogsInterval = new TimeInterval(beginDay, endDate);
        this.descriptionSearchText = (_a = this.routeParams.search) !== null && _a !== void 0 ? _a : '';
        this.loadSystemLogTags();
        this.loadSystemLogs();
    }
    SysLogsDiagnosticCtrl.prototype.loadSystemLogs = function () {
        var _this = this;
        this.systemLogProvider.getSystemLogs(this.systemLogsInterval.start, this.systemLogsInterval.stop).then(function (logs) {
            _.forEach(logs, function (log) {
                log.description = _this.normalizeLineBreakFilter(log.description);
            });
            _this.systemLogs = logs;
            _this.onRefresh();
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    SysLogsDiagnosticCtrl.prototype.openChangesModal = function (logId) {
        var _this = this;
        this.$modal.open({
            templateUrl: 'ng1/dist/src/Administration/Diagnostic/SysLogs/ChangesModal/SysLogsChangesModal.html',
            controller: 'sysLogsChangesModalCtrl',
            windowClass: 'app-modal-window modal-width-100',
            backdrop: 'static',
            resolve: {
                logChanges: function () { return _this.systemLogProvider.getSystemLogChanges(logId); }
            }
        }).result.then(function () { }, function () { });
    };
    SysLogsDiagnosticCtrl.prototype.loadSystemLogTags = function () {
        var _this = this;
        this.systemLogProvider.getSystemLogTagInfo().then(function (tags) {
            _this.systemTags = _.map(tags, function (tag) {
                return {
                    ident: tag,
                    name: _this.getTagName(tag)
                };
            });
            _this.selectedSystemTag = !_.isUndefined(_this.routeParams.tag)
                ? _.find(_this.systemTags, function (tag) { return tag.ident === _this.routeParams.tag; })
                : _.find(_this.systemTags, function (tag) { return tag.ident === 0; });
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    SysLogsDiagnosticCtrl.prototype.hasErrorTag = function (log) {
        return _.any(log.tags, function (tag) { return tag === 8; });
    };
    SysLogsDiagnosticCtrl.prototype.getTagName = function (tag) {
        switch (tag) {
            case 0:
                return this.language.getElementValue('allSystemLogNameHdr');
            case 1:
                return this.language.getElementValue('userSystemLogNameHdr');
            case 2:
                return this.language.getElementValue('reportTemplateSystemLogNameHdr');
            case 3:
                return this.language.getElementValue('reportSystemLogNameHdr');
            case 4:
                return this.language.getElementValue('mailSystemLogNameHdr');
            case 6:
                return this.language.getElementValue('periodicTaskSystemLogNameHdr');
            case 8:
                return this.language.getElementValue('errorSystemLogNameHdr');
            case 9:
                return this.language.getElementValue('changeReportSystemLogNameHdr');
            case 10:
                return this.language.getElementValue('signedReportSystemLogNameHdr');
            case 11:
                return this.language.getElementValue('unsignedReportSystemLogNameHdr');
            case 12:
                return this.language.getElementValue('externalConnectionSystemLogNameHdr');
            case 13:
                return this.language.getElementValue('operationTimeSystemLogNameHdr');
            case 14:
                return this.language.getElementValue('switchoverFormsSystemLogNameHdr');
        }
    };
    SysLogsDiagnosticCtrl.$inject = [
        'systemLogProvider',
        '$routeParams',
        '$modal',
        'language',
        'normalizeLineBreakFilter',
        'notificationService'
    ];
    return SysLogsDiagnosticCtrl;
}());
angular.module('kamhpp').controller('SysLogsDiagnosticCtrl', SysLogsDiagnosticCtrl);
