var DomainUserModalCtrl = (function () {
    function DomainUserModalCtrl($scope, $modalInstance, notificationService, language, adsiProvider, domainUsers) {
        this.$scope = $scope;
        this.$modalInstance = $modalInstance;
        this.notificationService = notificationService;
        this.language = language;
        this.adsiProvider = adsiProvider;
        this.domainUsers = domainUsers;
        this.searchUser = { name: '' };
        this.foundUsers = [];
        $scope.ctrl = this;
    }
    DomainUserModalCtrl.prototype.onSearchUser = function () {
        var _this = this;
        this.adsiProvider
            .getDomainUsers(this.searchUser.name)
            .then(function (data) {
            _this.foundUsers = data;
            _this.selectedUser = _this.foundUsers[0];
        })
            .catch(function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), data);
        });
    };
    DomainUserModalCtrl.prototype.onKeyPress = function (event) {
        if (event.key === 'Enter') {
            this.onSearchUser();
        }
        if (event.key === 'Escape') {
            this.cancel();
        }
    };
    DomainUserModalCtrl.prototype.onSelectUser = function (user) {
        this.selectedUser = user;
    };
    ;
    DomainUserModalCtrl.prototype.ok = function () {
        var _this = this;
        if (_.any(this.domainUsers, function (user) { return user.login === _this.selectedUser.login; })) {
            this.notificationService.warnMessage(String.Format(this.language.getElementValue('securityUserAlreadyAddedMsg'), this.selectedUser.name, this.selectedUser.login));
        }
        else {
            this.$modalInstance.close(this.selectedUser);
        }
    };
    DomainUserModalCtrl.prototype.cancel = function () {
        this.$modalInstance.dismiss('cancel');
    };
    DomainUserModalCtrl.$inject = ['$scope', '$modalInstance', 'notificationService', 'language', 'adsiProvider', 'domainUsers'];
    return DomainUserModalCtrl;
}());
angular.module('kamhpp').controller('DomainUserModalCtrl', DomainUserModalCtrl);
