angular
    .module('kamhpp')
    .controller('selectClassInstanceModalCtrl', function ($scope, $http, clientSettings, $modalInstance, notificationService, data, language) {
    $scope.tree = {};
    $scope.data = data;
    var getData = function () {
        var treeNodes = _.map($scope.data, function (arg) {
            return {
                id: arg.UniqueCode,
                parent: arg.ParentUniqueCode === '' ? '#' : arg.ParentUniqueCode,
                text: arg.Name,
                changed: 'false',
                type: arg.IsGroupNode ? 'folder' : 'file',
            };
        });
        if (treeNodes.length === 0) {
            return [
                {
                    id: '1',
                    parent: undefined,
                    text: language.getElementValue('cimModelSelectLinkNoneHdr'),
                    changed: undefined,
                    type: undefined,
                },
            ];
        }
        else {
            return treeNodes;
        }
    };
    $scope.columns = [{ header: 'Имя', value: 'text' }];
    $scope.plugins = ['types', 'wholerow', 'grid'];
    $scope.types = {
        none: { icon: 'glyphicon glyphicon-none' },
        folder: { icon: 'fa fa-cog' },
        file: { icon: 'fa fa-file-o' },
    };
    $scope.startingData = getData();
    $scope.expandLevel = 2;
    $scope.selectedNodeLevel = 0;
    $scope.ok = function () {
        if (this.tree.selectedElements.length === 0) {
            notificationService.warnMessage(language.getElementValue('cimModelUnselectClassInstanceMsg'));
            return;
        }
        var selectedUniqueCode = this.tree.selectedElements[0];
        var element = _.find($scope.data, function (arg) {
            return arg.UniqueCode === selectedUniqueCode;
        });
        if (_.isUndefined(element) && element.IsGroupNode) {
            notificationService.warnMessage(language.getElementValue('cimModelUnselectClassInstanceMsg'));
        }
        else {
            $modalInstance.close({ ok: true, data: element });
        }
    };
    $scope.cancel = function () {
        $modalInstance.close({ ok: false });
    };
});
