var ReportTemplateListCtrl = (function () {
    function ReportTemplateListCtrl(reportTemplateProvider, reportTemplateService, authentication, permissionService, licenseModuleService, notificationService, language) {
        var _this = this;
        this.reportTemplateProvider = reportTemplateProvider;
        this.reportTemplateService = reportTemplateService;
        this.authentication = authentication;
        this.permissionService = permissionService;
        this.licenseModuleService = licenseModuleService;
        this.notificationService = notificationService;
        this.language = language;
        this.reportTemplateChapters = [];
        this.isReportTemplatesExists = false;
        this.permissions = this.permissionService.getAll();
        this.licenseModuleService
            .getModulesInfo()
            .then(function (moduleInfo) {
            _this.isReportModuleAvailable = moduleInfo.isReportModuleAvailable;
            _this.loadReportChapters();
        });
    }
    ReportTemplateListCtrl.prototype.$onInit = function () {
        var _a;
        this.isShowSearchInput = (_a = this.isShowSearchInput) !== null && _a !== void 0 ? _a : true;
    };
    ReportTemplateListCtrl.prototype.isOnHomePage = function () {
        return !this.isShowSearchInput;
    };
    ReportTemplateListCtrl.prototype.hasReportAdminPermission = function () {
        return this.authentication.hasPermission(this.permissions.ReportAdministrate);
    };
    ReportTemplateListCtrl.prototype.importDemoReportTemplates = function () {
        var _this = this;
        this.reportTemplateService.importDemoReportTemplates(0)
            .then(function () {
            _this.authentication.updatePermissions();
            _this.loadReportChapters();
        }, function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('reportErrorTemplatesImportMsg'), data);
        });
    };
    ReportTemplateListCtrl.prototype.uploadReportTemplatesFromFile = function (templatesFile) {
        var _this = this;
        if (_.isUndefined(templatesFile) || !_.any(templatesFile))
            return;
        this.reportTemplateService.importReportTemplates(templatesFile, 0)
            .then(function () {
            _this.loadReportChapters();
        }, function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('reportErrorTemplatesImportMsg'), data);
        });
    };
    ReportTemplateListCtrl.prototype.loadReportChapters = function () {
        var _this = this;
        if (this.isReportModuleAvailable) {
            this.reportTemplateProvider.getAllReportTemplatesCalculationInfo().then(function (reportTemplatesShortInfo) {
                _this.isReportTemplatesExists = _.any(reportTemplatesShortInfo);
                var reportTemplateChapters = _this.reportTemplateService.groupReportTemplateByChapters(reportTemplatesShortInfo);
                _.forEach(reportTemplateChapters, function (chapter) {
                    chapter.templates = _.filter(chapter.templates, function (report) { return _this.reportTemplateService.isReportTemplateVisible(report); });
                });
                _this.reportTemplateChapters = _.filter(reportTemplateChapters, function (c) { return _.any(c.templates); });
            }, function (data) {
                _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), data);
            });
        }
    };
    ReportTemplateListCtrl.$inject = [
        'reportTemplateProvider',
        'reportTemplateService',
        'authentication',
        'permissionService',
        'licenseService',
        'notificationService',
        'language'
    ];
    return ReportTemplateListCtrl;
}());
angular.module('kamhpp').controller('ReportTemplateListCtrl', ReportTemplateListCtrl);
