app.controller('TrendSettingsController', function ($scope, $modalInstance, $http, clientSettings, notificationService, graphs, language) {
    $scope.modalScope = {};
    $scope.modalScope.graphs = graphs;
    $scope.modalScope.yMin = 0;
    $scope.modalScope.yMax = 100;
    $scope.modalScope.autoZoom = true;
    $scope.modalScope.graphTypes = [
        { id: 0, name: language.getElementValue('reportTrendsViewGraphTypeLinerHdr') },
        { id: 1, name: language.getElementValue('reportTrendsViewGraphTypePointerHdr') },
        { id: 2, name: language.getElementValue('reportTrendsViewGraphTypeDiscreteHdr') },
    ];
    $scope.modalScope.pointTypes = [
        { id: 0, name: language.getElementValue('reportTrendsViewPointTypeNoneHdr') },
        { id: 4, name: language.getElementValue('reportTrendsViewPointTypeRectangleHdr') },
        { id: 5, name: language.getElementValue('reportTrendsViewPointTypeCircleHdr') },
        { id: 6, name: language.getElementValue('reportTrendsViewPointTypeTriangleHdr') },
        { id: 7, name: language.getElementValue('reportTrendsViewPointTypeFillRectangleHdr') },
        { id: 8, name: language.getElementValue('reportTrendsViewPointTypeFillCircleHdr') },
        { id: 9, name: language.getElementValue('reportTrendsViewPointTypeFillTriangleHdr') },
    ];
    $scope.pointTypesFilter = function (pointType) {
        if ($scope.modalScope.graphTypes.selected.id == 1)
            return pointType.id != 0;
        return true;
    };
    var unregistrationSelectedGraphTypesWatchFunc = $scope.$watch('modalScope.graphTypes.selected', function (after, before) {
        if (after == before)
            return;
        if (after.id == 1 && $scope.modalScope.pointTypes.selected.id == 0) {
            $scope.modalScope.pointTypes.selected = $scope.modalScope.pointTypes[1];
            $scope.updateSettings();
        }
    });
    $scope.changedGraphs = function (selectedGraphs) {
        var settings = _.find($scope.modalScope.graphs, function (item) {
            return item.id == selectedGraphs[0];
        }).settings;
        $scope.modalScope.graphTypes.selected = _.find($scope.modalScope.graphTypes, function (item) {
            return item.id == settings.graphType;
        });
        $scope.modalScope.pointTypes.selected = _.find($scope.modalScope.pointTypes, function (item) {
            return item.id == settings.pointType;
        });
        $scope.modalScope.autoZoom = settings.autoZoom;
        $scope.modalScope.yMin = settings.yMin;
        $scope.modalScope.yMax = settings.yMax;
        $scope.modalScope.selectedGraphs = selectedGraphs;
        $scope.updateSettings();
    };
    $scope.updateSettings = function () {
        for (var i = 0; i < $scope.modalScope.selectedGraphs.length; i++) {
            $scope.applySettings($scope.modalScope.selectedGraphs[i]);
        }
    };
    $scope.applySettings = function (id) {
        var settings = _.find($scope.modalScope.graphs, function (item) {
            return item.id == id;
        }).settings;
        settings.graphType = $scope.modalScope.graphTypes.selected.id;
        settings.pointType = $scope.modalScope.pointTypes.selected.id;
        settings.autoZoom = $scope.modalScope.autoZoom;
        settings.yMin = $scope.modalScope.yMin;
        settings.yMax = $scope.modalScope.yMax;
    };
    $scope.ok = function () {
        $modalInstance.close($scope.modalScope.graphs);
    };
    $scope.close = function () {
        $modalInstance.close(null);
    };
    var unregistrationDestroyFunc = $scope.$on('$destroy', function () {
        unregistrationSelectedGraphTypesWatchFunc();
        unregistrationDestroyFunc();
    });
});
