var SwitchoverFormTemplateTypicalOperationSelectModalCtrl = (function () {
    function SwitchoverFormTemplateTypicalOperationSelectModalCtrl($scope, modal, language, operations) {
        this.$scope = $scope;
        this.modal = modal;
        this.language = language;
        this.operations = operations;
        this.unknownTypeId = -1;
        this.operationFilter = {
            name: '',
            commandName: '',
            selectedType: this.unknownTypeId,
            types: [
                { id: this.unknownTypeId, name: language.getElementValue('allTypesHdr') },
                {
                    id: 0,
                    name: this.getTypeName(0),
                },
                {
                    id: 1,
                    name: this.getTypeName(1),
                },
                {
                    id: 2,
                    name: this.getTypeName(2),
                },
            ],
        };
        this.$scope.ctrl = this;
    }
    SwitchoverFormTemplateTypicalOperationSelectModalCtrl.prototype.selectOperation = function (operation) {
        this.selectedOperation = operation;
    };
    SwitchoverFormTemplateTypicalOperationSelectModalCtrl.prototype.getTypeName = function (type) {
        switch (type) {
            case 1: {
                return this.language.getElementValue('switchoverFormsAutomaticTypeMsg');
            }
            case 0: {
                return this.language.getElementValue('switchoverFormsManualTypeMsg');
            }
            case 2: {
                return this.language.getElementValue('switchoverFormsTextTypeMsg');
            }
            default: {
                return this.language.getElementValue('switchoverFormsNotSelectedEntryHdr');
            }
        }
    };
    SwitchoverFormTemplateTypicalOperationSelectModalCtrl.prototype.filterOperations = function () {
        var _this = this;
        return function (operation) { return _this.checkOperationByFilter(operation); };
    };
    SwitchoverFormTemplateTypicalOperationSelectModalCtrl.prototype.ok = function () {
        this.modal.close(this.selectedOperation);
    };
    SwitchoverFormTemplateTypicalOperationSelectModalCtrl.prototype.cancel = function () {
        this.modal.dismiss();
    };
    SwitchoverFormTemplateTypicalOperationSelectModalCtrl.prototype.checkOperationByFilter = function (operation) {
        var check = true;
        if (this.operationFilter.selectedType !== this.unknownTypeId) {
            check = check && operation.type === this.operationFilter.selectedType;
        }
        if (check && this.operationFilter.name !== '') {
            var findStr = this.operationFilter.name
                .toUpperCase()
                .replaceAllPolyfill(' ', '')
                .replaceAllPolyfill('.', '')
                .replaceAllPolyfill('-', '');
            check =
                check &&
                    operation.description
                        .toUpperCase()
                        .replaceAllPolyfill(' ', '')
                        .replaceAllPolyfill('.', '')
                        .replaceAllPolyfill('-', '')
                        .contains(findStr);
        }
        if (check && this.operationFilter.commandName !== '') {
            var findStr_1 = this.operationFilter.commandName.toUpperCase();
            check =
                check &&
                    _.any(operation.commands, function (command) { return command.name.toUpperCase().contains(findStr_1); });
        }
        return check;
    };
    SwitchoverFormTemplateTypicalOperationSelectModalCtrl.$inject = ['$scope', '$modalInstance', 'language', 'operations'];
    return SwitchoverFormTemplateTypicalOperationSelectModalCtrl;
}());
angular
    .module('kamhpp')
    .controller('switchoverFormTemplateTypicalOperationSelectModalCtrl', SwitchoverFormTemplateTypicalOperationSelectModalCtrl);
