var AggregationSettings = (function () {
    function AggregationSettings(templateHasStep) {
        this.func = 3;
        this.startPeriod = templateHasStep
            ? 'StepStart'
            : 'StartDate';
        this.endPeriod = templateHasStep
            ? 'StepEnd'
            : 'EndDate';
    }
    AggregationSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new AggregationSettings();
        clone.func = obj.func;
        clone.sourceParameterIdent = obj.sourceParameterIdent;
        clone.startPeriod = obj.startPeriod;
        clone.endPeriod = obj.endPeriod;
        return clone;
    };
    AggregationSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return obj.func === other.func
            && obj.sourceParameterIdent === other.sourceParameterIdent
            && obj.startPeriod === other.startPeriod
            && obj.endPeriod === other.endPeriod;
    };
    AggregationSettings.prototype.canEdited = function () {
        return false;
    };
    AggregationSettings.prototype.canPlanned = function () {
        return true;
    };
    AggregationSettings.prototype.canBacklight = function () {
        return true;
    };
    AggregationSettings.prototype.canPredefined = function () {
        return false;
    };
    return AggregationSettings;
}());
