var DictionarySettinsCtrl = (function () {
    function DictionarySettinsCtrl(parentScope, http, clientSettings, notificationService, language, qService, authentication) {
        var _this = this;
        this.authentication = authentication;
        this.watchFunctions = [];
        this.deepClassFind = function (cimDictionaryMap, filterFn) {
            var result;
            for (var i = 0; i < cimDictionaryMap.length; i++) {
                if (filterFn(cimDictionaryMap[i])) {
                    return cimDictionaryMap[i];
                }
                result = _this.deepClassFind(cimDictionaryMap[i].Items, filterFn);
            }
            return result;
        };
        this.getAttributes = function (func, classInstanceUniqueGuid) {
            return func === 'filterDictionaryClassInstancesByAttribute'
                ? _this.getChildClassAttributes(classInstanceUniqueGuid)
                : _this.getClassInstanceAttributes(classInstanceUniqueGuid);
        };
        this.getClassInstanceAttributes = function (classInstanceUniqueGuid) {
            var deferred = _this.qService.defer();
            _this.http
                .get(_this.clientSettings.getServerInstance() +
                '/CimModel/GetClassInstance?uniqueCode=' +
                classInstanceUniqueGuid)
                .then(function (response) {
                _this.classInstanceData = response.data;
                deferred.resolve(_.map(response.data.Attributes, function (a) {
                    return new UiSelectItem(a.UniqueCode, a.Name + ' = ' + a.Value);
                }));
            }, function (data) {
                deferred.reject(data);
            });
            return deferred.promise;
        };
        this.getChildClassAttributes = function (classInstanceUniqueGuid) {
            var deferred = _this.qService.defer();
            var classUniqueCode = _.find(_this.dictionaryTreeData.Nodes, function (i) {
                return i.UniqueCode === classInstanceUniqueGuid;
            }).ClassUniqueCode;
            var cimClass = _this.deepClassFind(_this.dictionaryTreeData.CimDictionaryMap, function (item) {
                return item.UniqueCode === classUniqueCode;
            });
            if (cimClass == undefined || _.isEmpty(cimClass.Items)) {
                _this.cimClassesData = [];
                deferred.resolve([]);
                return deferred.promise;
            }
            _this.http
                .post(_this.clientSettings.getServerInstance() + '/CimModel/GetClasses', {
                uniqueCodes: _.map(cimClass.Items, function (i) {
                    return i.UniqueCode;
                }),
            })
                .then(function (response) {
                _this.cimClassesData = [];
                _.each(response.data, function (item) {
                    _this.cimClassesData.push(item);
                });
                var attributes = _.chain(response.data)
                    .map(function (c) {
                    return c.Attributes;
                })
                    .flatten()
                    .map(function (a) {
                    return new UiSelectItem(a.UniqueCode, a.Name);
                })
                    .uniq()
                    .value();
                var groupAttributes = _.groupBy(attributes, function (a) {
                    return a.name;
                });
                deferred.resolve(_.map(groupAttributes, function (a, g) {
                    return new UiSelectItem(a[0].ident, g);
                }));
            }, function (data) {
                deferred.reject(data);
            });
            return deferred.promise;
        };
        this.parentScope = parentScope;
        this.language = language;
        this.http = http;
        this.qService = qService;
        this.clientSettings = clientSettings;
        this.notificationService = notificationService;
        this.attributes = [];
        this.filterName =
            parentScope.param.Dictionary != undefined &&
                parentScope.param.Dictionary.Func === 'filterDictionaryClassInstancesByName'
                ? JSON.parse(parentScope.param.Dictionary.Filter)[0]
                : undefined;
        this.filterPropertyName =
            parentScope.param.Dictionary != undefined &&
                parentScope.param.Dictionary.Func === 'filterDictionaryClassInstancesByAttribute'
                ? JSON.parse(parentScope.param.Dictionary.Filter)[0]
                : undefined;
        this.filterPropertyValue =
            parentScope.param.Dictionary != undefined &&
                parentScope.param.Dictionary.Func === 'filterDictionaryClassInstancesByAttribute'
                ? JSON.parse(parentScope.param.Dictionary.Filter)[1]
                : undefined;
        this.tree = new SmsTree();
        this.dictionaryTreeData = undefined;
        this.classInstanceData = undefined;
        this.cimClassesData = [];
        this.columns = [new SmsTreeColumn(language.getElementValue('nameHdr'), 'text')];
        this.startingData = new SmsTreeDataItem('1', language.getElementValue('reportLoadDicrionaryHdr'));
        this.types = new SmsTypes('glyphicon glyphicon-none', 'fa fa-cog', 'fa fa-file-o');
        this.expandLevel = 2;
        this.getChildClassAttributes = this.getChildClassAttributes.bind(this);
        this.getClassInstanceAttributes = this.getClassInstanceAttributes.bind(this);
        this.getAttributes = this.getAttributes.bind(this);
    }
    DictionarySettinsCtrl.prototype.init = function () {
        var _this = this;
        if (this.authentication.hasPermission(this.parentScope.$parent.permissions.CimView)) {
            this.http.get(this.clientSettings.getServerInstance() + '/CimModel/GetDictionaryProfiles').then(function (response) {
                var selfScope = _this;
                _this.functions = getVariantsContainer(_this.parentScope, [
                    new UiSelectItem('dictionaryClassInstanceAttributeValue', _this.language.getElementValue('reportDictionaryClassInstanceAttributeValueHdr')),
                    new UiSelectItem('dictionaryClassInstancesChildren', _this.language.getElementValue('reportDictionaryClassInstancesChildrenHdr')),
                    new UiSelectItem('filterDictionaryClassInstancesByName', _this.language.getElementValue('reportFilterDictionaryClassInstancesByNameHdr')),
                    new UiSelectItem('filterDictionaryClassInstancesByAttribute', _this.language.getElementValue('reportFilterDictionaryClassInstancesByAttributeHdr')),
                ], function (t) {
                    return t.ident === selfScope.parentScope.param.Dictionary.Func;
                }, function (after, before) {
                    if (after == before) {
                        return;
                    }
                    selfScope.parentScope.param.Dictionary.Func = after.ident;
                    if ((after.ident === 'dictionaryClassInstanceAttributeValue' ||
                        after.ident === 'filterDictionaryClassInstancesByAttribute') &&
                        _.isDefined(selfScope.tree.selectedElements) &&
                        selfScope.tree.selectedElements.length !== 0) {
                        updateAttributes(after.ident, selfScope.tree.selectedElements[0].split('__')[0]).then(updateUniqueCodes);
                    }
                    else {
                        updateUniqueCodes();
                    }
                });
                _this.dictionaries = getVariantsContainer(_this.parentScope, _.map(response.data, function (d) {
                    return new UiSelectItem(d.Id, d.Name);
                }), function (t) {
                    return t.ident == selfScope.parentScope.param.Dictionary.UniqueCodes;
                }, function (after, before) {
                    if (after === before) {
                        return;
                    }
                });
                var loadDictionaryTree = function (id) {
                    _this.http.get(_this.clientSettings.getServerInstance() + '/CimModel/GetDictionaryTree?id=' + id).then(function (response) {
                        selfScope.dictionaryTreeData = response.data;
                        drawTree();
                    }, function (data) {
                        selfScope.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), data);
                    });
                };
                _this.watchFunctions.push(_this.parentScope.$on('jstreeReady', function () {
                    if (_.isDefined(selfScope.dictionaries.selected)) {
                        loadDictionaryTree(selfScope.dictionaries.selected.ident);
                    }
                }));
                var codes = JSON.parse(selfScope.parentScope.param.Dictionary.UniqueCodes);
                var prevCodes = codes;
                var updateDictionaryClassInstanceAttributeValue = function () {
                    var arr = [];
                    if (selfScope.dictionaries.selected != undefined) {
                        arr.push(selfScope.dictionaries.selected.ident);
                        if (selfScope.tree.selectedElements != undefined && !_.isEmpty(selfScope.tree.selectedElements)) {
                            arr.push(selfScope.tree.selectedElements[0].split('__')[0]);
                            if (selfScope.attributes.selected != undefined) {
                                arr.push(selfScope.attributes.selected.ident);
                            }
                        }
                    }
                    codes = _.filter(arr, function (a) {
                        return a != undefined;
                    });
                    selfScope.parentScope.param.Dictionary.UniqueCodes = JSON.stringify(codes);
                    selfScope.parentScope.settingsCtrl.formulaCtrl.setFormula(selfScope.getFormula());
                };
                var updateDictionaryClassInstancesChildren = function () {
                    var arr = [];
                    if (selfScope.dictionaries.selected != undefined) {
                        arr.push(selfScope.dictionaries.selected.ident);
                        if (selfScope.tree.selectedElements != undefined && !_.isEmpty(selfScope.tree.selectedElements)) {
                            arr.push(selfScope.tree.selectedElements[0].split('__')[0]);
                        }
                    }
                    codes = _.filter(arr, function (a) {
                        return a != undefined;
                    });
                    selfScope.parentScope.param.Dictionary.UniqueCodes = JSON.stringify(codes);
                    selfScope.parentScope.settingsCtrl.formulaCtrl.setFormula(selfScope.getFormula());
                };
                var updateFilterDictionaryClassInstancesByName = function () {
                    var arr = [];
                    if (selfScope.dictionaries.selected != undefined) {
                        arr.push(selfScope.dictionaries.selected.ident);
                        if (selfScope.tree.selectedElements != undefined && !_.isEmpty(selfScope.tree.selectedElements)) {
                            arr.push(selfScope.tree.selectedElements[0].split('__')[0]);
                        }
                    }
                    codes = _.filter(arr, function (a) {
                        return a != undefined;
                    });
                    selfScope.parentScope.param.Dictionary.UniqueCodes = JSON.stringify(codes);
                    selfScope.parentScope.param.Dictionary.Filter = JSON.stringify([selfScope.filterName]);
                    selfScope.parentScope.settingsCtrl.formulaCtrl.setFormula(selfScope.getFormula());
                };
                var updateFilterDictionaryClassInstancesByAttribute = function () {
                    var arr = [];
                    if (selfScope.dictionaries.selected != undefined) {
                        arr.push(selfScope.dictionaries.selected.ident);
                        if (selfScope.tree.selectedElements != undefined && !_.isEmpty(selfScope.tree.selectedElements)) {
                            arr.push(selfScope.tree.selectedElements[0].split('__')[0]);
                        }
                    }
                    codes = _.filter(arr, function (a) {
                        return a != undefined;
                    });
                    selfScope.parentScope.param.Dictionary.UniqueCodes = JSON.stringify(codes);
                    selfScope.filterPropertyName = _.isDefined(selfScope.attributes.selected)
                        ? selfScope.attributes.selected.name
                        : undefined;
                    selfScope.parentScope.param.Dictionary.Filter = JSON.stringify([
                        selfScope.filterPropertyName,
                        selfScope.filterPropertyValue,
                    ]);
                    selfScope.parentScope.settingsCtrl.formulaCtrl.setFormula(selfScope.getFormula());
                };
                var updateUniqueCodes = function () {
                    switch (selfScope.functions.selected.ident) {
                        case 'dictionaryClassInstanceAttributeValue':
                            updateDictionaryClassInstanceAttributeValue();
                            break;
                        case 'dictionaryClassInstancesChildren':
                            updateDictionaryClassInstancesChildren();
                            break;
                        case 'filterDictionaryClassInstancesByName':
                            updateFilterDictionaryClassInstancesByName();
                            break;
                        case 'filterDictionaryClassInstancesByAttribute':
                            updateFilterDictionaryClassInstancesByAttribute();
                            break;
                    }
                };
                var drawTree = function () {
                    var nodes = selfScope.dictionaryTreeData.Nodes;
                    var treeNodes = _.map(nodes, function (arg) {
                        var treeId = arg.UniqueCode + '__' + (arg.ParentUniqueCode === '' ? '#' : arg.ParentUniqueCode);
                        arg.TreeId = treeId;
                        var parent;
                        _.each(nodes, function (val) {
                            if (val.UniqueCode === arg.ParentUniqueCode && !_.isUndefined(val.TreeId)) {
                                parent = val;
                            }
                        });
                        return new SmsTreeDataItem(treeId, arg.Name, arg.ClassUniqueCode === 'parameter' ? 'file' : 'folder', parent == undefined ? '#' : parent.TreeId);
                    });
                    if (selfScope.tree.element == undefined)
                        return;
                    selfScope.tree.element.jstree().settings.core.data =
                        treeNodes.length === 0
                            ? new SmsTreeDataItem('1', selfScope.language.getElementValue('dataDictionaryIsNoneHdr'))
                            : treeNodes;
                    selfScope.tree.element.jstree('refresh');
                };
                _this.watchFunctions.push(selfScope.parentScope.$on('jstreeRefresh', function (event, data) {
                    if (selfScope.tree.element.attr('id') == data && codes[1] != undefined) {
                        var nodes = selfScope.dictionaryTreeData.Nodes;
                        var node = _.find(nodes, function (n) {
                            return n.UniqueCode === codes[1];
                        });
                        selfScope.tree.element.jstree().select_node(codes[1] + '__' + (node === null || node === void 0 ? void 0 : node.ParentUniqueCode));
                    }
                }));
                selfScope.functions.selected = _this.parentScope.getSelectedItem(selfScope.functions, selfScope.parentScope.param.Dictionary.Func);
                _this.watchFunctions.push(selfScope.parentScope.$watch(function () {
                    return selfScope.functions.selected;
                }, function (after) {
                    if (after == undefined)
                        return;
                    selfScope.parentScope.param.Dictionary.Func = after.ident;
                }));
                selfScope.dictionaries.selected =
                    codes[0] == undefined ? undefined : _this.parentScope.getSelectedItem(selfScope.dictionaries, codes[0]);
                _this.watchFunctions.push(selfScope.parentScope.$watch(function () {
                    return selfScope.dictionaries.selected;
                }, function (after, before) {
                    selfScope.tree.selectedElements = [];
                    if (_.isUndefined(after))
                        return;
                    loadDictionaryTree(after.ident);
                    if (after === before)
                        return;
                    updateUniqueCodes();
                }));
                var updateAttributes = function (func, uniqueCode) {
                    var deferred = selfScope.qService.defer();
                    selfScope.getAttributes(func, uniqueCode).then(function (data) {
                        if (data == undefined || _.isEmpty(data)) {
                            selfScope.attributes = [];
                            deferred.resolve();
                        }
                        selfScope.attributes = getVariantsContainer(selfScope.parentScope, data, function (t) {
                            return t.ident === selfScope.parentScope.param.Dictionary.UniqueCodes;
                        }, function (after, before) {
                            if (after == undefined || after === before)
                                return;
                            updateUniqueCodes();
                        });
                        if (selfScope.functions.selected.ident === 'filterDictionaryClassInstancesByAttribute') {
                            var selectedAttr = _.find(selfScope.attributes, function (a) {
                                return a.name === selfScope.filterPropertyName;
                            });
                            selfScope.attributes.selected =
                                selfScope.filterPropertyName != undefined && selectedAttr != undefined
                                    ? selectedAttr
                                    : selfScope.attributes[0];
                        }
                        else {
                            selfScope.attributes.selected =
                                prevCodes[2] != undefined &&
                                    _.find(selfScope.attributes, function (a) {
                                        return a.ident === prevCodes[2];
                                    }) != undefined
                                    ? _this.parentScope.getSelectedItem(selfScope.attributes, prevCodes[2])
                                    : selfScope.attributes[0];
                        }
                        deferred.resolve();
                    }, function (data) {
                        selfScope.notificationService.errorMessage(selfScope.language.getElementValue('failedLoadDataServerMsg'), data);
                        deferred.reject();
                    });
                    return deferred.promise;
                };
                _this.watchFunctions.push(selfScope.parentScope.$watch(function () {
                    return selfScope.tree.selectedElements;
                }, function (after, before) {
                    if (after == undefined || _.isEmpty(after)) {
                        selfScope.attributes = [];
                        return;
                    }
                    if (after[0] === before[0]) {
                        return;
                    }
                    updateAttributes(selfScope.functions.selected.ident, after[0].split('__')[0]).then(updateUniqueCodes);
                }));
                _this.watchFunctions.push(selfScope.parentScope.$watch(function () {
                    return selfScope.attributes.selected;
                }, function (after, before) {
                    if (after == undefined || after === before)
                        return;
                    updateUniqueCodes();
                }));
                _this.watchFunctions.push(selfScope.parentScope.$watch(function () {
                    return selfScope.filterName;
                }, function (after, before) {
                    if (after == undefined || after === before)
                        return;
                    updateFilterDictionaryClassInstancesByName();
                }));
                _this.watchFunctions.push(selfScope.parentScope.$watch(function () {
                    return selfScope.filterPropertyName;
                }, function (after, before) {
                    if (after == undefined || after === before)
                        return;
                    updateFilterDictionaryClassInstancesByAttribute();
                }));
                _this.watchFunctions.push(selfScope.parentScope.$watch(function () {
                    return selfScope.filterPropertyValue;
                }, function (after, before) {
                    if (after == undefined || after === before)
                        return;
                    updateFilterDictionaryClassInstancesByAttribute();
                }));
                _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
                if (!_this.canEdited()) {
                    _this.parentScope.param.Editable = false;
                }
            }, function (response) {
                _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), response);
            });
        }
    };
    DictionarySettinsCtrl.prototype.getParameterType = function (type) {
        switch (type) {
            case this.language.getElementValue('reportParameterTypeStringHdr'):
                return 'string';
            case this.language.getElementValue('reportParameterTypeDoubleHdr'):
                return 'double';
            case this.language.getElementValue('reportParameterTypeIntegerHdr'):
                return 'int';
            case this.language.getElementValue('reportParameterTypeBooleanHdr'):
                return 'bool';
            case this.language.getElementValue('dateHdr'):
                return 'DateTime';
            case this.language.getElementValue('reportParameterTypeStringArrayHdr'):
                return 'string[]';
            case this.language.getElementValue('reportParameterTypeDoubleArrayHdr'):
                return 'double[]';
            case this.language.getElementValue('reportParameterTypeStringMatrixHdr'):
                return 'string[][]';
            case this.language.getElementValue('reportParameterTypeDoubleMatrixHdr'):
                return 'double[][]';
            case this.language.getElementValue('reportParameterTypeArrayOfStringMatrixHdr'):
                return 'string[][][]';
            case this.language.getElementValue('reportParameterTypeArrayOfDoubleMatrixHdr'):
                return 'double[][][]';
            default:
                return 'string';
        }
    };
    DictionarySettinsCtrl.prototype.getFormula = function () {
        var type;
        var code;
        var filter;
        var attribute;
        switch (this.functions.selected.ident) {
            case 'dictionaryClassInstanceAttributeValue': {
                code = JSON.parse(this.parentScope.param.Dictionary.UniqueCodes)[2];
                attribute =
                    this.classInstanceData == undefined
                        ? undefined
                        : _.find(this.classInstanceData.Attributes, function (a) {
                            return a.UniqueCode === code;
                        });
                type = attribute == undefined ? 'string' : this.getParameterType(attribute.DataType);
                this.parentScope.settingsCtrl.formulaCtrl.setResultType(type);
                return 'return (' + type + ')GetDictionaryClassInstanceAttributeValue("' + code + '");';
            }
            case 'dictionaryClassInstancesChildren': {
                code = JSON.parse(this.parentScope.param.Dictionary.UniqueCodes)[1];
                type = 'DictionaryClassInstance[]';
                this.parentScope.settingsCtrl.formulaCtrl.setResultType(type);
                return 'return GetDictionaryClassInstancesChildren("' + code + '");';
            }
            case 'filterDictionaryClassInstancesByName': {
                code = JSON.parse(this.parentScope.param.Dictionary.UniqueCodes)[1];
                type = 'DictionaryClassInstance[]';
                this.parentScope.settingsCtrl.formulaCtrl.setResultType(type);
                filter = JSON.parse(this.parentScope.param.Dictionary.Filter)[0];
                return ('return GetFilterDictionaryClassInstancesByName(GetDictionaryClassInstancesChildren("' +
                    code +
                    '"), "' +
                    filter +
                    '");');
            }
            case 'filterDictionaryClassInstancesByAttribute': {
                code = JSON.parse(this.parentScope.param.Dictionary.UniqueCodes)[1];
                filter = JSON.parse(this.parentScope.param.Dictionary.Filter);
                var filterPropertyName_1 = filter[0];
                var filterPropertyValue = _.isEmpty(filter[1]) ? null : filter[1];
                if (_.isDefined(this.tree.selectedElements) && this.tree.selectedElements.length !== 0) {
                    var attributes = _.chain(this.cimClassesData)
                        .map(function (c) {
                        return c.Attributes;
                    })
                        .flatten()
                        .value();
                    attribute = _.find(attributes, function (a) {
                        return a.Name === filterPropertyName_1;
                    });
                }
                if (attribute != undefined) {
                    var attributeType = this.getParameterType(attribute.DataType);
                    var types = ['bool', 'int', 'double', 'DateTime'];
                    if (!_.contains(types, attributeType) && _.isDefined(filterPropertyValue)) {
                        filterPropertyValue = '"' + filterPropertyValue.replaceAllPolyfill('"', '\\"') + '"';
                    }
                }
                type = 'DictionaryClassInstance[]';
                this.parentScope.settingsCtrl.formulaCtrl.setResultType(type);
                return ('return GetFilterDictionaryClassInstancesByAttribute(GetDictionaryClassInstancesChildren("' +
                    code +
                    '"), ' +
                    '"' +
                    filterPropertyName_1 +
                    '", ' +
                    filterPropertyValue +
                    ');');
            }
        }
        return '';
    };
    DictionarySettinsCtrl.prototype.isIncorrectParameterSettings = function () {
        return false;
    };
    DictionarySettinsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.Dictionary.canEdited();
    };
    DictionarySettinsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.Dictionary.canPlanned();
    };
    DictionarySettinsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.Dictionary.canBacklight();
    };
    DictionarySettinsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.Dictionary.canPredefined();
    };
    DictionarySettinsCtrl.prototype.destroy = function () {
        this.functions.destroy();
        this.dictionaries.destroy();
        if (typeof this.attributes.destroy === 'function') {
            this.attributes.destroy();
        }
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func))
                func();
        }
        this.watchFunctions = [];
    };
    return DictionarySettinsCtrl;
}());
