var FileSettingsCtrl = (function () {
    function FileSettingsCtrl(parentScope) {
        this.parentScope = parentScope;
        this.connectionTypes = [7];
        this.fileTypes = [
            new SelectFunctionsItem(3, 'TXT', 'ReadAllTextByConnection', 'string'),
            new SelectFunctionsItem(5, 'CSV', 'ReadCsvFileByConnection', 'string[][]')
        ];
    }
    FileSettingsCtrl.prototype.init = function () {
        var _this = this;
        this.selectedFileType = _.find(this.fileTypes, function (f) { return f.ident === _this.parentScope.param.File.fileType; });
        this.onFileTypeChanged();
    };
    FileSettingsCtrl.prototype.onFileTypeChanged = function () {
        this.parentScope.param.File.fileType = this.selectedFileType.ident;
        this.parentScope.settingsCtrl.formulaCtrl.setResultType(this.selectedFileType.returnType);
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
    };
    FileSettingsCtrl.prototype.destroy = function () { };
    FileSettingsCtrl.prototype.getFormula = function () {
        var _a;
        return "return ".concat(this.selectedFileType.sourceFunction, "(\"").concat((_a = this.parentScope.param.File) === null || _a === void 0 ? void 0 : _a.connectionGuid, "\");");
    };
    FileSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return false;
    };
    FileSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.File.canEdited();
    };
    FileSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.File.canPlanned();
    };
    FileSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.File.canBacklight();
    };
    FileSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.File.canPredefined();
    };
    return FileSettingsCtrl;
}());
