var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var MySqlSettingsCtrl = (function (_super) {
    __extends(MySqlSettingsCtrl, _super);
    function MySqlSettingsCtrl(codeEditor, modalService, parentScope, language) {
        var _this = _super.call(this, codeEditor, modalService, parentScope) || this;
        _this.parentScope = parentScope;
        _this.language = language;
        _this.functions = [];
        _this.connectionTypes = [3];
        _this.watchFunctions = [];
        return _this;
    }
    MySqlSettingsCtrl.prototype.init = function () {
        var self = this;
        this.functions = getVariantsContainer(this.parentScope, [
            new SelectSourceFunctionsItem('table', this.language.getElementValue('sqlTableHtmlHdr'), 'ReportTable'),
            new SelectSourceFunctionsItem('doubleArray', this.language.getElementValue('sqlTableNumberHdr'), 'double[][]'),
            new SelectSourceFunctionsItem('objectArray', this.language.getElementValue('reportParameterTypeTableObjectHdr'), 'object[][]'),
            new SelectSourceFunctionsItem('cellString', this.language.getElementValue('reportCellStringHdr'), 'string'),
            new SelectSourceFunctionsItem('cellDouble', this.language.getElementValue('reportCellNumberHdr'), 'double'),
            new SelectSourceFunctionsItem('stringOneDimArray', this.language.getElementValue('sqlStringSetHdr'), 'string[]'),
        ], function (t) {
            return t.ident === self.parentScope.param.MySql.func;
        }, function (after, before) {
            if (after === before)
                return;
            if (after == undefined || after === before)
                return;
            self.parentScope.param.MySql.func = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setResultType(after.returnType);
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
            if (!self.canEdited()) {
                self.parentScope.param.Editable = false;
            }
        });
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return self.parentScope.param.MySql;
        }, function (before, after) {
            if (_.isUndefined(self.parentScope.param.MySql) ||
                _.isNull(self.parentScope.param.MySql) ||
                after == undefined) {
                return;
            }
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        }, true));
        this.parentScope.settingsCtrl.formulaCtrl.setResultType(this.functions.selected.returnType);
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
    };
    MySqlSettingsCtrl.prototype.onCodeEditorChange = function (change) {
        this.parentScope.param.MySql.sql = change.code;
    };
    MySqlSettingsCtrl.prototype.destroy = function () {
        this.functions.destroy();
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func)) {
                func();
            }
        }
    };
    MySqlSettingsCtrl.prototype.getFormula = function () {
        var connectionGuid = this.parentScope.param.MySql.connectionGuid;
        var sql = ReportFormulaEscaper.escape(this.parentScope.param.MySql.sql, this.parentScope.reportTemplate.Parameters);
        switch (this.functions.selected.ident) {
            case 'table':
                return ('return MySqlQueryAsTableByConnection("' +
                    connectionGuid +
                    '", ' +
                    sql +
                    ', ' +
                    this.parentScope.param.MySql.includeHeader +
                    ');');
            case 'doubleArray':
                return 'return MySqlQueryAsDoubleArrayByConnection("' + connectionGuid + '", ' + sql + ');';
            case 'objectArray':
                return 'return MySqlQueryAsObjectArrayByConnection("' + connectionGuid + '", ' + sql + ');';
            case 'cellString':
                return 'return MySqlQueryAsStringByConnection("' + connectionGuid + '", ' + sql + ', 0 ,0);';
            case 'cellDouble':
                return 'return MySqlQueryAsDoubleByConnection("' + connectionGuid + '", ' + sql + ', 0, 0);';
            case 'stringOneDimArray':
                return 'return MySqlQueryAsStringArrayByConnection("' + connectionGuid + '", ' + sql + ')[0];';
        }
        return '';
    };
    MySqlSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return false;
    };
    MySqlSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.MySql.canEdited();
    };
    MySqlSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.MySql.canPlanned();
    };
    MySqlSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.MySql.canBacklight();
    };
    MySqlSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.MySql.canPredefined();
    };
    return MySqlSettingsCtrl;
}(DatabaseSettingsBaseCtrl));
