var NavigationSettingsCtrl = (function () {
    function NavigationSettingsCtrl($http, clientSettings, parentScope, reportTemplateProvider, notificationService, language) {
        this.$http = $http;
        this.clientSettings = clientSettings;
        this.parentScope = parentScope;
        this.reportTemplateProvider = reportTemplateProvider;
        this.notificationService = notificationService;
        this.language = language;
        this.reportLinkType = 'report';
        this.urlLinkType = 'url';
        this.watchFunctions = [];
        this.reports = [];
        this.reportPredefinedParameters = [];
        this.userDefinedParameters = [];
        this.predefinedValuesHashCode = 0;
    }
    NavigationSettingsCtrl.prototype.init = function () {
        var _this = this;
        this.displayedTypes = getVariantsContainer(this.parentScope, [
            new UiSelectItem(0, this.language.getElementValue('reportParameterNavigationTypeButtonHdr')),
            new UiSelectItem(1, this.language.getElementValue('reportParameterNavigationTypeLinkHdr'))
        ], function (t) {
            return t.ident === _this.parentScope.param.Navigation.link.type;
        }, function (after, before) {
            if (after === before)
                return;
            _this.parentScope.param.Navigation.link.type = after.ident;
            _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
        });
        this.linkTypes = getVariantsContainer(this.parentScope, [
            new UiSelectItem(this.reportLinkType, this.language.getElementValue('reportParameterNavigationGoToReportHdr')),
            new UiSelectItem(this.urlLinkType, this.language.getElementValue('reportParameterNavigationUrlHdr'))
        ], function (t) {
            return t.ident === _this.parentScope.param.Navigation.func;
        }, function (after, before) {
            if (after === before || _.isUndefined(after))
                return;
            _this.parentScope.param.Navigation.func = after.ident;
            if (after === _this.urlLinkType) {
                _this.parentScope.param.Navigation.templateUniqueGuid = '';
                _this.parentScope.param.Navigation.reportStart = '';
                _this.parentScope.param.Navigation.reportEnd = '';
            }
            else {
                _this.parentScope.param.Navigation.url = '';
            }
            _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
        });
        this.reportTemplateProvider.getAllReportTemplatesShortInfo().then(function (reportTemplates) {
            _this.reportTemplates = reportTemplates;
            _this.reports = getVariantsContainer(_this.parentScope, _.map(_this.reportTemplates, function (item) {
                return new UiSelectItem(item.uniqueGuid, item.name);
            }), function (t) {
                return t.ident === _this.parentScope.param.Navigation.templateUniqueGuid;
            }, function (after, before) {
                if (after === before || _.isUndefined(after))
                    return;
                _this.parentScope.param.Navigation.templateUniqueGuid = after.ident;
                _this.onPredefinedParametersChange();
                _this.updatePredefinedValues(after.ident);
                _this.updateUiEndReportContainer();
            });
            _this.updateUiEndReportContainer();
        }, function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), data);
        });
        this.reportStart = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
            return _this.parentScope.param.Navigation.reportStart;
        }, function (after, before) {
            if (after === before || _.isUndefined(after))
                return;
            _this.parentScope.param.Navigation.reportStart = after.ident;
            _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
        });
        this.reportEnd = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
            return _this.parentScope.param.Navigation.reportEnd;
        }, function (after, before) {
            if (after === before || _.isUndefined(after))
                return;
            _this.parentScope.param.Navigation.reportEnd = after.ident;
            _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
        });
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return _this.parentScope.param.Navigation.link.linkOpenInNewWindow;
        }, function (after, before) {
            if (before === after || _.isUndefined(after))
                return;
            _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
        }));
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return _this.parentScope.param.Navigation.link.linkOpenSavedReport;
        }, function (after, before) {
            if (before === after || _.isUndefined(after))
                return;
            _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
        }));
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return _this.parentScope.param.Navigation.link.title;
        }, function (after, before) {
            if (before === after || _.isUndefined(after))
                return;
            _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
        }));
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return _this.parentScope.param.Navigation.url;
        }, function (after, before) {
            if (before === after || _.isUndefined(after))
                return;
            _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
        }));
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return _this.parentScope.param.Navigation.reportStart;
        }, function (after, before) {
            if (before === after || _.isUndefined(after))
                return;
            _this.reportStart.selected = _.find(_this.parentScope.settingsCtrl.getTimestamps(), function (ts) { return ts.ident === after; });
            _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
        }, true));
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return _this.parentScope.param.Navigation.reportEnd;
        }, function (after, before) {
            if (before === after || _.isUndefined(after))
                return;
            _this.reportEnd.selected = _.find(_this.parentScope.settingsCtrl.getTimestamps(), function (ts) { return ts.ident === after; });
            _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
        }, true));
        this.parentScope.settingsCtrl.formulaCtrl.setResultType('LinkValue');
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
        this.updatePredefinedValues(this.parentScope.param.Navigation.templateUniqueGuid, this.parentScope.param.Navigation.reportParameterValues);
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
    };
    NavigationSettingsCtrl.prototype.destroy = function () {
        this.reports.destroy();
        this.displayedTypes.destroy();
        this.reportStart.destroy();
        this.reportEnd.destroy();
        this.linkTypes.destroy();
        _.forEach(this.watchFunctions, function (func) {
            if (!_.isUndefined(func)) {
                func();
            }
        });
        this.watchFunctions = [];
    };
    NavigationSettingsCtrl.prototype.getFormula = function () {
        var _a, _b;
        var url = this.parentScope.param.Navigation.func == 'url'
            ? "\"".concat(this.parentScope.param.Navigation.url, "\"")
            : this.parentScope.param.Navigation.link.linkOpenSavedReport
                ? this.getUrl(this.predefinedValuesHashCode)
                : this.getUrlForPreview();
        return String.Format("return new LinkValue({0}, \n    new LinkDescription(){ LinkOpenInNewWindow = {1}, Type = (DisplayedType){2}, Title = \"{3}\", LinkOpenSavedReport = {4} });", url, this.parentScope.param.Navigation.link.linkOpenInNewWindow.toString(), (_b = (_a = this.parentScope.param.Navigation.link.type) === null || _a === void 0 ? void 0 : _a.toString()) !== null && _b !== void 0 ? _b : '0', this.parentScope.param.Navigation.link.title, this.parentScope.param.Navigation.link.linkOpenSavedReport.toString());
    };
    NavigationSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return (_.isUndefined(this.displayedTypes.selected) ||
            _.isUndefined(this.linkTypes.selected) ||
            (this.linkTypes.selected.ident !== 'url' &&
                (_.isUndefined(this.reports.selected) ||
                    _.isUndefined(this.reportStart.selected) ||
                    (this.showEndReportTimeContainer && _.isUndefined(this.reportEnd.selected)))));
    };
    NavigationSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.Navigation.canPlanned();
    };
    NavigationSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.Navigation.canBacklight();
    };
    NavigationSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.Navigation.canEdited();
    };
    NavigationSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.Navigation.canPredefined();
    };
    NavigationSettingsCtrl.prototype.onPredefinedParametersChange = function () {
        var _this = this;
        this.parentScope.param.Navigation.reportParameterValues = _.map(this.reportPredefinedParameters, function (predefinedParameter) {
            return {
                parameterIdent: predefinedParameter.parameter.Ident,
                valueType: predefinedParameter.parameter.ParameterType,
                value: predefinedParameter.value,
            };
        });
        var predefinedValuesJson = JSON.stringify(_.map(this.reportPredefinedParameters, function (parameterValues) {
            return {
                parameterIdent: parameterValues.parameter.Ident,
                valueType: parameterValues.parameter.ParameterType,
                value: parameterValues.value
            };
        }));
        this.reportTemplateProvider.getPredefinedValuesHashCode(predefinedValuesJson).then(function (hashCode) {
            _this.predefinedValuesHashCode = hashCode;
            _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
        }, function () { });
    };
    NavigationSettingsCtrl.prototype.updatePredefinedValues = function (templateGuid, predefinedValues) {
        var _this = this;
        if (predefinedValues === void 0) { predefinedValues = []; }
        this.reportPredefinedParameters = [];
        this.userDefinedParameters = [];
        this.$http.get(this.clientSettings.getServerInstance() + '/ReportTemplate/GetLastVersionReportTemplatePredefinedParameters', { params: { uniqueGuid: templateGuid } }).then(function (response) {
            var parameters = response.data;
            _this.reportPredefinedParameters = _.map(parameters, function (parameter) {
                var _a, _b;
                var value = new ReportValue();
                value.value = (_b = (_a = _.find(predefinedValues, function (p) { return parameter.Ident === p.parameterIdent; })) === null || _a === void 0 ? void 0 : _a.value) === null || _b === void 0 ? void 0 : _b.value;
                if (!_.isUndefined(value.value)) {
                    var userDefinedValue = new ReportValue();
                    userDefinedValue.value = value.value;
                    _this.userDefinedParameters.push(new ParameterWithValue(parameter, value));
                }
                return new ParameterWithValue(parameter, value);
            });
        }, function () { });
    };
    NavigationSettingsCtrl.prototype.getUrl = function (hashCode) {
        return "$\"/#/reports?templateGuid=".concat(this.parentScope.param.Navigation.templateUniqueGuid, "&start={").concat(this.parentScope.param.Navigation.reportStart, ".ToString(\"dd.MM.yyyy HH:mm:ss\")}").concat(this.showEndReportTimeContainer
            ? "&stop={".concat(this.parentScope.param.Navigation.reportEnd, ".ToString(\"dd.MM.yyyy HH:mm:ss\")}")
            : '', "&predefinedValuesHashCode=").concat(hashCode, "\"");
    };
    NavigationSettingsCtrl.prototype.getUrlForPreview = function () {
        return "\"\"\"/#/reports?templateGuid=".concat(this.parentScope.param.Navigation.templateUniqueGuid, "&start={").concat(this.parentScope.param.Navigation.reportStart, ".ToString(\"dd.MM.yyyy HH:mm:ss\")}").concat(this.showEndReportTimeContainer
            ? "&stop={".concat(this.parentScope.param.Navigation.reportEnd, ".ToString(\"dd.MM.yyyy HH:mm:ss\")}")
            : '', "&predefinedValues=").concat(angular.toJson(_.map(this.parentScope.param.Navigation.reportParameterValues, function (parameterValue) {
            return {
                parameterIdent: parameterValue.parameterIdent,
                valueType: parameterValue.valueType,
                value: parameterValue.value.value
            };
        })), "&preview\"\"\"");
    };
    NavigationSettingsCtrl.prototype.updateUiEndReportContainer = function () {
        var _this = this;
        var template = _.find(this.reportTemplates, function (t) {
            return t.uniqueGuid === _this.parentScope.param.Navigation.templateUniqueGuid;
        });
        if (_.isUndefined(this.parentScope.param.Navigation.templateUniqueGuid) ||
            this.parentScope.param.Navigation.templateUniqueGuid === '') {
            this.reportStart.selected = null;
            this.reportEnd.selected = null;
            this.parentScope.param.Navigation.reportStart = '';
            this.parentScope.param.Navigation.reportEnd = '';
        }
        else {
            if (this.parentScope.param.Navigation.reportStart === '') {
                this.parentScope.param.Navigation.reportStart = 'StartDate';
            }
            if (template.reportType === 1) {
                if (this.parentScope.param.Navigation.reportEnd === '') {
                    this.parentScope.param.Navigation.reportEnd = 'EndDate';
                }
                this.showEndReportTimeContainer = true;
            }
            else {
                this.showEndReportTimeContainer = false;
            }
        }
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
    };
    return NavigationSettingsCtrl;
}());
