var SignatureSettingsCtrl = (function () {
    function SignatureSettingsCtrl(parentScope, userProvider, notificationService, language) {
        this.userProvider = userProvider;
        this.notificationService = notificationService;
        this.language = language;
        this.watchFunctions = [];
        this.parentScope = parentScope;
    }
    SignatureSettingsCtrl.prototype.remove = function (item) { };
    SignatureSettingsCtrl.prototype.init = function () {
        var _this = this;
        var self = this;
        this.userProvider
            .getAll()
            .then(function (data) {
            _this.users = data;
            try {
                var signatureAuthoritiesIds = JSON.parse(_this.parentScope.param.Sign.signingAuthorities);
                _this.signingAuthorities = signatureAuthoritiesIds.map(function (userId) {
                    var matchedUser = _this.users.find(function (u) { return u.id === userId; });
                    return { user: matchedUser || null };
                });
            }
            catch (e) {
                _this.signingAuthorities = [];
            }
            _this.remove = function (item) {
                var foundUser = _.find(self.signingAuthorities, function (o) {
                    return o.user.id === item.user.id;
                });
                var index = self.signingAuthorities.indexOf(foundUser);
                self.signingAuthorities.splice(index, 1);
            };
            _this.watchFunctions.push(_this.parentScope.$watch(function () {
                return self.signingAuthorities;
            }, function () {
                self.parentScope.param.Sign.signingAuthorities = JSON.stringify(_.map(self.signingAuthorities, function (i) {
                    return i.user.id;
                }));
            }, true));
            _this.parentScope.settingsCtrl.formulaCtrl.setResultType('string');
            _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
            if (!_this.canEdited()) {
                _this.parentScope.param.Editable = false;
            }
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    SignatureSettingsCtrl.prototype.add = function () {
        var _a;
        this.signingAuthorities.push({
            user: (_a = _.find(this.users, function (user) { return user.isActive; })) !== null && _a !== void 0 ? _a : _.first(this.users)
        });
    };
    SignatureSettingsCtrl.prototype.destroy = function () {
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func)) {
                func();
            }
        }
    };
    SignatureSettingsCtrl.prototype.getFormula = function () {
        return 'return "";';
    };
    SignatureSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return _.some(this.signingAuthorities, function (signingAuthority) {
            return (signingAuthority == undefined ||
                signingAuthority.user == undefined ||
                signingAuthority.user.id === '');
        });
    };
    SignatureSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.Sign.canEdited();
    };
    SignatureSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.Sign.canPlanned();
    };
    SignatureSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.Sign.canBacklight();
    };
    SignatureSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.Sign.canPredefined();
    };
    return SignatureSettingsCtrl;
}());
