var ParameterWithValue = (function () {
    function ParameterWithValue(parameter, value) {
        var _this = this;
        this.dependsOn = function (anotherParameterInfo) {
            return _.any(_this.parameter.DependencyParameters, function (paramIdent) {
                return paramIdent === anotherParameterInfo.parameter.Ident;
            });
        };
        this.parameter = parameter;
        this.value = _.isDefined(value)
            ? value
            : new ReportValue();
    }
    return ParameterWithValue;
}());
var ParameterValueWithStatus = (function () {
    function ParameterValueWithStatus(ident, value, valueType) {
        this.parameterIdent = ident;
        this.value = value;
        this.valueType = valueType;
    }
    return ParameterValueWithStatus;
}());
var CreationAction = (function () {
    function CreationAction(scope, reportTemplate, source) {
        if (source === void 0) { source = null; }
        var _this = this;
        this.type = 5;
        this.predefinedParameterValues = [];
        this.predefinedParametersWithValue = [];
        this.userDefinedParametersWithValue = [];
        this.loadingData = false;
        this.watchFunctions = [];
        this.needShowReportDuration = reportTemplate.ReportType === 1;
        if (source) {
            this.intervalDuration = source.intervalDuration;
            this.intervalShift = source.intervalShift;
            this.currentAttemps = source.currentAttemps;
            this.executionStatus = source.executionStatus;
            this.predefinedParameterValues = source.predefinedParameterValues;
            this.userDefinedParametersWithValue = _.map(_.filter(reportTemplate.Parameters, function (p) { return p.Predefined && _.any(_this.predefinedParameterValues, function (paramWithValue) { var _a; return paramWithValue.parameterIdent === p.Ident && !_.isUndefined((_a = paramWithValue.value) === null || _a === void 0 ? void 0 : _a.value); }); }), function (parameter) {
                var predefinedReportValue = _.find(source.predefinedParameterValues, function (param) { return param.parameterIdent === parameter.Ident; });
                var reportValue = new ReportValue();
                reportValue.value = predefinedReportValue.value.value;
                reportValue.backlightColor = predefinedReportValue.value.backlightColor;
                reportValue.error = predefinedReportValue.value.error;
                reportValue.isDefined = predefinedReportValue.value.isDefined;
                reportValue.isQuality = predefinedReportValue.value.isQuality;
                reportValue.status = predefinedReportValue.value.status;
                return new ParameterWithValue(parameter, reportValue);
            });
        }
        else {
            this.intervalDuration = reportTemplate.ReportType === 0 ? '0d' : '1d';
            this.intervalShift = '0h';
            this.currentAttemps = 0;
            this.executionStatus = null;
        }
        scope.$watch(function () { return reportTemplate.Parameters; }, function (newVal, oldVal) {
            if (_.isUndefined(newVal) && _.isUndefined(oldVal)) {
                return;
            }
            var predefinedParametersDependencies = [];
            _.forEach(_.filter(reportTemplate.Parameters, function (p) { return p.Predefined; }), function (predefinedParamter) {
                _.forEach(predefinedParamter.DependencyParameters, function (parameter) {
                    if (!predefinedParametersDependencies.includes(parameter)) {
                        predefinedParametersDependencies.push(parameter);
                    }
                });
            });
            _this.predefinedParametersWithValue = _.map(_.filter(reportTemplate.Parameters, function (p) { return p.Predefined || predefinedParametersDependencies.includes(p.Ident); }), function (parameter) {
                var reportValue = new ReportValue();
                if (_.isDefined(source)) {
                    var predefinedReportValue = _.find(source.predefinedParameterValues, function (param) { return param.parameterIdent === parameter.Ident; });
                    if (predefinedReportValue) {
                        reportValue.value = predefinedReportValue.value.value;
                        reportValue.backlightColor = predefinedReportValue.value.backlightColor;
                        reportValue.error = predefinedReportValue.value.error;
                        reportValue.isDefined = predefinedReportValue.value.isDefined;
                        reportValue.isQuality = predefinedReportValue.value.isQuality;
                        reportValue.status = predefinedReportValue.value.status;
                    }
                }
                return new ParameterWithValue(parameter, reportValue);
            });
        }, true);
        scope.$watch(function () { return _this.predefinedParametersWithValue; }, function () {
            _this.predefinedParameterValues = _.map(_this.predefinedParametersWithValue, function (parameter) {
                return {
                    parameterIdent: parameter.parameter.Ident,
                    valueType: parameter.parameter.ParameterType,
                    value: parameter.value
                };
            });
        }, true);
    }
    CreationAction.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return obj.intervalDuration === other.intervalDuration
            && obj.intervalShift === other.intervalShift
            && _.isEqual(obj.predefinedParameterValues, other.predefinedParameterValues);
    };
    return CreationAction;
}());
