var ReportRuleItem = (function () {
    function ReportRuleItem() {
    }
    return ReportRuleItem;
}());
var ReportInfoModalCtrl = (function () {
    function ReportInfoModalCtrl($scope, $modalInstance, language, authentication, permissionService, reportTemplateService, report) {
        var _this = this;
        this.$scope = $scope;
        this.$modalInstance = $modalInstance;
        this.language = language;
        this.authentication = authentication;
        this.reportTemplateService = reportTemplateService;
        this.report = report;
        this.rules = [];
        this.hasChanges = false;
        this.dateFormat = Date.masks.fullDateTime;
        this.$scope.ctrl = this;
        this.$scope.ctrl.report = report;
        this.$scope.ctrl.dateFormat = Date.masks.fullDateTime;
        this.permissions = permissionService.getAll();
        this.rules = _.map(this.report.Rules, function (rule) { return _this.convertToRule(rule); });
    }
    ReportInfoModalCtrl.prototype.isShowPredefiniedParametersInfo = function () {
        return !_.isEmpty(this.report.PredefinedValues.ParameterValues);
    };
    ReportInfoModalCtrl.prototype.isShowRulesInfo = function () {
        return !_.isEmpty(this.report.Rules);
    };
    ReportInfoModalCtrl.prototype.onRuleStateChanged = function () {
        this.hasChanges = true;
    };
    ReportInfoModalCtrl.prototype.canChangeRuleState = function (rule) {
        return (_.isUndefined(rule.anotherReportEventTrigger)
            && this.authentication.hasPermission(this.permissions.ReportAdministrate)
            && this.reportTemplateService.checkEditCurrentReportPermission());
    };
    ReportInfoModalCtrl.prototype.hasNextTriggerTime = function (rule) {
        return _.isDefined(rule.nextTriggerTime);
    };
    ReportInfoModalCtrl.prototype.close = function () {
        this.$modalInstance.dismiss();
    };
    ReportInfoModalCtrl.prototype.ok = function () {
        var _this = this;
        var indexes = _.map(_.filter(this.rules, function (rule) { return rule.isEnabled; }), function (rule) { return _this.rules.indexOf(rule); });
        this.$modalInstance.close(indexes);
    };
    ReportInfoModalCtrl.prototype.getPredefinedValue = function (value) {
        var _a;
        if (_.isDefined(value.Variants)) {
            if (!value.CanMultipleSelect) {
                return (_a = _.find(value.Variants, function (i) { return i.IsSelected; })) === null || _a === void 0 ? void 0 : _a.Name;
            }
            else {
                return _.filter(value.Variants, function (i) { return i.IsSelected; })
                    .map(function (i) { return i.Name; })
                    .join(', ');
            }
        }
        return value;
    };
    ReportInfoModalCtrl.prototype.convertToRule = function (rule) {
        var trigger = this.getTrigger(rule);
        var action = this.getAction(rule);
        var ruleItem = new ReportRuleItem();
        ruleItem.isEnabled = rule.isEnabled;
        ruleItem.actionType = this.getActionTypeName(action);
        ruleItem.completionType = this.getCompletionType(trigger);
        ruleItem.triggerSource = this.getTriggerSource(trigger);
        ruleItem.lastTriggerTime = trigger.lastTriggeredTime;
        ruleItem.lastTriggerStatus = action.executionStatus;
        ruleItem.nextTriggerTime = trigger === null || trigger === void 0 ? void 0 : trigger.nextTime;
        return ruleItem;
    };
    ReportInfoModalCtrl.prototype.getTriggerSource = function (trigger) {
        switch (trigger.type) {
            case 0:
                return (this.language.getElementValue('scheduleRuleSourceTypePeriodicTaskHdr') +
                    ' (' +
                    this.language.getElementValue('scheduleRuleSourceTypePeriodicTaskCheckTimeConditionHdr') +
                    ')');
            case 1:
                return (this.language.getElementValue('scheduleRuleSourceTypePeriodicTaskHdr') +
                    ' (' +
                    this.language.getElementValue('scheduleRuleSourceTypePeriodicTaskCheckParameterConditionHdr') +
                    ')');
            case 3:
                return (this.language.getElementValue('scheduleRuleSourceTypeReportEventHdr') +
                    ' (' +
                    this.language.getElementValue('scheduleRuleSourceTypeSelfReportEventHdr') +
                    ')');
            case 2:
                return (this.language.getElementValue('scheduleRuleSourceTypeReportEventHdr') +
                    ' (' +
                    this.language.getElementValue('scheduleRuleSourceTypeAnotherReportEventHdr') +
                    ')');
        }
    };
    ReportInfoModalCtrl.prototype.getActionTypeName = function (action) {
        switch (action.type) {
            case 5:
                return this.language.getElementValue('reportScheduleRuleActionCreateHdr');
            case 3:
                return this.language.getElementValue('reportScheduleActionSaveToFileHdr');
            case 4:
                return this.language.getElementValue('reportScheduleActionLockHdr');
            case 0:
                return this.language.getElementValue('reportScheduleActionRecalcHdr');
            case 2:
                return this.language.getElementValue('reportScheduleActionExportToMailSettingsHdr');
            case 6:
                return this.language.getElementValue('reportScheduleRuleActionPrintHdr');
            default:
                return '';
        }
    };
    ReportInfoModalCtrl.prototype.getCompletionType = function (trigger) {
        switch (trigger.completionType) {
            case 2:
                return this.language.getElementValue('scheduleRuleCompletionInfiniteHdr');
            case 0:
                return this.language.getElementValue('scheduleRuleCompletionWhenTriggeredHdr');
            case 1:
                return (this.language.getElementValue('scheduleRuleCompletionWhenMultipleTriggeredHdr') +
                    ' (' +
                    trigger.duration +
                    ')');
            default:
                return '';
        }
    };
    ReportInfoModalCtrl.prototype.getTrigger = function (rule) {
        var trigger = rule.timeTrigger ||
            rule.parameterConditionTrigger ||
            rule.selfReportEventTrigger ||
            rule.anotherReportEventTrigger;
        trigger.type = this.getTriggerType(rule);
        trigger.sourceType = this.getTriggerSourceType(rule);
        return trigger;
    };
    ReportInfoModalCtrl.prototype.getTriggerSourceType = function (rule) {
        if (rule.timeTrigger || rule.parameterConditionTrigger) {
            return 0;
        }
        if (rule.selfReportEventTrigger || rule.anotherReportEventTrigger) {
            return 1;
        }
        return null;
    };
    ReportInfoModalCtrl.prototype.getTriggerType = function (rule) {
        if (rule.timeTrigger) {
            return 0;
        }
        if (rule.parameterConditionTrigger) {
            return 1;
        }
        if (rule.selfReportEventTrigger) {
            return 3;
        }
        if (rule.anotherReportEventTrigger) {
            return 2;
        }
        return null;
    };
    ReportInfoModalCtrl.prototype.getAction = function (rule) {
        var action = rule.creationAction ||
            rule.fileExportAction ||
            rule.lockAction ||
            rule.recalcAction ||
            rule.sendingEmailAction ||
            rule.printAction;
        action.type = this.getActionType(rule);
        return action;
    };
    ReportInfoModalCtrl.prototype.getActionType = function (rule) {
        if (rule.creationAction) {
            return 5;
        }
        if (rule.fileExportAction) {
            return 3;
        }
        if (rule.lockAction) {
            return 4;
        }
        if (rule.recalcAction) {
            return 0;
        }
        if (rule.sendingEmailAction) {
            return 2;
        }
        if (rule.printAction) {
            return 6;
        }
    };
    ReportInfoModalCtrl.$inject = [
        '$scope',
        '$modalInstance',
        'language',
        'authentication',
        'permissionService',
        'reportTemplateService',
        'report',
    ];
    return ReportInfoModalCtrl;
}());
angular.module('kamhpp').controller('reportInfoModalCtrl', ReportInfoModalCtrl);
