app.directive('smsReportDropdown', function ($rootScope, $compile, reportSigningChecker, reportTemplateService) {
    return {
        restrict: 'EA',
        priority: 1000,
        scope: {
            variations: '=?',
            value: '=?',
            ts: '=?',
            ident: '=?',
            editable: '=?',
            backlight: '@',
            haschanges: '@?',
            isMultipleChoice: '=?',
            viewMode: '=?'
        },
        link: function (scope, element, attrs) {
            var value = !_.isEmpty(scope.value)
                ? scope.isMultipleChoice
                    ? _.map(scope.value, function (val, key) { return key; })
                    : _.first(Object.keys(scope.value))
                : null;
            scope.data = {
                value: value,
                options: scope.variations,
            };
            scope.reportSigningChecker = reportSigningChecker;
            scope.hasEditPermission = reportTemplateService.checkEditCurrentReportPermission();
            scope.reportValueEdited = function (newValue, oldValue) {
                if (newValue === oldValue) {
                    return;
                }
                var oldReportValue = {};
                var newReportValue = {};
                if (scope.isMultipleChoice) {
                    _.forEach(oldValue, function (key) {
                        oldReportValue[key] = scope.data.options[key];
                    });
                    _.forEach(newValue, function (key) {
                        newReportValue[key] = scope.data.options[key];
                    });
                }
                else {
                    if (scope.data.options[oldValue]) {
                        oldReportValue[oldValue] = scope.data.options[oldValue];
                    }
                    if (scope.data.options[newValue]) {
                        newReportValue[newValue] = scope.data.options[newValue];
                    }
                }
                var change = {
                    newValue: JSON.stringify(newReportValue),
                    oldValue: JSON.stringify(oldReportValue),
                    timestamp: scope.ts,
                    ident: scope.ident,
                };
                $rootScope.$broadcast('reportValueEdited', change);
            };
            scope.onSelectOpen = function () {
                $rootScope.$broadcast('reportValueStartEdit');
            };
            $rootScope.$on('toggleEditable', function (event, isDisabled) {
                scope.editable = !isDisabled;
            });
            var watchDataValueUnreg = scope.$watch('data.value', scope.reportValueEdited);
            var lightweightSelect = "<select\n                                ng-disabled=\"!editable || reportSigningChecker.checkReportSigning() || !hasEditPermission\"\n                                ng-model=\"data.value\"\n                                ng-focus=\"onSelectOpen()\"\n                                ng-options=\"key as option for (key, option) in data.options\"\n                                ".concat(scope.isMultipleChoice ? 'multiple' : '', "\n                                class=\"report-dropdown report-dropdown-lightweight\">\n                            </select>");
            var defaultSelect = "<ui-select \n                            ng-disabled=\"!editable || reportSigningChecker.checkReportSigning() || !hasEditPermission\"\n                            ng-model=\"data.value\"\n                            ng-click=\"onSelectOpen()\"\n                            class=\"report-dropdown report-dropdown-standart\"\n                            ".concat(scope.isMultipleChoice ? 'multiple' : '', ">\n                                <ui-select-match placeholder=\"{{ 'selectDropdownElementPch' | lng }}\">{{ ").concat(scope.isMultipleChoice ? '$item.value' : 'data.options[data.value]', " }}</ui-select-match>\n                                <ui-select-choices \n                                    repeat=\"option.key as (key, option) in data.options | filter: $select.search\">\n                                    <small>{{option.value}}</small>\n                                </ui-select-choices>\n                        </ui-select>");
            var template = _.isUndefined(scope.value)
                ? ''
                : scope.viewMode === 1
                    ? lightweightSelect
                    : defaultSelect;
            scope.element = angular.element($compile(template)(scope));
            $(scope.element[0]).bind('keydown keypress', function (event) {
                if (event.which === 13) {
                    scope.reportValueEdited(scope.data.value);
                    scope.$apply();
                    event.preventDefault();
                }
                if (event.which === 27) {
                    scope.data.value = scope.value;
                    scope.$apply();
                    event.preventDefault();
                }
            });
            element.replaceWith(scope.element);
            var unregistrationDestroyFunc = scope.$on('$destroy', function () {
                watchDataValueUnreg();
                unregistrationDestroyFunc();
            });
        },
    };
});
