var LicenseService = (function () {
    function LicenseService($q, licenseProvider, authentication, permissionService, notificationService, language) {
        this.$q = $q;
        this.licenseProvider = licenseProvider;
        this.authentication = authentication;
        this.permissionService = permissionService;
        this.notificationService = notificationService;
        this.language = language;
        this.permissions = this.permissionService.getAll();
    }
    LicenseService.prototype.getModulesInfo = function () {
        var _this = this;
        var deferred = this.$q.defer();
        if (_.isDefined(this.license)) {
            deferred.resolve(this.getModulesInfoImp());
            return deferred.promise;
        }
        this.licenseProvider.getLicenseSettingsInfo().then(function (license) {
            _this.license = license;
            deferred.resolve(_this.getModulesInfoImp());
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
            deferred.reject(error);
        });
        return deferred.promise;
    };
    LicenseService.prototype.getModulesInfoImp = function () {
        var moduleInfo = {
            isOperationTimeModuleAvailable: this.isOperationTimeModuleAvailable(),
            isReportModuleAvailable: this.isReportModuleAvailable(),
            isSwitchoverFormsModuleAvailable: this.isSwitchoverFormsModuleAvailable()
        };
        return moduleInfo;
    };
    LicenseService.prototype.isReportModuleAvailable = function () {
        return _.isDefined(this.license.modules.reports)
            && (this.authentication.hasPermissionStartWith('ReportView_')
                || this.authentication.hasPermission(this.permissions.ReportAdministrate));
    };
    LicenseService.prototype.isOperationTimeModuleAvailable = function () {
        return _.isDefined(this.license.modules.operationTime)
            && (this.authentication.hasPermission(this.permissions.OperationTimeView)
                || this.authentication.hasPermission(this.permissions.OperationTimeAdmin));
    };
    LicenseService.prototype.isSwitchoverFormsModuleAvailable = function () {
        return _.isDefined(this.license.modules.switchoverForms)
            && (this.authentication.hasPermission(this.permissions.SwitchoverFormView)
                || this.authentication.hasPermission(this.permissions.SwitchoverFormTemplateAdmin));
    };
    LicenseService.$inject = [
        '$q',
        'licenseProvider',
        'authentication',
        'permissionService',
        'notificationService',
        'language'
    ];
    return LicenseService;
}());
angular.module('kamhpp').service('licenseService', LicenseService);
