CREATE TABLE JobsLog (
    Id INTEGER NOT NULL AUTO_INCREMENT,
    Ident TEXT NOT NULL,
    ServerIdent TEXT NOT NULL,
    ExpirationDateTime DATETIME NOT NULL,
    State INTEGER NOT NULL,
    IsManual BOOLEAN NOT NULL,
    StartDate DATETIME NOT NULL,
    EndDate DATETIME NULL,
    IsStateRunning TINYINT(1) AS (IF(State = 0, 1, NULL)) STORED,
    CONSTRAINT PK_JobsLog PRIMARY KEY(Id)
);

/*
В MariaDB нет частичных индексов, поэтому добавляем фиктивный столбец и добавляем его в уникальный индекс
Если State = "Запущена" - столбце равен 1, иначе NULL. Проверяется уникальность State + фиктивный столбец
При проверке уникальности NULL значения считаются различными и не мешают добавлению повторяющихся записей с другими состояниями
*/
CREATE UNIQUE INDEX IX_Running_Ident ON JobsLog (
    Ident,
    IsStateRunning
);
